/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.block.entity.TileEntityMovingBrew;
import net.msrandom.witchery.brewing.Dispersal;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.entity.EntityDroplet;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.BlockUtil;

public class LiquidDispersal
extends Dispersal {
    @Override
    public void onImpactSplashPotion(World world, BrewActionList actionList, RayTraceResult mop, ModifiersImpact modifiers) {
        boolean replaceable;
        BlockPos coord;
        if (mop != null) {
            switch (mop.field_72313_a) {
                case BLOCK: {
                    coord = mop.func_178782_a().func_177972_a(mop.field_178784_b);
                    break;
                }
                case ENTITY: {
                    coord = mop.field_72308_g.func_180425_c();
                    break;
                }
                default: {
                    coord = new BlockPos(modifiers.impactPosition);
                    break;
                }
            }
        } else {
            coord = new BlockPos(modifiers.impactPosition);
        }
        if (replaceable = BlockUtil.isReplaceableBlock(world, coord, (EntityLivingBase)modifiers.thrower)) {
            world.func_175656_a(coord, WitcheryBlocks.BREW_LIQUID.func_176223_P());
            TileEntityMovingBrew liquid = (TileEntityMovingBrew)world.func_175625_s(coord);
            if (liquid != null) {
                liquid.initialize(modifiers, actionList);
            }
        }
    }

    @Override
    public RitualStatus onUpdateRitual(World world, BlockPos pos, BrewActionList actionList, ModifiersRitual modifiers, ModifiersImpact impactModifiers) {
        int maxQuantity;
        WorldServer targetWorld = world.func_73046_m().func_71218_a(modifiers.getDimension());
        int radius = maxQuantity = 16 + 8 * impactModifiers.extent.get();
        int halfQuantity = maxQuantity / 4;
        int height2 = 100;
        double RSQ = radius * radius;
        int quantity = halfQuantity + world.field_73012_v.nextInt(halfQuantity);
        for (int i = 0; i < quantity; ++i) {
            int z;
            int y;
            int x = pos.func_177958_n() - radius + world.field_73012_v.nextInt(2 * radius);
            if (!(pos.func_177954_c((double)x, (double)(y = height2 + world.field_73012_v.nextInt(20)), (double)(z = pos.func_177952_p() - radius + world.field_73012_v.nextInt(2 * radius))) <= RSQ)) continue;
            targetWorld.func_72838_d((Entity)new EntityDroplet((World)targetWorld, x, y, z, actionList));
        }
        return RitualStatus.success(modifiers.pulses >= 10 + impactModifiers.lifetime.get() * 5);
    }
}

