/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import java.util.List;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryCursedBlock;
import net.msrandom.witchery.block.entity.TileEntityCursedBlock;
import net.msrandom.witchery.brewing.Dispersal;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;

public class TriggeredDispersal
extends Dispersal {
    public TriggeredDispersal() {
        super(2, {"brewing"}, {"rituals"});
    }

    @Override
    public void onImpactSplashPotion(World world, BrewActionList actionList, RayTraceResult mop, ModifiersImpact modifiers) {
        boolean replaceable;
        BlockPos coord;
        if (mop != null) {
            switch (mop.field_72313_a) {
                case BLOCK: {
                    coord = mop.func_178782_a().func_177972_a(mop.field_178784_b);
                    break;
                }
                case ENTITY: {
                    coord = mop.field_72308_g.func_180425_c();
                    break;
                }
                default: {
                    coord = new BlockPos(modifiers.impactPosition);
                    break;
                }
            }
        } else {
            coord = new BlockPos(modifiers.impactPosition);
        }
        if (replaceable = WitcheryUtils.isBlockBreakable(world, coord)) {
            TileEntityCursedBlock tile;
            IBlockState state = world.func_180495_p(coord);
            Block block = state.func_177230_c();
            BlockContainer cursed = WitcheryBlocks.CURSED_BLOCKS.get(block);
            if (cursed != null) {
                // empty if block
            }
            if (block == Blocks.field_150430_aB) {
                WitcheryBlocks.CURSED_BUTTON_STONE.replaceButton(world, coord, modifiers, actionList);
                return;
            }
            if (block == Blocks.field_150471_bO) {
                WitcheryBlocks.CURSED_BUTTON_WOOD.replaceButton(world, coord, modifiers, actionList);
                return;
            }
            if (block == Blocks.field_150442_at) {
                WitcheryBlocks.CURSED_LEVER.replaceButton(world, coord, modifiers, actionList);
                return;
            }
            if (block.hasTileEntity(state) && (tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, coord)) != null) {
                tile.updateCurse(modifiers, actionList);
            }
            if (mop != null) {
                switch (mop.field_72313_a) {
                    case BLOCK: {
                        coord = mop.func_178782_a();
                        break;
                    }
                    case ENTITY: {
                        coord = mop.field_72308_g.func_180425_c();
                        break;
                    }
                    default: {
                        coord = new BlockPos(modifiers.impactPosition);
                        break;
                    }
                }
            } else {
                coord = new BlockPos(modifiers.impactPosition);
            }
            if ((block = (state = world.func_180495_p(coord)).func_177230_c()) == Blocks.field_150452_aw) {
                WitcheryBlocks.CURSED_WOODEN_PRESSURE_PLATE.replaceButton(world, coord, modifiers, actionList);
            } else if (block == Blocks.field_150456_au) {
                WitcheryBlocks.CURSED_STONE_PRESSURE_PLATE.replaceButton(world, coord, modifiers, actionList);
            } else if (block == WitcheryBlocks.SNOW_PRESSURE_PLATE) {
                WitcheryBlocks.CURSED_SNOW_PRESSURE_PLATE.replaceButton(world, coord, modifiers, actionList);
            } else if (block == Blocks.field_180413_ao) {
                WitcheryBlocks.CURSED_WOODEN_DOOR.replaceButton(world, coord, modifiers, actionList);
            } else if (block.hasTileEntity(state)) {
                TileEntityCursedBlock tile2;
                BlockPos pos = coord;
                if (block == WitcheryBlocks.CURSED_WOODEN_DOOR) {
                    IBlockState iblockstate;
                    BlockPos blockpos = state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? coord : coord.func_177977_b();
                    IBlockState iBlockState = iblockstate = coord.equals((Object)blockpos) ? state : world.func_180495_p(blockpos);
                    if (iblockstate.func_177230_c() == WitcheryBlocks.CURSED_WOODEN_DOOR) {
                        pos = pos.func_177977_b();
                    }
                }
                if ((tile2 = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, pos)) != null) {
                    tile2.updateCurse(modifiers, actionList);
                }
            }
        }
    }

    @Override
    public RitualStatus onUpdateRitual(World world, BlockPos pos, BrewActionList actionList, ModifiersRitual modifiers, ModifiersImpact impactModifiers) {
        AxisAlignedBB bounds = new AxisAlignedBB(pos.func_177984_a(), pos.func_177982_a(1, 2, 1));
        List items = world.func_72872_a(EntityItem.class, bounds);
        for (EntityItem item : items) {
            NBTTagCompound nbtCurse;
            ItemStack stack = item.func_92059_d();
            if (stack.func_190926_b()) continue;
            if (stack.func_190916_E() > 1) {
                stack = stack.func_77979_a(1);
                EntityItem newEntity = new EntityItem(item.field_70170_p, item.field_70165_t, item.field_70163_u, item.field_70161_v, stack);
                world.func_72838_d((Entity)newEntity);
            }
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbtRoot = stack.func_77978_p();
            AxisAlignedBB playerBounds = bounds.func_72321_a(3.0, 3.0, 3.0);
            List players = world.func_72872_a(EntityPlayer.class, playerBounds);
            boolean catNear = false;
            for (EntityPlayer player : players) {
                if (!Familiars.hasFamiliarPower(player, WitcheryFamiliars.CURSE_MASTERY)) continue;
                catNear = true;
                break;
            }
            if (nbtRoot.func_74764_b("WitcheryCurse") && actionList.equals(new BrewActionList(nbtRoot.func_74775_l("WitcheryCurse").func_150295_c("Curse", 10)))) {
                nbtCurse = nbtRoot.func_74775_l("WitcheryCurse");
                nbtCurse.func_74768_a("Count", nbtCurse.func_74762_e("Count") + (catNear ? 2 : 1));
            } else {
                nbtCurse = new NBTTagCompound();
                nbtCurse.func_74782_a("Curse", (NBTBase)actionList.write());
                nbtCurse.func_74768_a("Count", catNear ? 2 : 1);
                nbtRoot.func_74782_a("WitcheryCurse", (NBTBase)nbtCurse);
            }
            item.field_70170_p.func_184133_a(null, item.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.5f, 0.4f / (item.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(item.field_70165_t, item.field_70163_u, item.field_70161_v, 0.5f, 0.5f, EnumParticleTypes.EXPLOSION_NORMAL), (Entity)item);
            return RitualStatus.success(true);
        }
        return RitualStatus.failure(RitualStatus.Failure.OTHER_FAILURE);
    }

    public static void registerCurseSelector(Function1<Block, WitcheryCursedBlock> function) {
    }
}

