/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.resources.BrewActionManager;
import org.jetbrains.annotations.NotNull;

public class BrewActionList {
    public final List<BrewAction> actions = new ArrayList<BrewAction>();
    public final List<ItemStack> items = new ArrayList<ItemStack>();

    public BrewActionList() {
        this(null);
    }

    public BrewActionList(NBTTagList brewData) {
        if (brewData != null) {
            int count = brewData.func_74745_c();
            for (int i = 0; i < count; ++i) {
                NBTTagCompound nbtItem = brewData.func_150305_b(i);
                ItemStack stack = new ItemStack(nbtItem);
                BrewAction brewAction = BrewActionManager.INSTANCE.getAction(ItemKey.fromStack(stack));
                if (brewAction == null) continue;
                this.actions.add(brewAction);
                this.items.add(stack);
                this.nullifyItems(brewAction);
            }
        }
    }

    public ItemStack getTopItemStack() {
        return this.size() > 0 ? this.items.get(this.size() - 1) : ItemStack.field_190927_a;
    }

    public BrewAction getTopAction() {
        return this.size() > 0 ? this.actions.get(this.size() - 1) : null;
    }

    public int size() {
        return this.actions.size();
    }

    public void nullifyItems(BrewAction brewAction) {
        brewAction.processNullification(this);
    }

    public void applyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers) {
        for (int i = 0; i < this.actions.size(); ++i) {
            BrewAction action = this.actions.get(i);
            if (!action.augmentEffectLevels(modifiers.effectLevel)) continue;
            action.augmentEffectModifiers(modifiers);
            action.applyToEntity(world, targetEntity, modifiers, this.items.get(i));
        }
    }

    public void applyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers) {
        for (int i = 0; i < this.actions.size(); ++i) {
            BrewAction action = this.actions.get(i);
            if (!action.augmentEffectLevels(modifiers.effectLevel)) continue;
            action.augmentEffectModifiers(modifiers);
            action.applyToBlock(world, pos, side, radius, modifiers, this.items.get(i));
        }
    }

    public void applyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers) {
        for (int i = 0; i < this.actions.size(); ++i) {
            BrewAction action = this.actions.get(i);
            if (!action.augmentEffectLevels(modifiers.effectLevel)) continue;
            action.augmentEffectModifiers(modifiers);
            action.applyRitualToBlock(world, pos, side, radius, ritualModifiers, modifiers, this.items.get(i));
        }
    }

    public void applyRitualToEntity(World world, EntityLivingBase targetEntity, ModifiersRitual ritualModifiers, ModifiersEffect modifiers) {
        for (int i = 0; i < this.actions.size(); ++i) {
            BrewAction action = this.actions.get(i);
            if (!action.augmentEffectLevels(modifiers.effectLevel)) continue;
            action.augmentEffectModifiers(modifiers);
            action.applyRitualToEntity(world, targetEntity, ritualModifiers, modifiers, this.items.get(i));
        }
    }

    public boolean isTargetLocationValid(MinecraftServer server, World world, BlockPos pos, BlockPos target, int dimension, ModifiersRitual modifiers) {
        for (BrewAction action : this.actions) {
            if (action.isRitualTargetLocationValid(server, world, pos, target, dimension, modifiers)) continue;
            return true;
        }
        return false;
    }

    public void copy(@NotNull BrewActionList brewActionList) {
        this.items.clear();
        this.actions.clear();
        this.items.addAll(brewActionList.items);
        this.actions.addAll(brewActionList.actions);
    }

    public NBTTagList write() {
        NBTTagList itemList = new NBTTagList();
        for (ItemStack item : this.items) {
            itemList.func_74742_a((NBTBase)item.func_77955_b(new NBTTagCompound()));
        }
        return itemList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BrewActionList) {
            List<ItemStack> otherItems = ((BrewActionList)o).items;
            if (otherItems.size() != this.items.size()) {
                return false;
            }
            for (int i = 0; i < otherItems.size(); ++i) {
                ItemStack item;
                ItemStack otherItem = otherItems.get(i);
                if (ItemStack.func_185132_d((ItemStack)otherItem, (ItemStack)(item = this.items.get(i))) && ItemStack.func_77970_a((ItemStack)otherItem, (ItemStack)item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (ItemStack item : this.items) {
            hash = 31 * hash + item.func_77973_b().hashCode();
            hash = 31 * hash + (item.func_77984_f() ? item.func_77960_j() : item.func_77952_i());
            if (!item.func_77942_o()) continue;
            hash = 31 * hash + item.func_77978_p().hashCode();
        }
        return hash;
    }
}

