/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockAreaMarker;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.brewing.action.BrewActionRitual;
import net.msrandom.witchery.brewing.action.BrewActionSerializer;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.util.EntityUtil;

public class BrewActionRitualEntityTarget
extends BrewActionRitual {
    public BrewActionRitualEntityTarget(ItemKey itemKey, BrewActionSerializer<?> serializer, int powerCost) {
        super(itemKey, serializer, powerCost, false);
    }

    @Override
    public RitualStatus updateRitual(MinecraftServer server, BrewActionList actionList, World world, BlockPos position, ModifiersRitual modifiers, ModifiersImpact impactModifiers, ModifiersEffect effectModifiers) {
        if (actionList.getTopItemStack().func_77973_b() != WitcheryGeneralItems.BOUND_TAGLOCK_KIT) {
            return RitualStatus.failure(RitualStatus.Failure.OTHER_FAILURE);
        }
        EntityLivingBase targetEntity = ItemTaglockKit.getBoundEntity(world, actionList.getTopItemStack(), 0);
        if (targetEntity == null) {
            return RitualStatus.failure(RitualStatus.Failure.OTHER_FAILURE);
        }
        if (!BrewActionRitualEntityTarget.isDistanceAllowed(world, position, targetEntity.func_180425_c(), targetEntity.field_71093_bK, modifiers.covenSize, modifiers.leonard)) {
            return RitualStatus.failure(RitualStatus.Failure.TARGET_TOO_FAR);
        }
        if (actionList.isTargetLocationValid(server, world, position, modifiers.getTarget(), modifiers.getDimension(), modifiers)) {
            return RitualStatus.failure(RitualStatus.Failure.INVALID_CIRCLES);
        }
        ModifiersEffect modifiersEffect = new ModifiersEffect(1.0, 1.0, false, targetEntity.func_174791_d(), true, modifiers.covenSize, EntityUtil.playerOrFake(world, null));
        modifiers.taglockUsed = true;
        boolean isImmune = ItemHunterClothes.isCurseProtectionActive(targetEntity);
        if (!isImmune) {
            isImmune = BlockAreaMarker.AreaMarkerRegistry.instance().isProtectionActive(targetEntity, null);
        }
        if (!isImmune && !WitcheryPoppetItems.voodooProtectionActivated(null, ItemStack.field_190927_a, targetEntity, 1)) {
            actionList.applyRitualToEntity(targetEntity.field_70170_p, targetEntity, modifiers, modifiersEffect);
        }
        return RitualStatus.success(true);
    }
}

