/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action;

import com.google.gson.JsonObject;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.BrewNamePart;
import net.msrandom.witchery.brewing.Dispersal;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.brewing.action.BrewActionSerializer;
import org.jetbrains.annotations.NotNull;

public class DispersalBrewAction
extends BrewAction {
    private final Dispersal dispersal;

    public DispersalBrewAction(ItemKey itemKey, BrewActionSerializer<?> serializer, int powerCost, Dispersal dispersal) {
        super(itemKey, serializer, new BrewNamePart(DispersalBrewAction.getTranslationKey(dispersal), BrewNamePart.Position.PREFIX), powerCost, true, false, null);
        this.dispersal = dispersal;
    }

    private static String getTranslationKey(Dispersal dispersal) {
        ResourceLocation id = (ResourceLocation)Dispersal.REGISTRY.getKey(dispersal);
        if (id == null) {
            return "dispersal.witchery.null";
        }
        return "dispersal." + id.func_110624_b() + "." + id.func_110623_a();
    }

    @Override
    public final void prepareSplashPotion(World world, BrewActionList actionList, ModifiersImpact modifiers) {
        modifiers.setGeneralDispersal(this.dispersal);
    }

    public Dispersal getDispersal() {
        return this.dispersal;
    }

    public static class Serializer
    implements BrewActionSerializer<DispersalBrewAction> {
        @Override
        @NotNull
        public DispersalBrewAction read(@NotNull ItemKey key, int powerCost, @NotNull JsonObject json) {
            return new DispersalBrewAction(key, this, powerCost, (Dispersal)Dispersal.REGISTRY.get(new ResourceLocation(json.get("dispersal").getAsString())));
        }

        @Override
        @NotNull
        public DispersalBrewAction read(@NotNull ItemKey key, int powerCost, @NotNull PacketBuffer buffer) {
            return new DispersalBrewAction(key, this, powerCost, Dispersal.REGISTRY.get(buffer.func_150792_a()));
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull DispersalBrewAction action) {
            buffer.func_150787_b(Dispersal.REGISTRY.getId(action.dispersal));
        }
    }
}

