/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.BrewNamePartModifier;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.brewing.action.BrewActionSerializer;
import net.msrandom.witchery.brewing.action.IncrementBrewAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aBJ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016R\u001f\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lnet/msrandom/witchery/brewing/action/IncrementBrewAction;", "Lnet/msrandom/witchery/brewing/action/BrewAction;", "key", "Lnet/msrandom/witchery/brewing/ItemKey;", "serializer", "Lnet/msrandom/witchery/brewing/action/BrewActionSerializer;", "extent", "", "limit", "", "cost", "integer", "Lkotlin/Function1;", "Lnet/msrandom/witchery/brewing/ModifiersImpact;", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lkotlin/ExtensionFunctionType;", "(Lnet/msrandom/witchery/brewing/ItemKey;Lnet/msrandom/witchery/brewing/action/BrewActionSerializer;ZIILkotlin/jvm/functions/Function1;)V", "getLimit", "()I", "prepareSplashPotion", "", "world", "Lnet/minecraft/world/World;", "actionList", "Lnet/msrandom/witchery/brewing/action/BrewActionList;", "impactModifiers", "Serializer", "WitcheryResurrected"})
public final class IncrementBrewAction
extends BrewAction {
    private final int limit;
    private final Function1<ModifiersImpact, AtomicInteger> integer;

    @Override
    public void prepareSplashPotion(@NotNull World world, @NotNull BrewActionList actionList, @NotNull ModifiersImpact impactModifiers) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(actionList, "actionList");
        Intrinsics.checkParameterIsNotNull(impactModifiers, "impactModifiers");
        AtomicInteger value = this.integer.invoke(impactModifiers);
        if (value.get() < this.limit) {
            value.incrementAndGet();
        }
    }

    public final int getLimit() {
        return this.limit;
    }

    public IncrementBrewAction(@NotNull ItemKey key, @NotNull BrewActionSerializer<?> serializer, boolean extent, int limit, int cost, @NotNull Function1<? super ModifiersImpact, ? extends AtomicInteger> integer) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Intrinsics.checkParameterIsNotNull(integer, "integer");
        super(key, serializer, new BrewNamePartModifier(0, 0, false, extent ? 1 : 0, extent ? 0 : 1), cost, false, !extent, null, 64, null);
        this.limit = limit;
        this.integer = integer;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/msrandom/witchery/brewing/action/IncrementBrewAction$Serializer;", "Lnet/msrandom/witchery/brewing/action/BrewActionSerializer;", "Lnet/msrandom/witchery/brewing/action/IncrementBrewAction;", "extent", "", "(Z)V", "read", "key", "Lnet/msrandom/witchery/brewing/ItemKey;", "powerCost", "", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "action", "Companion", "WitcheryResurrected"})
    public static final class Serializer
    implements BrewActionSerializer<IncrementBrewAction> {
        private final boolean extent;
        private static final Function1<ModifiersImpact, AtomicInteger> EXTENT_UPGRADABLE;
        private static final Function1<ModifiersImpact, AtomicInteger> LINGER_UPGRADABLE;
        public static final Companion Companion;

        @Override
        @NotNull
        public IncrementBrewAction read(@NotNull ItemKey key, int powerCost, @NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull(key, "key");
            Intrinsics.checkParameterIsNotNull(json, "json");
            BrewActionSerializer brewActionSerializer = this;
            JsonElement jsonElement = json.get("limit");
            Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json[\"limit\"]");
            return new IncrementBrewAction(key, brewActionSerializer, this.extent, jsonElement.getAsInt(), powerCost, this.extent ? EXTENT_UPGRADABLE : LINGER_UPGRADABLE);
        }

        @Override
        @NotNull
        public IncrementBrewAction read(@NotNull ItemKey key, int powerCost, @NotNull PacketBuffer buffer) {
            Intrinsics.checkParameterIsNotNull(key, "key");
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            return new IncrementBrewAction(key, this, this.extent, buffer.func_150792_a(), powerCost, this.extent ? EXTENT_UPGRADABLE : LINGER_UPGRADABLE);
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull IncrementBrewAction action) {
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Intrinsics.checkParameterIsNotNull(action, "action");
            buffer.func_150787_b(action.getLimit());
        }

        public Serializer(boolean extent) {
            this.extent = extent;
        }

        static {
            Companion = new Companion(null);
            EXTENT_UPGRADABLE = Companion.EXTENT_UPGRADABLE.1.INSTANCE;
            LINGER_UPGRADABLE = Companion.LINGER_UPGRADABLE.1.INSTANCE;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/msrandom/witchery/brewing/action/IncrementBrewAction$Serializer$Companion;", "", "()V", "EXTENT_UPGRADABLE", "Lkotlin/Function1;", "Lnet/msrandom/witchery/brewing/ModifiersImpact;", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lkotlin/ExtensionFunctionType;", "LINGER_UPGRADABLE", "WitcheryResurrected"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

