/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.familiar.Familiar;
import net.msrandom.witchery.entity.familiar.Familiars;

public class AnimalAttractionBrewEffect
extends BrewActionEffect {
    public AnimalAttractionBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        double radius = (modifiers.getStrength() + 1) * 16;
        double radiusSq = radius * radius;
        AxisAlignedBB bounds = targetEntity.func_174813_aQ().func_72321_a(radius, radius, radius);
        for (EntityLivingBase otherEntity : world.func_72872_a(EntityLivingBase.class, bounds)) {
            if (otherEntity == targetEntity || !(otherEntity.func_70068_e((Entity)targetEntity) < radiusSq)) continue;
            if (Familiars.canBeFamiliar((Entity)otherEntity)) {
                Familiar<EntityLivingBase> familiar = Familiars.getFamiliarInstance(otherEntity);
                if (familiar.isFamiliar()) continue;
                EntityLivingBase entity = familiar.getEntity();
                Entity owner = familiar.func_70902_q();
                if (!modifiers.inverted) {
                    if (owner == null) {
                        familiar.setFamiliarTamed(true);
                        if (entity instanceof EntityLiving) {
                            EntityLiving living2 = (EntityLiving)entity;
                            living2.func_70661_as().func_75499_g();
                            living2.func_70624_b(null);
                            living2.func_70606_j(20.0f);
                        }
                        familiar.setFamiliarOwnerId(targetEntity.func_110124_au());
                        world.func_72960_a((Entity)entity, (byte)7);
                    }
                } else if (targetEntity != owner) {
                    familiar.setFamiliarTamed(false);
                    if (entity instanceof EntityLiving) {
                        EntityLiving living3 = (EntityLiving)entity;
                        living3.func_70661_as().func_75499_g();
                        living3.func_70624_b(null);
                    }
                    familiar.setFamiliarOwnerId(null);
                    world.func_72960_a((Entity)entity, (byte)6);
                }
            } else if (otherEntity instanceof EntityTameable) {
                EntityTameable tameable = (EntityTameable)otherEntity;
                EntityLivingBase owner = tameable.func_70902_q();
                if (!modifiers.inverted) {
                    if (owner == null) {
                        tameable.func_70903_f(true);
                        tameable.func_70661_as().func_75499_g();
                        tameable.func_70624_b(null);
                        tameable.func_70606_j(20.0f);
                        tameable.func_184754_b(targetEntity.func_110124_au());
                        world.func_72960_a((Entity)tameable, (byte)7);
                    }
                } else if (targetEntity != owner) {
                    tameable.func_70903_f(false);
                    tameable.func_70661_as().func_75499_g();
                    tameable.func_70624_b(null);
                    tameable.func_184754_b(null);
                    world.func_72960_a((Entity)tameable, (byte)6);
                }
            }
            if (!(otherEntity instanceof EntityLiving)) continue;
            EntityLiving entity = (EntityLiving)otherEntity;
            if (!modifiers.inverted) {
                if (entity.func_70661_as().func_75492_a(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, 1.0)) continue;
                entity.func_70661_as().func_75494_a((Entity)targetEntity);
                continue;
            }
            int RANGE = 6;
            int newX = MathHelper.func_76128_c((double)targetEntity.field_70165_t) + (world.field_73012_v.nextBoolean() ? 1 : -1) * (RANGE + world.field_73012_v.nextInt(RANGE));
            int newZ = MathHelper.func_76128_c((double)targetEntity.field_70161_v) + (world.field_73012_v.nextBoolean() ? 1 : -1) * (RANGE + world.field_73012_v.nextInt(RANGE));
            int newY = 62;
            while (!world.func_175623_d(new BlockPos(newX, newY + 1, newZ))) {
                ++newY;
            }
            if (entity.func_70661_as().func_75492_a((double)newX, (double)newY, (double)newZ, 1.0)) continue;
            entity.func_70634_a(0.5 + (double)newX, (double)newY, 0.5 + (double)newZ);
        }
    }
}

