/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.passive.EntityOwl;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class BodegaBrewEffect
extends BrewActionEffect {
    public BodegaBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (modifiers.caster != null && Familiars.hasFamiliarPower(modifiers.caster, WitcheryFamiliars.BROOM_MASTERY) && !(targetEntity instanceof EntityOwl) && !(targetEntity instanceof EntityBat)) {
            int BIRD_COUNT = (modifiers.powerScalingFactor != 1.0 || modifiers.isGlancing ? 1 : 3 + world.field_73012_v.nextInt(2)) + modifiers.getStrength();
            if (modifiers.powerScalingFactor == 1.0 && !modifiers.isGlancing || world.field_73012_v.nextInt(20) == 0) {
                this.explodeBirds(world, targetEntity, BIRD_COUNT);
            }
        }
    }

    private void explodeBirds(World world, EntityLivingBase victim, int birds) {
        for (int i = 0; i < birds; ++i) {
            EntityOwl owl2 = new EntityOwl(world);
            owl2.func_70012_b(victim.field_70165_t - 2.0 + (double)world.field_73012_v.nextInt(5), victim.field_70163_u + (double)victim.field_70131_O + 1.0 + (double)world.field_73012_v.nextInt(2), victim.field_70161_v - 2.0 + (double)world.field_73012_v.nextInt(5), 0.0f, 0.0f);
            owl2.func_70624_b(victim);
            owl2.setLifetime(400);
            world.func_72838_d((Entity)owl2);
            owl2.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(owl2.field_70165_t, owl2.field_70163_u, owl2.field_70161_v, 1.0f, 1.0f, EnumParticleTypes.PORTAL), (Entity)owl2);
        }
    }
}

