/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.item.BiomeHolder;

public class BrewActionBiomeChange
extends BrewActionEffect {
    public BrewActionBiomeChange(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    public void prepareSplashPotion(World world, BrewActionList actionList, ModifiersImpact modifiers) {
        super.prepareSplashPotion(world, actionList, modifiers);
        modifiers.setOnlyInstant();
    }

    @Override
    protected void doApplyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        Biome biome = ((BiomeHolder)stack.func_77973_b()).getBiome(stack);
        int maxRadius = 16 + modifiers.getStrength() * 16;
        this.changeBiome(world, pos, maxRadius, biome);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        Biome biome = ((BiomeHolder)actionStack.func_77973_b()).getBiome(actionStack);
        this.changeBiome(world, pos, 1 + modifiers.getStrength(), biome);
    }

    protected void changeBiome(World world, BlockPos pos, int radius, Biome biome) {
        HashMap<ChunkPos, byte[]> chunkMap = new HashMap<ChunkPos, byte[]>();
        this.drawFilledCircle(world, pos, radius, chunkMap, biome);
        for (Map.Entry<ChunkPos, byte[]> entry2 : chunkMap.entrySet()) {
            ChunkPos chunkPos = entry2.getKey();
            Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
            chunk.func_76616_a(entry2.getValue());
            chunk.func_76630_e();
            SPacketChunkData packet2 = new SPacketChunkData(chunk, 65535);
            for (EntityPlayer playerEntity : world.field_73010_i) {
                ((EntityPlayerMP)playerEntity).field_71135_a.func_147359_a((Packet)packet2);
            }
        }
    }

    private void drawFilledCircle(World world, BlockPos pos, int radius, HashMap<ChunkPos, byte[]> chunkMap, Biome biome) {
        if (radius == 1) {
            this.drawLine(world, pos, pos, chunkMap, biome);
        } else {
            int x = --radius;
            int radiusError = 1 - x;
            for (int z = 0; x >= z; ++z) {
                this.drawLine(world, pos.func_177982_a(-x, 0, z), pos.func_177982_a(x, 0, z), chunkMap, biome);
                this.drawLine(world, pos.func_177982_a(-z, 0, x), pos.func_177982_a(z, 0, x), chunkMap, biome);
                this.drawLine(world, pos.func_177982_a(-x, 0, -z), pos.func_177982_a(x, 0, -z), chunkMap, biome);
                this.drawLine(world, pos.func_177982_a(-z, 0, -x), pos.func_177982_a(z, 0, -x), chunkMap, biome);
                if (radiusError < 0) {
                    radiusError += 2 * z + 1;
                    continue;
                }
                radiusError += 2 * (z - --x + 1);
            }
        }
    }

    private void drawLine(World world, BlockPos x1, BlockPos x2, HashMap<ChunkPos, byte[]> chunkMap, Biome biome) {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)x1, (BlockPos)x2)) {
            ChunkPos coord = new ChunkPos(pos);
            byte[] map2 = chunkMap.get(coord);
            if (map2 == null) {
                Chunk chunk = world.func_175726_f(pos);
                map2 = (byte[])chunk.func_76605_m().clone();
                chunkMap.put(coord, map2);
            }
            map2[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)biome);
            if (biome.func_76727_i() != 0.0f || world.func_180495_p(pos = world.func_175672_r(pos)).func_177230_c() != Blocks.field_150431_aC) continue;
            world.func_175698_g(pos);
        }
    }
}

