/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.EntityUtil;

public class BrewActionPlanting
extends BrewActionEffect {
    public BrewActionPlanting(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, final ModifiersEffect modifiers, ItemStack stack) {
        int R = radius + modifiers.getStrength();
        double RADIUS_SQ = R * R;
        AxisAlignedBB areaOfEffect = new AxisAlignedBB(pos.func_177982_a(-R, -R, -R), pos.func_177982_a(R, R, R));
        List entities = world.func_72872_a(EntityItem.class, areaOfEffect);
        if (!entities.isEmpty()) {
            final ArrayList<ItemStack> seeds = new ArrayList<ItemStack>();
            for (EntityItem itemEntity : entities) {
                ItemStack seedStack = itemEntity.func_92059_d();
                if (!(itemEntity.func_174818_b(pos) <= RADIUS_SQ) || !(seedStack.func_77973_b() instanceof IPlantable)) continue;
                seeds.add(seedStack);
            }
            new BlockActionCircle(){

                @Override
                public void onBlock(World world, BlockPos p) {
                    int index = seeds.size() - 1;
                    if (index >= 0) {
                        ItemStack seed = (ItemStack)seeds.get(index);
                        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)p.func_177979_c(2), (BlockPos)p.func_177981_b(2))) {
                            IBlockState block = world.func_180495_p(pos);
                            EntityPlayer player = EntityUtil.playerOrFake(world, (EntityLivingBase)modifiers.caster);
                            ItemStack old = player.func_184614_ca();
                            player.func_184611_a(EnumHand.MAIN_HAND, seed);
                            if (block.func_185904_a().func_76220_a() && world.func_175623_d(pos.func_177984_a()) && seed.func_77973_b().func_180614_a(player, world, pos, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS) {
                                player.func_184611_a(EnumHand.MAIN_HAND, old);
                                break;
                            }
                            player.func_184611_a(EnumHand.MAIN_HAND, old);
                        }
                        if (seed.func_190926_b()) {
                            seeds.remove(index);
                        }
                    }
                }
            }.processFilledCircle(world, pos, radius + modifiers.getStrength());
        }
    }
}

