/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.WitcheryUtils;

public class BrewActionRaiseLand
extends BrewActionEffect {
    public BrewActionRaiseLand(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyRitualToBlock(World world, BlockPos p, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        int r = (modifiers.getStrength() + 1) * 2;
        int rsq = r * r;
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)p.func_177982_a(-r, -r, -r), (BlockPos)p.func_177982_a(r, r, r))) {
            int z;
            int x = pos.func_177958_n() - p.func_177958_n();
            if (x * x + (z = pos.func_177952_p() - p.func_177952_p()) * z >= rsq) continue;
            this.doApplyToBlock(world, pos, EnumFacing.UP, 1, modifiers, stack);
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        this.doApplyToBlock(world, targetEntity.func_180425_c().func_177977_b(), EnumFacing.UP, 1, modifiers, stack);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        while (!world.func_175623_d(pos.func_177984_a()) && pos.func_177956_o() < 255) {
            pos = pos.func_177984_a();
        }
        if (WitcheryUtils.canBreak(world.func_180495_p(pos)) && WitcheryUtils.isBlockBreakable(world, pos)) {
            int height2 = (modifiers.getStrength() + 1) * (modifiers.ritualised ? 2 : 3);
            if (!world.field_72995_K) {
                for (int i = 0; i < height2; ++i) {
                    BlockPos p = pos.func_177979_c(i);
                    IBlockState block = world.func_180495_p(p);
                    world.func_175698_g(p);
                    world.func_180501_a(p.func_177981_b(height2), block, 3);
                }
            }
            AxisAlignedBB bounds = new AxisAlignedBB(pos, pos.func_177982_a(1, 2, 1));
            List list2 = world.func_72872_a(EntityLivingBase.class, bounds);
            double x = (double)pos.func_177958_n() + 0.5;
            double y = pos.func_177956_o() + height2 + 1;
            double z = (double)pos.func_177952_p() + 0.5;
            for (EntityLivingBase entity : list2) {
                entity.func_70634_a(x, y, z);
            }
        }
    }
}

