/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.util.WitcheryUtils;

public class BrewActionRaising
extends BrewActionEffect {
    public BrewActionRaising(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    public static void raiseDead(World world, BlockPos coord, int strength, EntityPlayer raiser, int lifetime) {
        int drops = 6;
        BrewActionRaising.raiseUndead(world, coord, raiser, lifetime);
        int extraCount = 0;
        if (strength >= 1 && world.field_73012_v.nextDouble() < (double)strength * 0.5) {
            ++extraCount;
        }
        if (strength >= 2 && world.field_73012_v.nextDouble() < (double)strength * 0.25) {
            ++extraCount;
        }
        if (strength >= 3 && world.field_73012_v.nextDouble() < (double)strength * 0.25) {
            ++extraCount;
        }
        block0: for (int i = 0; i < extraCount; ++i) {
            int minY = coord.func_177956_o() - drops;
            BlockPos pos = coord.func_177981_b(drops);
            while (pos.func_177956_o() >= minY) {
                if (world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a() && world.func_175623_d(pos)) {
                    BrewActionRaising.raiseUndead(world, pos, raiser, lifetime);
                    continue block0;
                }
                pos = pos.func_177977_b();
            }
        }
    }

    private static void raiseUndead(World world, BlockPos coord, EntityPlayer thrower, int lifetime) {
        if (!world.field_72995_K) {
            EntityLiving undeadEntity = BrewActionRaising.createUndeadCreature(world);
            undeadEntity.func_70012_b(0.5 + (double)coord.func_177958_n(), 0.1 + (double)coord.func_177956_o(), 0.5 + (double)coord.func_177952_p(), 0.0f, 0.0f);
            undeadEntity.func_180482_a(world.func_175649_E(undeadEntity.func_180425_c()), null);
            undeadEntity.func_110163_bv();
            WitcheryUtils.setNoDrops((EntityLivingBase)undeadEntity, true);
            if (lifetime > 0) {
                undeadEntity.func_70690_d(new PotionEffect(WitcheryPotionEffects.MORTAL_COIL, lifetime));
            }
            if (thrower != null) {
                PotionEnslaved.setEnslaverForMob(undeadEntity, thrower);
            }
            world.func_72838_d((Entity)undeadEntity);
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(undeadEntity.field_70165_t, undeadEntity.field_70163_u, undeadEntity.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SMOKE_LARGE), (Entity)undeadEntity);
        }
    }

    private static EntityLiving createUndeadCreature(World world) {
        double value = world.field_73012_v.nextDouble();
        if (value < 0.6) {
            return new EntityZombie(world);
        }
        if (value < 0.97) {
            return new EntitySkeleton(world);
        }
        return new EntityPigZombie(world);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        BrewActionRaising.raiseDead(world, pos.func_177972_a(side), modifiers.ritualised ? 0 : modifiers.getStrength(), modifiers.caster, modifiers.ritualised ? (modifiers.getStrength() + 1) * 200 : 0);
    }
}

