/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.BrewActionRitual;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.DrawCallback;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.potion.PotionEnderInhibition;
import net.msrandom.witchery.util.TeleportationUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

public class BrewActionTranspose
extends BrewActionEffect {
    private static final ResourceLocation CIRCLE = new ResourceLocation("witchery", "textures/gui/circles_mpurple.png");

    public BrewActionTranspose(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    public boolean isRitualTargetLocationValid(MinecraftServer server, World world, BlockPos pos, BlockPos target, int dimension, ModifiersRitual modifiers) {
        return BrewActionRitual.isDistanceAllowed(world, pos, target, dimension, modifiers.covenSize, modifiers.leonard) && WitcheryUtils.isCircleGlyph((IBlockAccess)server.func_71218_a(dimension), target, 3, WitcheryBlocks.GLYPH_OTHERWHERE);
    }

    @Override
    protected void doApplyRitualToBlock(World world, BlockPos p, EnumFacing side, int radius, ModifiersRitual ritual, ModifiersEffect modifiers, ItemStack stack) {
        int height2 = 3;
        BlockPos midSource = ritual.getTarget();
        BlockPos midTarget = ritual.getTarget(1);
        WorldServer worldSource = world.func_73046_m().func_71218_a(ritual.getDimension());
        WorldServer worldTarget = world.func_73046_m().func_71218_a(ritual.getDimension(1));
        for (int y = 0; y < height2; ++y) {
            for (int x = -height2; x <= height2; ++x) {
                for (int z = -height2; z <= height2; ++z) {
                    if (x * x + y * z >= height2 * height2) continue;
                    BlockPos s = midSource.func_177982_a(x, y, z);
                    BlockPos t = midTarget.func_177982_a(x, y, z);
                    IBlockState block = world.func_180495_p(s);
                    if (!WitcheryUtils.isBlockBreakable((World)worldSource, s, block) || !WitcheryUtils.canBreak(block) || !WitcheryUtils.canBreak(world.func_180495_p(t)) || !WitcheryUtils.isBlockBreakable((World)worldTarget, t)) continue;
                    world.func_180501_a(t, block, 3);
                    world.func_175698_g(s);
                }
            }
        }
    }

    @Override
    protected void doApplyRitualToEntity(World world, EntityLivingBase targetEntity, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        if (PotionEnderInhibition.canTeleport((Entity)targetEntity, 3)) {
            BlockPos target = ritualModifiers.getTarget();
            TeleportationUtil.teleportToLocation(target, ritualModifiers.getDimension(), (Entity)targetEntity, true);
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (PotionEnderInhibition.canTeleport((Entity)targetEntity, modifiers.getStrength())) {
            this.teleportAway(world, modifiers.impactLocation != null ? new BlockPos(modifiers.impactLocation) : new BlockPos((Entity)targetEntity), targetEntity, 10 * (modifiers.getStrength() + 1));
        }
    }

    private void teleportAway(World world, BlockPos pos, EntityLivingBase entity, int range) {
        if (!world.field_72995_K) {
            int doubleDistance = range * 2;
            for (int attempt = 0; attempt < 3; ++attempt) {
                pos = pos.func_177982_a(world.field_73012_v.nextInt(doubleDistance) - range, 0, world.field_73012_v.nextInt(doubleDistance) - range);
                int maxY = Math.min(pos.func_177956_o() + 64, 250);
                while (!world.func_180495_p(pos).func_185904_a().func_76220_a() && pos.func_177956_o() >= 0) {
                    pos = pos.func_177977_b();
                }
                while (!(world.func_180495_p(pos).func_185904_a().func_76220_a() && world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2)) && world.func_175623_d(pos.func_177981_b(3)) || pos.func_177956_o() >= maxY)) {
                    pos = pos.func_177984_a();
                }
                if (pos.func_177956_o() <= 0 || pos.func_177956_o() >= maxY) continue;
                TeleportationUtil.teleportToLocation(pos.func_177984_a(), world.field_73011_w.getDimension(), (Entity)entity, true);
                break;
            }
        }
    }

    @Override
    public void drawPage(int page, int baseHeight2, @NotNull DrawCallback drawCentered) {
        if (page == 2) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(CIRCLE);
            drawCentered.invoke(baseHeight2, 32, 32);
        }
    }
}

