/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.PotionBrewEffect;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.util.BlockActionReplaceSphere;
import net.msrandom.witchery.util.WitcheryUtils;

public class ColdBrewEffect
extends BrewActionEffect {
    public ColdBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        if (WitcheryUtils.isBlockBreakable(world, pos)) {
            new BlockActionReplaceSphere(){

                @Override
                protected boolean onShouldReplace(IBlockState block) {
                    return block.func_185904_a() == Material.field_151586_h;
                }

                @Override
                protected void onReplaceBlock(World world, BlockPos pos) {
                    world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                }
            }.replaceBlocks(world, pos, 2 + 2 * modifiers.getStrength());
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        PotionBrewEffect.applyPotionEffect(targetEntity, modifiers, WitcheryPotionEffects.CHILLED, 3600, modifiers.noParticles, modifiers.caster);
    }
}

