/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.WitcheryUtils;

public class CureDebuffsBrewEffect
extends BrewActionEffect {
    public CureDebuffsBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
        Collection effects2 = targetEntity.func_70651_bq();
        for (PotionEffect effect : effects2) {
            Potion potion = effect.func_188419_a();
            if (!WitcheryPotion.isDebuff(potion)) continue;
            if (WitcheryPotion.isCurable(potion) && effect.func_76458_c() <= modifiers.getStrength()) {
                effectsToRemove.add(potion);
            }
            if (potion != WitcheryPotionEffects.DISEASED || modifiers.getStrength() < 2) continue;
            effectsToRemove.add(potion);
            if (targetEntity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)targetEntity;
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                playerEx.clearCachedIncurablePotionEffect(potion);
            }
            if (modifiers.getStrength() < 3) continue;
            int R = 9;
            BlockPos coord = targetEntity.func_180425_c();
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)coord.func_177982_a(-R, -R, -R), (BlockPos)coord.func_177982_a(R, R, R))) {
                Block block = world.func_180495_p(pos).func_177230_c();
                if (block != WitcheryBlocks.DISEASE) continue;
                world.func_175698_g(pos);
            }
        }
        for (Potion potion2 : effectsToRemove) {
            targetEntity.func_184589_d(potion2);
        }
    }

    @Override
    protected void doApplyRitualToEntity(World world, EntityLivingBase targetEntity, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
        ArrayList<PotionEffect> effectsToAdd = new ArrayList<PotionEffect>();
        Collection effects2 = targetEntity.func_70651_bq();
        int modifiedStrength = modifiers.getStrength();
        for (PotionEffect effect : effects2) {
            Potion potion = effect.func_188419_a();
            if (!WitcheryPotion.isDebuff(potion)) continue;
            if (effect.func_76458_c() < modifiedStrength) {
                effectsToRemove.add(potion);
                if (world.field_73012_v.nextDouble() >= 0.01) continue;
                effectsToAdd.add(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c() + 1));
                continue;
            }
            if (effect.func_76458_c() == modifiedStrength) {
                effectsToRemove.add(potion);
                if (world.field_73012_v.nextDouble() >= 0.25) continue;
                effectsToAdd.add(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c() + 1));
                continue;
            }
            effectsToRemove.add(potion);
            if (world.field_73012_v.nextDouble() >= 0.75) continue;
            effectsToAdd.add(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c() + 1));
        }
        for (Potion potion2 : effectsToRemove) {
            targetEntity.func_184589_d(potion2);
            if (WitcheryPotion.isCurable(potion2) || !(targetEntity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)targetEntity;
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            playerEx.clearCachedIncurablePotionEffect(potion2);
        }
        for (PotionEffect potionEffect : effectsToAdd) {
            targetEntity.func_70690_d(potionEffect);
        }
        if (effectsToAdd.isEmpty()) {
            targetEntity.field_70170_p.func_184133_a(null, targetEntity.func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.5f, 0.4f / (targetEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SPELL), (Entity)targetEntity);
        } else {
            targetEntity.field_70170_p.func_184133_a(null, targetEntity.func_180425_c(), SoundEvents.field_187525_aO, SoundCategory.PLAYERS, 0.5f, 0.4f / (targetEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SPELL_MOB), (Entity)targetEntity);
        }
    }
}

