/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.WitcheryUtils;

public class DissipateBrewEffect
extends BrewActionEffect {
    public DissipateBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        if (targetEntity instanceof EntitySummonedUndead) {
            targetEntity.func_70097_a(DamageSource.func_76354_b((Entity)modifiers.caster, (Entity)modifiers.caster), (float)(modifiers.getStrength() + 1) * 5.0f);
        }
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, final int radius, final ModifiersEffect modifiers, ItemStack stack) {
        new BlockActionCircle(){

            @Override
            public void onBlock(World world, BlockPos p) {
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)p.func_177979_c(radius), (BlockPos)p.func_177981_b(radius))) {
                    IFluidBlock fluidBlock;
                    IBlockState state = world.func_180495_p(pos);
                    if (state.func_177230_c() == WitcheryBlocks.BREW_GAS) {
                        if (!WitcheryUtils.isBlockBreakable(world, pos, state) || !WitcheryUtils.canBreak(state)) continue;
                        world.func_175698_g(pos);
                        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, modifiers.caster.func_184176_by(), 1.0f, 2.0f);
                        continue;
                    }
                    if (!(state instanceof IFluidBlock) || modifiers.getStrength() < 1 || (fluidBlock = (IFluidBlock)state).getFluid() == null || !fluidBlock.getFluid().isGaseous() || !WitcheryUtils.isBlockBreakable(world, pos, state) || !WitcheryUtils.canBreak(state)) continue;
                    world.func_175698_g(pos);
                    world.func_184133_a(null, pos, SoundEvents.field_187646_bt, modifiers.caster.func_184176_by(), 1.0f, 2.0f);
                }
            }
        }.processFilledCircle(world, pos, radius);
    }
}

