/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.PotionBrewEffect;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityEnt;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.util.BlockActionSphere;
import net.msrandom.witchery.util.BlockUtil;

public class IcyShellBrewEffect
extends BrewActionEffect {
    public IcyShellBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        this.createSphere(world, modifiers, BlockUtil.getClosestPlantableBlock(world, pos, side, (EntityLivingBase)modifiers.caster));
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        boolean resistent;
        boolean bl = resistent = targetEntity instanceof EntityDemon || targetEntity instanceof EntityBlaze || !targetEntity.func_184222_aU() || targetEntity instanceof EntityEnt || targetEntity instanceof EntityIronGolem;
        if (!resistent) {
            PotionBrewEffect.applyPotionEffect(targetEntity, modifiers, WitcheryPotionEffects.CHILLED, 200, modifiers.noParticles, modifiers.caster);
            if (!modifiers.isGlancing) {
                this.createSphere(world, modifiers, targetEntity.func_180425_c());
            }
        } else if (!targetEntity.field_70170_p.field_73011_w.func_177495_o()) {
            BlockUtil.setBlockIfReplaceable(world, targetEntity.func_180425_c(), (Block)Blocks.field_150358_i);
        }
    }

    public void createSphere(final World world, ModifiersEffect modifiers, final BlockPos coord) {
        if (coord != null) {
            final int iceRadius = modifiers.getStrength() + (modifiers.getStrength() > 3 ? 2 : 1);
            new BlockActionSphere(){

                @Override
                protected void onBlock(World world2, BlockPos pos) {
                    BlockUtil.setBlockIfReplaceable(world2, pos, (Block)WitcheryBlocks.PERPETUAL_ICE);
                }

                @Override
                protected void onComplete() {
                    this.fillWith(world, coord, iceRadius, (Block)WitcheryBlocks.PERPETUAL_ICE);
                }
            }.drawHollowSphere(world, coord, iceRadius);
        }
    }
}

