/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class LevellingBrewEffect
extends BrewActionEffect {
    public LevellingBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int r, final ModifiersEffect modifiers, ItemStack actionStack) {
        BlockPos p = modifiers.ritualised ? pos.func_177977_b() : pos;
        int radius = modifiers.ritualised ? r + (modifiers.getStrength() + 1) * 3 : r;
        final AtomicInteger dirt = new AtomicInteger();
        final AtomicInteger stone = new AtomicInteger();
        final AtomicInteger sand = new AtomicInteger();
        final AtomicInteger sandstone = new AtomicInteger();
        final AtomicInteger netherrack = new AtomicInteger();
        final AtomicInteger endstone = new AtomicInteger();
        final int s = modifiers.getStrength();
        int defaultAmount = modifiers.ritualised ? 64 + 32 * modifiers.getStrength() : 16;
        Block hitBlock = world.func_180495_p(p).func_177230_c();
        if (hitBlock == Blocks.field_150346_d) {
            dirt.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.field_150348_b) {
            stone.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.field_150354_m) {
            sand.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.field_150322_A) {
            sandstone.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.field_150424_aL) {
            netherrack.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.field_150377_bs) {
            endstone.addAndGet(defaultAmount);
        }
        new BlockActionCircle(){

            @Override
            public void onBlock(World world, BlockPos p) {
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)p.func_177984_a(), (BlockPos)p.func_177981_b(s + 4))) {
                    IBlockState state = world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150350_a || !WitcheryUtils.isBlockBreakable(world, pos, state) || !WitcheryUtils.canBreak(state)) continue;
                    if (block == Blocks.field_150348_b) {
                        stone.incrementAndGet();
                    } else if (block == Blocks.field_150354_m) {
                        sand.incrementAndGet();
                    } else if (block == Blocks.field_150322_A) {
                        sandstone.incrementAndGet();
                    } else if (block == Blocks.field_150424_aL) {
                        netherrack.incrementAndGet();
                    } else if (block == Blocks.field_150377_bs) {
                        endstone.incrementAndGet();
                    } else {
                        dirt.incrementAndGet();
                    }
                    world.func_175698_g(pos);
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, pos);
                }
            }
        }.processFilledCircle(world, p, radius);
        for (final BlockPos n : BlockPos.func_177980_a((BlockPos)p.func_177979_c(4 + s), (BlockPos)p)) {
            new BlockActionCircle(){

                @Override
                public void onBlock(World world, BlockPos pos) {
                    if (BlockUtil.isReplaceableBlock(world, n, (EntityLivingBase)modifiers.caster)) {
                        if (endstone.get() > 0) {
                            endstone.decrementAndGet();
                            world.func_175656_a(n, Blocks.field_150377_bs.func_176223_P());
                        } else if (netherrack.get() > 0) {
                            netherrack.decrementAndGet();
                            world.func_175656_a(n, Blocks.field_150424_aL.func_176223_P());
                        } else if (sandstone.get() > 0) {
                            sandstone.decrementAndGet();
                            world.func_175656_a(n, Blocks.field_150322_A.func_176223_P());
                        } else if (sand.get() > 0) {
                            sand.decrementAndGet();
                            world.func_175656_a(n, Blocks.field_150354_m.func_176223_P());
                        } else if (stone.get() > 0) {
                            stone.decrementAndGet();
                            world.func_175656_a(n, Blocks.field_150348_b.func_176223_P());
                        } else {
                            if (dirt.get() <= 0) {
                                return;
                            }
                            dirt.decrementAndGet();
                            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                        }
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)n.func_177958_n(), (double)n.func_177956_o(), (double)n.func_177952_p(), 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, n, 16.0);
                    }
                }
            }.processFilledCircle(world, p, radius);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, modifiers.caster.func_184176_by(), 1.0f, 2.0f);
    }
}

