/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.potion.WitcheryPotion;

public class StealBuffsBrewEffect
extends BrewActionEffect {
    public StealBuffsBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        double radius = (modifiers.getStrength() + 1) * 8;
        double radiusSq = radius * radius;
        AxisAlignedBB bounds = targetEntity.func_174813_aQ().func_72321_a(radius, radius, radius);
        int maxBuffs = (int)Math.ceil(((double)modifiers.getStrength() + 1.0) * 2.0 * modifiers.powerScalingFactor);
        List entities = world.func_72872_a(EntityLivingBase.class, bounds);
        targetEntity = modifiers.caster;
        for (EntityLivingBase otherEntity : entities) {
            if (otherEntity == targetEntity || !(otherEntity.func_70068_e((Entity)targetEntity) < radiusSq)) continue;
            Collection potionEffects = otherEntity.func_70651_bq();
            ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
            for (PotionEffect effect : potionEffects) {
                Potion potion = effect.func_188419_a();
                if (WitcheryPotion.isDebuff(potion) || !WitcheryPotion.isCurable(potion) || effect.func_76458_c() > modifiers.getStrength()) continue;
                PotionEffect myEffect = targetEntity.func_70660_b(potion);
                if (myEffect != null) {
                    if (myEffect.func_76459_b() <= effect.func_76459_b() && myEffect.func_76458_c() <= effect.func_76458_c()) {
                        targetEntity.func_70690_d(new PotionEffect(effect));
                        effectsToRemove.add(effect.func_188419_a());
                        --maxBuffs;
                    }
                } else {
                    targetEntity.func_70690_d(new PotionEffect(effect));
                    effectsToRemove.add(effect.func_188419_a());
                    --maxBuffs;
                }
                if (maxBuffs > 0) continue;
                break;
            }
            for (Potion id : effectsToRemove) {
                otherEntity.func_184589_d(id);
            }
            if (maxBuffs > 0) continue;
            break;
        }
    }
}

