/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.PotionBrewEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.util.BlockUtil;

public class ThornsBrewEffect
extends BrewActionEffect {
    public ThornsBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        BlockPos coord = null;
        if (world.func_180495_p(pos).func_177230_c() == WitcheryBlocks.CACTUS) {
            pos = pos.func_177984_a();
            while (world.func_180495_p(pos).func_177230_c() == WitcheryBlocks.CACTUS) {
                pos = pos.func_177984_a();
            }
            if (BlockUtil.isReplaceableBlock(world, pos)) {
                coord = pos;
            }
        } else {
            coord = BlockUtil.getClosestPlantableBlock(world, pos, side, (EntityLivingBase)modifiers.caster);
        }
        if (coord != null) {
            int height2 = 3 + modifiers.getStrength();
            for (int i = 0; i < height2 && BlockUtil.isReplaceableBlock(world, coord.func_177981_b(i)) && coord.func_177956_o() + i < 255; ++i) {
                world.func_175656_a(coord.func_177981_b(i), WitcheryBlocks.CACTUS.func_176223_P());
            }
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        PotionBrewEffect.applyPotionEffect(targetEntity, modifiers, WitcheryPotionEffects.SPIKED, 1800, modifiers.noParticles, modifiers.caster);
    }
}

