/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class TransposeOreBrewEffect
extends BrewActionEffect {
    public TransposeOreBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        int depth = radius + modifiers.strength.getValue();
        Block[] blockTypes = new Block[]{Blocks.field_150366_p, Blocks.field_150352_o, Blocks.field_150369_x, Blocks.field_150412_bA};
        this.slurpOres(world, pos, radius, depth, blockTypes, modifiers);
    }

    @Override
    protected void doApplyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        int r = ritualModifiers.covenSize + radius;
        int maxDepth = 4 * ritualModifiers.covenSize * (1 + modifiers.getStrength());
        int steps = 4;
        Block[] blockTypes = new Block[]{Blocks.field_150366_p, Blocks.field_150352_o, Blocks.field_150369_x, Blocks.field_150412_bA};
        this.slurpOres(world, pos.func_177979_c((ritualModifiers.pulses - 1) * steps), r, steps, blockTypes, modifiers);
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187619_bk, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, 1.0f, EnumParticleTypes.FLAME), world, pos, 16.0);
        ritualModifiers.setRitualStatus(RitualStatus.success(ritualModifiers.pulses * 4 >= maxDepth));
    }

    private void slurpOres(World world, BlockPos pos, int radius, int depth, Block[] blockTypes, ModifiersEffect modifiers) {
        int maxType = modifiers.getStrength();
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-radius, -depth, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius))) {
            Block blockID = world.func_180495_p(p).func_177230_c();
            for (int t = 0; t < blockTypes.length && t < maxType; ++t) {
                if (blockID != blockTypes[t]) continue;
                ItemStack newStack = new ItemStack(blockID);
                EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, newStack);
                if (world.field_72995_K) continue;
                world.func_175698_g(p);
                world.func_72838_d((Entity)entity);
            }
        }
    }
}

