/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.PotionBrewEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.util.BlockUtil;

public class VinesBrewEffect
extends BrewActionEffect {
    public VinesBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        IBlockState state = WitcheryBlocks.VINE.func_176223_P();
        switch (side) {
            case NORTH: {
                state = state.func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true));
                break;
            }
            case SOUTH: {
                state = state.func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true));
                break;
            }
            case WEST: {
                state = state.func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true));
                break;
            }
            case EAST: {
                state = state.func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true));
                break;
            }
            default: {
                return;
            }
        }
        BlockPos n = pos.func_177972_a(side);
        int offsetY = 0;
        while (BlockUtil.isReplaceableBlock(world, n.func_177981_b(offsetY)) && pos.func_177956_o() + offsetY > 0 && (modifiers.getStrength() > 0 || world.func_180495_p(pos.func_177981_b(offsetY)).func_185904_a().func_76220_a())) {
            world.func_180501_a(n.func_177981_b(offsetY), state, 3);
            --offsetY;
        }
        offsetY = 1;
        while ((BlockUtil.isReplaceableBlock(world, n.func_177981_b(offsetY)) || world.func_180495_p(n.func_177981_b(offsetY)).func_185904_a() == Material.field_151584_j) && world.func_180495_p(pos).func_185904_a().func_76220_a() && pos.func_177956_o() + offsetY < 255) {
            world.func_180501_a(n.func_177981_b(offsetY), state, 3);
            ++offsetY;
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        PotionBrewEffect.applyPotionEffect(targetEntity, modifiers, WitcheryPotionEffects.WRAPPED_IN_VINE, 1800, modifiers.noParticles, modifiers.caster);
    }
}

