/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;

public class WastingBrewEffect
extends BrewActionEffect {
    public WastingBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        int hungerTicks = modifiers.getModifiedDuration(400);
        int poisonTicks = Math.max(modifiers.getModifiedDuration(60), 40);
        int strength = 1 + modifiers.getStrength() / 2;
        if (targetEntity instanceof EntityPlayer) {
            EntityPlayer victim = (EntityPlayer)targetEntity;
            if (modifiers.inverted) {
                int minLevel = 6 + 2 * modifiers.getStrength();
                victim.func_71024_bL().func_75122_a(minLevel, (float)minLevel);
            } else {
                int minLevel = 10 - modifiers.getStrength();
                if (victim.func_71024_bL().func_75116_a() > minLevel) {
                    victim.func_71024_bL().func_75122_a(-minLevel, 2.0f);
                }
                victim.func_70690_d(new PotionEffect(MobEffects.field_76438_s, hungerTicks, strength));
                victim.func_70690_d(new PotionEffect(MobEffects.field_76436_u, poisonTicks, 0));
            }
        } else if (modifiers.inverted) {
            targetEntity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, modifiers.getStrength()));
        } else {
            targetEntity.func_70690_d(new PotionEffect(MobEffects.field_82731_v, hungerTicks, strength));
            targetEntity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, poisonTicks));
        }
    }
}

