/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockWitchWeb;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.BlockUtil;

public class WebsBrewEffect
extends BrewActionEffect {
    public WebsBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        this.placeWeb(world, pos, modifiers, side, modifiers.caster);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        this.placeWeb(world, targetEntity.func_180425_c(), modifiers, EnumFacing.UP, modifiers.caster);
    }

    private void placeWeb(World world, BlockPos coord, ModifiersEffect modifiers, EnumFacing side, EntityPlayer source) {
        BlockPos location = BlockUtil.getClosestPlantableBlock(world, coord, side, (EntityLivingBase)source, true);
        if (location != null) {
            BlockWitchWeb web = WitcheryBlocks.WEB;
            BlockUtil.setBlockIfReplaceable(world, location, web);
            if (modifiers.getStrength() > 0) {
                BlockUtil.setBlockIfReplaceable(world, location.func_177974_f(), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177976_e(), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177968_d(), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177978_c(), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177984_a(), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177977_b(), web);
            }
            if (modifiers.getStrength() > 1) {
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(1, 0, 1), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(-1, 0, 1), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(1, 0, -1), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(-1, 0, -1), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(1, 1, 0), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(-1, 1, 0), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(0, 1, 1), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(0, 1, -1), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(0, -1, 1), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(0, -1, -1), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(1, -1, 0), web);
                BlockUtil.setBlockIfReplaceable(world, location.func_177982_a(-1, -1, 0), web);
            }
        }
    }
}

