/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.ritual;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ritual.SmallRitual;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.entity.EntityRitualItem;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.rite.RitualCircle;
import net.msrandom.witchery.util.TeleportationUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/msrandom/witchery/brewing/ritual/BindWaystoneRitual;", "Lnet/msrandom/witchery/brewing/ritual/SmallRitual;", "()V", "activate", "Lnet/msrandom/witchery/brewing/ritual/SmallRitual$Result;", "world", "Lnet/minecraft/world/World;", "item", "Lnet/msrandom/witchery/entity/EntityRitualItem;", "stack", "Lnet/minecraft/item/ItemStack;", "position", "Lnet/minecraft/util/math/BlockPos;", "WitcheryResurrected"})
public final class BindWaystoneRitual
extends SmallRitual {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SmallRitual.Result activate(@NotNull World world, @NotNull EntityRitualItem item, @NotNull ItemStack stack, @NotNull BlockPos position) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull((Object)item, "item");
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(position, "position");
        int originalStackSize = stack.func_190916_E();
        int remainingStackSize = 0;
        AxisAlignedBB bounds = new AxisAlignedBB(position.func_177982_a(-2, -2, -2), position.func_177982_a(2, 2, 2));
        ItemStack boundStone = null;
        EntityLivingBase target = null;
        double targetDistSq = -1.0;
        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, bounds)) {
            double distSq = player.func_174818_b(position);
            if (!(distSq <= (double)4) || target != null && !(distSq < targetDistSq)) continue;
            target = (EntityLivingBase)player;
            targetDistSq = distSq;
        }
        if (target == null) {
            for (EntityLiving creature2 : world.func_72872_a(EntityLiving.class, bounds)) {
                double distSq2 = creature2.func_174818_b(position);
                if (!(distSq2 <= (double)4) || target != null && !(distSq2 < targetDistSq)) continue;
                target = (EntityLivingBase)creature2;
                targetDistSq = distSq2;
            }
        }
        if (target != null) {
            IPowerSource power = PowerSources.findClosestPowerSource(world, position);
            if (power == null) {
                world.func_184133_a(null, position, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                return SmallRitual.Result.NO_POWER;
            }
            if (!power.consumePower(4000.0f)) {
                world.func_184133_a(null, position, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                return SmallRitual.Result.NO_POWER;
            }
            int convertableStackSize = RangesKt.coerceAtMost(originalStackSize, 1);
            remainingStackSize = originalStackSize - convertableStackSize;
            boundStone = new ItemStack(WitcheryIngredientItems.PLAYER_BOUND_WAYSTONE, convertableStackSize);
            ItemTaglockKit.setEntityTaglock(boundStone, null, (Entity)target, false, 0);
        } else {
            int convertableStackSize2 = RangesKt.coerceAtMost(originalStackSize, 8);
            remainingStackSize = originalStackSize - convertableStackSize2;
            boundStone = new ItemStack(WitcheryIngredientItems.BOUND_WAYSTONE, convertableStackSize2);
            TeleportationUtil.bindToLocation(position, item.field_71093_bK, boundStone);
        }
        if (boundStone.func_190926_b()) {
            return SmallRitual.Result.DONE;
        }
        world.func_72838_d((Entity)new EntityItem(world, item.field_70165_t, item.field_70163_u, item.field_70161_v, boundStone));
        if (remainingStackSize > 0) {
            world.func_72838_d((Entity)new EntityItem(world, item.field_70165_t, item.field_70163_u, item.field_70161_v, new ItemStack(WitcheryIngredientItems.WAYSTONE, remainingStackSize)));
        }
        world.func_184133_a(null, item.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        return SmallRitual.Result.EXPLODE;
    }

    public BindWaystoneRitual() {
        RitualCircle ritualCircle = RitualCircle.Companion.get(WitcheryBlocks.GLYPH_OTHERWHERE, 0);
        Item[] itemArray = new Item[1];
        Item item = WitcheryIngredientItems.WAYSTONE;
        Intrinsics.checkExpressionValueIsNotNull(item, "WitcheryIngredientItems.WAYSTONE");
        itemArray[0] = item;
        super(ritualCircle, itemArray);
    }
}

