/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.client.resources.InfusionIconManager;
import net.msrandom.witchery.infusion.Infusion;

@SideOnly(value=Side.CLIENT)
public class RenderInfusionEnergyBar {
    public static final ResourceLocation CREATURES = new ResourceLocation("witchery", "textures/gui/creatures.png");
    private static final ResourceLocation GLASS = new ResourceLocation("witchery", "textures/gui/glass.png");
    final boolean primary;

    public RenderInfusionEnergyBar(boolean primary) {
        this.primary = primary;
    }

    public static void drawIconPartial(double x, double y, TextureAtlasSprite sprite, double left, double top, double right, double bottom) {
        if (sprite == null) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        float u2 = sprite.func_94212_f();
        float v2 = sprite.func_94210_h();
        double xOffset1 = left * (double)(u2 - u1) / 16.0;
        double yOffset1 = top * (double)(v2 - v1) / 16.0;
        double xOffset2 = right * (double)(u2 - u1) / 16.0;
        double yOffset2 = bottom * (double)(v2 - v1) / 16.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x + left, y + top, 0.0).func_187315_a((double)u1 + xOffset1, (double)v1 + yOffset1).func_181675_d();
        bufferbuilder.func_181662_b(x + left, y + bottom, 0.0).func_187315_a((double)u1 + xOffset1, (double)v1 + yOffset2).func_181675_d();
        bufferbuilder.func_181662_b(x + right, y + bottom, 0.0).func_187315_a((double)u1 + xOffset2, (double)v1 + yOffset2).func_181675_d();
        bufferbuilder.func_181662_b(x + right, y + top, 0.0).func_187315_a((double)u1 + xOffset2, (double)v1 + yOffset1).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179126_j();
    }

    public void draw(float x, float y, double value, Infusion infusion, int iconOffsetId) {
        this.draw(x, y, value, infusion, CREATURES, iconOffsetId);
    }

    public void draw(float x, float y, double value, Infusion infusion, ResourceLocation icon) {
        this.draw(x, y, value, infusion, icon, 0);
    }

    public void draw(float x, float y, double value, Infusion infusion, ResourceLocation icon, int iconOffsetId) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        this.drawFluid(x, y, value, InfusionIconManager.INSTANCE.getIcon(this.primary ? infusion : Infusion.DEFUSED));
        int iconOffsetX = 0;
        int iconOffsetY = iconOffsetId * 8;
        if (this.primary) {
            this.drawGlass(x, y);
            iconOffsetX = 8;
        }
        int xPosition = MathHelper.func_76141_d((float)x);
        int yPosition = MathHelper.func_76141_d((float)y) + 33;
        mc.func_110434_K().func_110577_a(icon);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(xPosition, yPosition, iconOffsetX, iconOffsetY, 8, 8);
        GlStateManager.func_179121_F();
    }

    public void drawFluid(double x, double y, double value, TextureAtlasSprite icon) {
        double bottomY = y + 32.0;
        double topY = y + 32.0 * (1.0 - value);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        if (this.primary) {
            while (bottomY - 8.0 > topY) {
                RenderInfusionEnergyBar.drawIconPartial(x * 2.0, (bottomY - 8.0) * 2.0, icon, 0.0, 0.0, 16.0, 16.0);
                bottomY -= 8.0;
            }
            RenderInfusionEnergyBar.drawIconPartial(x * 2.0, (bottomY - 8.0) * 2.0, icon, 0.0, (topY - bottomY + 8.0) * 2.0, 16.0, 16.0);
        } else {
            int i = 0;
            while ((double)i < value) {
                RenderInfusionEnergyBar.drawIconPartial(x * 2.0, (bottomY - (double)(i * 2)) * 2.0 - 2.0, icon, 0.0, 0.0, 16.0, 2.0);
                ++i;
            }
        }
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height2) {
        double f = this.primary ? 0.00390625 : 0.125;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height2), 0.0).func_187315_a((double)u * f, (double)(v + height2) * f).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height2), 0.0).func_187315_a((double)(u + width) * f, (double)(v + height2) * f).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)(u + width) * f, (double)v * f).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)u * f, (double)v * f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawGlass(float x, float y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GLASS);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + 32.0f), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + 8.0f), (double)(y + 32.0f), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + 8.0f), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

