/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.gui.book;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.client.gui.book.WitcheryGuiDynamicBook;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.KettleRecipe;
import net.msrandom.witchery.util.WitcheryBookUtils;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/msrandom/witchery/client/gui/book/GuiBrewsAndInfusionsBook;", "Lnet/msrandom/witchery/client/gui/book/WitcheryGuiDynamicBook;", "stack", "Lnet/minecraft/item/ItemStack;", "hand", "Lnet/minecraft/util/EnumHand;", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumHand;)V", "lastPage", "", "getLastPage", "()I", "time", "", "drawScreen", "", "mouseX", "mouseY", "partialTicks", "getDescription", "", "recipe", "Lnet/msrandom/witchery/recipe/KettleRecipe;", "Companion", "WitcheryResurrected"})
public final class GuiBrewsAndInfusionsBook
extends WitcheryGuiDynamicBook {
    private float time;
    @NotNull
    private static List<KettleRecipe> recipes;
    public static final Companion Companion;

    @Override
    protected int getLastPage() {
        return recipes.size();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.time += partialTicks;
        int xStart = (this.field_146294_l - 192) / 2;
        if (this.getPage() == 0) {
            String name2 = this.getStack().func_82833_r();
            int height2 = this.field_146289_q.func_78267_b(name2, 116);
            this.field_146289_q.func_78279_b(name2, xStart + 36, 34, 116, 0);
            String string = I18n.func_135052_a((String)(this.getStack().func_77977_a() + ".description"), (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(stack.translationKey + \".description\")");
            this.field_146289_q.func_78279_b(StringsKt.replace$default(string, "\\n", "\n", false, 4, null), xStart + 36, 42 + height2, 116, 0);
        } else {
            this.field_146289_q.func_78279_b(this.getDescription(recipes.get(this.getPage() - 1)), xStart + 36, 34, 116, 0);
        }
    }

    private final String getDescription(KettleRecipe recipe) {
        StringBuilder sb = new StringBuilder();
        sb.append(TextFormatting.UNDERLINE);
        sb.append(recipe.func_77571_b().func_82833_r());
        sb.append(TextFormatting.RESET);
        sb.append("\n");
        sb.append("\n");
        if (recipe.getSpecial()) {
            sb.append(I18n.func_135052_a((String)("kettle_recipe." + recipe.getId().func_110624_b() + '.' + recipe.getId().func_110623_a()), (Object[])new Object[0]));
            sb.append("\n");
            sb.append("\n");
        }
        for (Ingredient ingredient : recipe.getInputs()) {
            sb.append(TextFormatting.DARK_GRAY).append(">").append(TextFormatting.BLACK).append(" ");
            Ingredient ingredient2 = ingredient;
            Intrinsics.checkExpressionValueIsNotNull(ingredient2, "ingredient");
            sb.append(WitcheryBookUtils.INSTANCE.getCurrentName(ingredient2, this.time));
            sb.append("\n");
        }
        if (recipe.getPowerRequired() > 0.0f) {
            sb.append("\n");
            sb.append(TextFormatting.DARK_GRAY);
            sb.append(I18n.func_135052_a((String)"witchery.book.altar_power", (Object[])new Object[0]));
            sb.append(TextFormatting.BLACK);
            sb.append(" ");
            sb.append(MathHelper.func_76141_d((float)recipe.getPowerRequired()));
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    public GuiBrewsAndInfusionsBook(@NotNull ItemStack stack, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        super(stack, hand, false, 4, null);
    }

    static {
        Companion = new Companion(null);
        recipes = CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fR0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lnet/msrandom/witchery/client/gui/book/GuiBrewsAndInfusionsBook$Companion;", "", "()V", "<set-?>", "", "Lnet/msrandom/witchery/recipe/KettleRecipe;", "recipes", "getRecipes", "()Ljava/util/List;", "setRecipes", "(Ljava/util/List;)V", "update", "", "WitcheryResurrected"})
    public static final class Companion {
        @NotNull
        public final List<KettleRecipe> getRecipes() {
            return recipes;
        }

        private final void setRecipes(List<KettleRecipe> list2) {
            recipes = list2;
        }

        public final void update() {
            this.setRecipes(WitcheryUtils.getRecipeManager((World)Minecraft.func_71410_x().field_71441_e).getRecipesForType(WitcheryRecipeTypes.KETTLE));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

