/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.potion.PotionResizing;
import net.msrandom.witchery.util.ReflectiveLambdaGenerator;

@SideOnly(value=Side.CLIENT)
public class ModelOverlayRenderer {
    private static final ReflectiveLambdaGenerator.RotationSetter applyRotations;
    private static final ReflectiveLambdaGenerator.RotationHandler handleRotationFloat;
    private static final ReflectiveLambdaGenerator.RendererCallback preRenderCallback;

    public static void render(EntityLivingBase entity, double x, double y, double z, RenderLivingBase<EntityLivingBase> originalRenderer) {
        ModelBase mainModel = originalRenderer.func_177087_b();
        ModelOverlayRenderer.renderModel(entity, x, y, z, originalRenderer, mainModel);
    }

    public static void renderModel(EntityLivingBase entity, double x, double y, double z, RenderLivingBase<EntityLivingBase> originalRenderer, ModelBase model) {
        ModelOverlayRenderer.renderModelAsOverlay(entity, model, x, y, z, Minecraft.func_71410_x().func_184121_ak(), originalRenderer);
    }

    private static void renderModelAsOverlay(EntityLivingBase entity, ModelBase mainModel, double x, double y, double z, float partialRenderTicks, RenderLivingBase<EntityLivingBase> originalRenderer) {
        GlStateManager.func_179094_E();
        mainModel.field_78095_p = ModelOverlayRenderer.getSwingProgress(entity, partialRenderTicks);
        mainModel.field_78093_q = entity.func_184218_aH();
        mainModel.field_78091_s = entity.func_70631_g_();
        float f = ModelOverlayRenderer.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, partialRenderTicks);
        float f1 = ModelOverlayRenderer.interpolateRotation(entity.field_70758_at, entity.field_70759_as, partialRenderTicks);
        float f2 = f1 - f;
        if (entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase1 = (EntityLivingBase)entity.func_184187_bx();
            f = ModelOverlayRenderer.interpolateRotation(entitylivingbase1.field_70760_ar, entitylivingbase1.field_70761_aq, partialRenderTicks);
            float f4 = MathHelper.func_76142_g((float)(f1 - f));
            if (f4 < -85.0f) {
                f4 = -85.0f;
            }
            if (f4 >= 85.0f) {
                f4 = 85.0f;
            }
            f = f1 - f4;
            if (f4 * f4 > 2500.0f) {
                f += f4 * 0.2f;
            }
        }
        float f7 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialRenderTicks;
        ModelOverlayRenderer.renderLivingAt(entity, x, y, z);
        float f8 = handleRotationFloat.invoke(originalRenderer, entity, partialRenderTicks);
        applyRotations.invoke(originalRenderer, entity, f8, f, partialRenderTicks);
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        preRenderCallback.invoke(originalRenderer, entity, partialRenderTicks);
        GlStateManager.func_179137_b((double)0.0, (double)-1.5078125, (double)0.0);
        float f5 = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialRenderTicks;
        float f6 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialRenderTicks);
        if (entity.func_70631_g_()) {
            f6 *= 3.0f;
        }
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        GlStateManager.func_179141_d();
        mainModel.func_78086_a(entity, f6, f5, partialRenderTicks);
        mainModel.func_78087_a(f6, f5, f8, f2, f7, 0.0625f, (Entity)entity);
        GlStateManager.func_179152_a((float)1.01f, (float)1.01f, (float)1.01f);
        ModelOverlayRenderer.renderModel(entity, f6, f5, f8, f2, f7, 0.0625f, mainModel);
        GlStateManager.func_179121_F();
    }

    private static float interpolateRotation(float par1, float par2, float partialRenderTicks) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + partialRenderTicks * f3;
    }

    private static void renderLivingAt(EntityLivingBase entity, double p_77039_2_, double p_77039_4_, double p_77039_6_) {
        PotionEffect resizing;
        GlStateManager.func_179109_b((float)((float)p_77039_2_), (float)((float)p_77039_4_), (float)((float)p_77039_6_));
        if (entity != null && entity.func_70644_a(WitcheryPotionEffects.RESIZING) && (resizing = entity.func_70660_b(WitcheryPotionEffects.RESIZING)) != null) {
            float scale = PotionResizing.getModifiedScaleFactor(entity, resizing.func_76458_c());
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        }
    }

    private static float getSwingProgress(EntityLivingBase entity, float partialRenderTicks) {
        return entity.func_70678_g(partialRenderTicks);
    }

    private static void renderModel(EntityLivingBase entity, float p_77036_2_, float p_77036_3_, float p_77036_4_, float p_77036_5_, float p_77036_6_, float p_77036_7_, ModelBase mainModel) {
        if (!entity.func_82150_aj()) {
            mainModel.func_78088_a((Entity)entity, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
        } else if (!entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            mainModel.func_78088_a((Entity)entity, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            mainModel.func_78087_a(p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_, (Entity)entity);
        }
    }

    static {
        ReflectiveLambdaGenerator.RotationSetter applyRotationsMethod = null;
        ReflectiveLambdaGenerator.RotationHandler handleRotationFloatMethod = null;
        ReflectiveLambdaGenerator.RendererCallback preRenderCallbackMethod = null;
        try {
            applyRotationsMethod = ReflectiveLambdaGenerator.getApplyRotationsMethod();
            handleRotationFloatMethod = ReflectiveLambdaGenerator.getHandleRotationMethod();
            preRenderCallbackMethod = ReflectiveLambdaGenerator.getRenderCallbackMethod();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        applyRotations = applyRotationsMethod;
        handleRotationFloat = handleRotationFloatMethod;
        preRenderCallback = preRenderCallbackMethod;
    }
}

