/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntToDoubleFunction;
import javax.vecmath.Vector2d;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.WitcheryResurrectedClient;
import net.msrandom.witchery.infusion.symbol.BranchStroke;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.infusion.symbol.StrokeArray;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.registry.WitcheryIdentityRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002JH\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J(\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J\b\u0010#\u001a\u00020\u000bH\u0002J \u0010$\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J \u0010$\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J&\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0004J8\u0010-\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0004H\u0002J\b\u00102\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lnet/msrandom/witchery/client/renderer/MysticBranchRenderer;", "", "()V", "HALF_PI", "", "HALF_VERTEX_COUNT", "", "center", "a", "b", "drawBezierPoints", "", "buffer", "Lnet/minecraft/client/renderer/BufferBuilder;", "index", "count", "red", "", "green", "blue", "xGetter", "Ljava/util/function/IntToDoubleFunction;", "yGetter", "drawSingleLine", "yawDiff", "pitchDiff", "fadeIn", "t", "getBezierPoint", "start", "end", "tangent", "getOffset", "localPercentage", "totalPercentage", "initializeGlState", "lerp", "render", "playerData", "Lnet/minecraft/nbt/NBTTagCompound;", "screen", "Lnet/minecraft/client/gui/ScaledResolution;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "delta", "renderBranchLines", "strokes", "Lnet/msrandom/witchery/infusion/symbol/StrokeArray;", "color", "spellPreparedTime", "revertGlState", "WitcheryResurrected"})
public final class MysticBranchRenderer {
    private static final int HALF_VERTEX_COUNT = 16;
    private static final double HALF_PI = 1.5707963267948966;
    public static final MysticBranchRenderer INSTANCE;

    private final void initializeGlState() {
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        if (OpenGlHelper.field_148824_g) {
            WitcheryResurrectedClient.INSTANCE.getMysticBranchLinesShader().func_147995_c();
        }
    }

    private final void revertGlState() {
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (OpenGlHelper.field_148824_g) {
            WitcheryResurrectedClient.INSTANCE.getMysticBranchLinesShader().func_147993_b();
        }
    }

    public final void render(@NotNull NBTTagCompound playerData, @NotNull ScaledResolution screen, @NotNull EntityPlayer player, double delta) {
        Tessellator tessellator;
        SymbolEffect symbolEffect;
        ResourceLocation effectId;
        ResourceLocation resourceLocation;
        Intrinsics.checkParameterIsNotNull(playerData, "playerData");
        Intrinsics.checkParameterIsNotNull(screen, "screen");
        Intrinsics.checkParameterIsNotNull(player, "player");
        byte[] byArray = playerData.func_74770_j("Strokes");
        Intrinsics.checkExpressionValueIsNotNull(byArray, "playerData.getByteArray(\"Strokes\")");
        StrokeArray strokes = new StrokeArray(byArray);
        NBTTagCompound nBTTagCompound = playerData;
        boolean bl = false;
        boolean bl2 = false;
        NBTTagCompound it = nBTTagCompound;
        boolean bl3 = false;
        Object object = it.func_74764_b("WitcherySpellEffect") ? nBTTagCompound : null;
        if (object != null && (object = object.func_74779_i("WitcherySpellEffect")) != null) {
            nBTTagCompound = object;
            bl = false;
            bl2 = false;
            NBTTagCompound p1 = nBTTagCompound;
            boolean bl4 = false;
            resourceLocation = new ResourceLocation((String)p1);
        } else {
            resourceLocation = null;
        }
        ResourceLocation resourceLocation2 = effectId = resourceLocation;
        if (resourceLocation2 != null) {
            ResourceLocation resourceLocation3 = resourceLocation2;
            WitcheryIdentityRegistry<ResourceLocation, SymbolEffect> witcheryIdentityRegistry = SymbolEffect.REGISTRY;
            boolean p1 = false;
            boolean bl5 = false;
            ResourceLocation p12 = resourceLocation3;
            boolean bl6 = false;
            symbolEffect = (SymbolEffect)witcheryIdentityRegistry.get(p12);
        } else {
            symbolEffect = null;
        }
        SymbolEffect effect = symbolEffect;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(screen.func_78327_c() / (double)2), (double)(screen.func_78324_d() / (double)2), (double)0.0);
        Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull(tessellator2, "tessellator");
        BufferBuilder buffer = tessellator2.func_178180_c();
        buffer.func_181668_a(8, DefaultVertexFormats.field_181709_i);
        double yaw = this.lerp((double)player.field_70758_at, (double)player.field_70759_as, delta);
        double pitch = this.lerp((double)player.field_70127_C, (double)player.field_70125_A, delta);
        double yawDiff = ((double)playerData.func_74760_g("StartYaw") - yaw) * (double)3;
        double pitchDiff = ((double)playerData.func_74760_g("StartPitch") - pitch) * (double)3;
        this.initializeGlState();
        GlStateManager.func_179094_E();
        if (effect == null) {
            if (strokes.isEmpty()) {
                BufferBuilder bufferBuilder = buffer;
                Intrinsics.checkExpressionValueIsNotNull(bufferBuilder, "buffer");
                this.drawSingleLine(bufferBuilder, yawDiff, pitchDiff);
            } else {
                BufferBuilder bufferBuilder = buffer;
                Intrinsics.checkExpressionValueIsNotNull(bufferBuilder, "buffer");
                this.renderBranchLines(bufferBuilder, strokes, yawDiff, pitchDiff, 5505142, 0.0);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            this.revertGlState();
        } else {
            int color2 = effect instanceof ProjectileSymbolEffect ? ((ProjectileSymbolEffect)effect).getColor() : (effect.isCurse() ? 0xFF0000 : 65280);
            double spellPreparedTime = (double)(player.field_70173_aa - playerData.func_74762_e("SpellPreparedTime")) + delta;
            BufferBuilder bufferBuilder = buffer;
            Intrinsics.checkExpressionValueIsNotNull(bufferBuilder, "buffer");
            this.renderBranchLines(bufferBuilder, strokes, yawDiff, pitchDiff, color2, spellPreparedTime);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            this.revertGlState();
            String text2 = I18n.func_135052_a((String)("spell." + effectId.func_110624_b() + '.' + effectId.func_110623_a()), (Object[])new Object[0]);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(text2, (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(text2) / -2.0f, 20.0f, 0xFFFFFF);
        }
        GlStateManager.func_179121_F();
    }

    private final double fadeIn(double t) {
        double t4 = t * t * t * t;
        double t16 = t4 * t4 * t4 * t4;
        return t16 * t16 * t16 * t16;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderBranchLines(BufferBuilder buffer, StrokeArray strokes, double yawDiff, double pitchDiff, int color2, double spellPreparedTime) {
        void blue;
        void green;
        void red;
        boolean bl = false;
        List points = new ArrayList();
        double x = 0.0;
        double y = 0.0;
        points.add(new Vector2d(0.0, 0.0));
        Ref.FloatRef floatRef = new Ref.FloatRef();
        floatRef.element = 0.33f;
        Ref.FloatRef floatRef2 = new Ref.FloatRef();
        floatRef2.element = 0.0f;
        Ref.FloatRef floatRef3 = new Ref.FloatRef();
        floatRef3.element = 0.46f;
        for (BranchStroke stroke : strokes) {
            points.add(new Vector2d(x -= (double)stroke.getX(), y -= (double)stroke.getY()));
        }
        if (spellPreparedTime > 0.0) {
            double t = MathHelper.func_151237_a((double)(spellPreparedTime / 5.0), (double)0.0, (double)1.0);
            BranchStroke lastStroke = strokes.get(strokes.getSize() - 1);
            if (lastStroke.ordinal() < 4) {
                points.add(new Vector2d(x -= (double)lastStroke.getX(), y -= (double)lastStroke.getY()));
            }
            GlStateManager.func_179137_b((double)this.lerp(-x, -x / (double)2, t), (double)this.lerp(-y, -y / (double)2, t), (double)0.0);
            red.element = this.lerp(red.element, (float)(color2 >> 16 & 0xFF) / 255.0f, t);
            green.element = this.lerp(green.element, (float)(color2 >> 8 & 0xFF) / 255.0f, t);
            blue.element = this.lerp(blue.element, (float)(color2 & 0xFF) / 255.0f, t);
        } else {
            points.add(new Vector2d(x -= yawDiff, y -= pitchDiff));
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)0.0);
        }
        int n = points.size() - 1;
        boolean bl2 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int index = n2++;
            boolean bl3 = false;
            INSTANCE.drawBezierPoints(buffer, index, points.size(), red.element, green.element, blue.element, new IntToDoubleFunction(buffer, points, (Ref.FloatRef)red, (Ref.FloatRef)green, (Ref.FloatRef)blue){
                final /* synthetic */ BufferBuilder $buffer$inlined;
                final /* synthetic */ List $points$inlined;
                final /* synthetic */ Ref.FloatRef $red$inlined;
                final /* synthetic */ Ref.FloatRef $green$inlined;
                final /* synthetic */ Ref.FloatRef $blue$inlined;
                {
                    this.$buffer$inlined = bufferBuilder;
                    this.$points$inlined = list2;
                    this.$red$inlined = floatRef;
                    this.$green$inlined = floatRef2;
                    this.$blue$inlined = floatRef3;
                }

                public final double applyAsDouble(int it) {
                    return ((Vector2d)this.$points$inlined.get(it)).getX();
                }
            }, new IntToDoubleFunction(buffer, points, (Ref.FloatRef)red, (Ref.FloatRef)green, (Ref.FloatRef)blue){
                final /* synthetic */ BufferBuilder $buffer$inlined;
                final /* synthetic */ List $points$inlined;
                final /* synthetic */ Ref.FloatRef $red$inlined;
                final /* synthetic */ Ref.FloatRef $green$inlined;
                final /* synthetic */ Ref.FloatRef $blue$inlined;
                {
                    this.$buffer$inlined = bufferBuilder;
                    this.$points$inlined = list2;
                    this.$red$inlined = floatRef;
                    this.$green$inlined = floatRef2;
                    this.$blue$inlined = floatRef3;
                }

                public final double applyAsDouble(int it) {
                    return ((Vector2d)this.$points$inlined.get(it)).getY();
                }
            });
        }
    }

    private final void drawSingleLine(BufferBuilder buffer, double yawDiff, double pitchDiff) {
        boolean bl = false;
        double angle = Math.atan2(pitchDiff, yawDiff) + 1.5707963267948966;
        boolean bl2 = false;
        double orthogonalX = Math.cos(angle);
        int n = 0;
        double orthogonalY = Math.sin(angle);
        n = 16;
        boolean bl3 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl4 = false;
            double t = (double)it / (double)16;
            double x = yawDiff * (1.0 - t);
            double y = pitchDiff * (1.0 - t);
            double offset = INSTANCE.getOffset(t * 0.6, (double)it / 15.0);
            buffer.func_181662_b(x + orthogonalX * offset, y + orthogonalY * offset, 0.0).func_187315_a(t, 0.0).func_181666_a(0.33f, 0.0f, 0.46f, 1.0f).func_181675_d();
            buffer.func_181662_b(x - orthogonalX * offset, y - orthogonalY * offset, 0.0).func_187315_a(t, 1.0).func_181666_a(0.33f, 0.0f, 0.46f, 1.0f).func_181675_d();
        }
    }

    private final void drawBezierPoints(BufferBuilder buffer, int index, int count, float red, float green, float blue, IntToDoubleFunction xGetter, IntToDoubleFunction yGetter) {
        double tangentX = xGetter.applyAsDouble(index + 1);
        double tangentY = yGetter.applyAsDouble(index + 1);
        Function2<IntToDoubleFunction, Double, Double> $fun$getStart$1 = new Function2<IntToDoubleFunction, Double, Double>(index){
            final /* synthetic */ int $index;

            public final double invoke(@NotNull IntToDoubleFunction function, double tangent) {
                Intrinsics.checkParameterIsNotNull(function, "function");
                return this.$index == 0 ? function.applyAsDouble(0) : MysticBranchRenderer.access$center(MysticBranchRenderer.INSTANCE, function.applyAsDouble(this.$index), tangent);
            }
            {
                this.$index = n;
                super(2);
            }
        };
        Function2<IntToDoubleFunction, Double, Double> $fun$getEnd$2 = new Function2<IntToDoubleFunction, Double, Double>(index, count){
            final /* synthetic */ int $index;
            final /* synthetic */ int $count;

            public final double invoke(@NotNull IntToDoubleFunction function, double tangent) {
                Intrinsics.checkParameterIsNotNull(function, "function");
                return this.$index == this.$count - 2 ? function.applyAsDouble(this.$count - 1) : MysticBranchRenderer.access$center(MysticBranchRenderer.INSTANCE, tangent, function.applyAsDouble(this.$index + 2));
            }
            {
                this.$index = n;
                this.$count = n2;
                super(2);
            }
        };
        double startX = $fun$getStart$1.invoke(xGetter, tangentX);
        double startY = $fun$getStart$1.invoke(yGetter, tangentY);
        double endX = $fun$getEnd$2.invoke(xGetter, tangentX);
        double endY = $fun$getEnd$2.invoke(yGetter, tangentY);
        int n = 16;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            double t1 = (double)it / (double)16;
            double t2 = (double)(it + 1) / (double)16;
            double offset = INSTANCE.getOffset(t1, INSTANCE.lerp((double)index / ((double)count - 1.0), ((double)index + 1.0) / ((double)count - 1.0), (double)it / 15.0));
            double pointX = INSTANCE.getBezierPoint(startX, endX, tangentX, t1);
            double pointY = INSTANCE.getBezierPoint(startY, endY, tangentY, t1);
            double d = INSTANCE.getBezierPoint(startY, endY, tangentY, t2) - pointY;
            double d2 = INSTANCE.getBezierPoint(startX, endX, tangentX, t2) - pointX;
            boolean bl3 = false;
            double angle = Math.atan2(d, d2) + 1.5707963267948966;
            boolean bl4 = false;
            double orthogonalX = Math.cos(angle) * offset;
            bl3 = false;
            double orthogonalY = Math.sin(angle) * offset;
            buffer.func_181662_b(pointX - orthogonalX, pointY - orthogonalY, 0.0).func_187315_a(t1, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(pointX + orthogonalX, pointY + orthogonalY, 0.0).func_187315_a(t1, 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
    }

    private final double getBezierPoint(double start, double end, double tangent, double t) {
        double startPoint = this.lerp(start, tangent, t);
        double endPoint = this.lerp(tangent, end, t);
        return this.lerp(startPoint, endPoint, t);
    }

    private final double center(double a, double b) {
        return (a + b) * 0.5;
    }

    private final double lerp(double start, double end, double t) {
        return start + (end - start) * t;
    }

    private final float lerp(float start, float end, double t) {
        return start + (end - start) * (float)t;
    }

    private final double getOffset(double localPercentage, double totalPercentage) {
        double d = localPercentage - 0.5;
        boolean bl = false;
        double sizeIncrease = Math.abs(d) * 0.5;
        double time = (double)Minecraft.func_71386_F() / 6000.0;
        double d2 = totalPercentage - 0.5;
        MysticBranchRenderer mysticBranchRenderer = this;
        double d3 = 1.0;
        boolean bl2 = false;
        double d4 = Math.abs(d2);
        double fade = d3 - mysticBranchRenderer.fadeIn(d4 * (double)2);
        d2 = (localPercentage - time) * Math.PI * (double)2 + 1.5707963267948966;
        d3 = 3;
        bl2 = false;
        double d5 = Math.sin(d2);
        return (d3 - d5) * fade * (0.5 + sizeIncrease);
    }

    private MysticBranchRenderer() {
    }

    static {
        MysticBranchRenderer mysticBranchRenderer;
        INSTANCE = mysticBranchRenderer = new MysticBranchRenderer();
    }

    public static final /* synthetic */ double access$center(MysticBranchRenderer $this, double a, double b) {
        return $this.center(a, b);
    }
}

