/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.msrandom.witchery.common.INullSource;
import net.msrandom.witchery.common.IPowerSource;
import org.jetbrains.annotations.NotNull;

public class PowerSources {
    private static final PowerSources INSTANCE = new PowerSources();
    private final Set<IPowerSource> powerSources = new HashSet<IPowerSource>();
    private final Set<INullSource> nullSources = new HashSet<INullSource>();

    @NotNull
    public static PowerSources instance() {
        return INSTANCE;
    }

    public static IPowerSource findClosestPowerSource(World world, BlockPos pos) {
        List<RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    public static IPowerSource findClosestPowerSource(TileEntity tile) {
        return PowerSources.findClosestPowerSource(tile.func_145831_w(), tile.func_174877_v());
    }

    public void registerPowerSource(IPowerSource powerSource) {
        this.update(powerSource);
        this.powerSources.add(powerSource);
    }

    public void removePowerSource(IPowerSource powerSource) {
        this.powerSources.remove(powerSource);
        this.update(powerSource);
    }

    public List<RelativePowerSource> get(World world, BlockPos location) {
        ArrayList<RelativePowerSource> nearbyPowerSources = new ArrayList<RelativePowerSource>();
        for (IPowerSource registeredSource : this.powerSources) {
            RelativePowerSource powerSource = new RelativePowerSource(registeredSource, location);
            if (!powerSource.isInWorld(world) || !powerSource.isInRange()) continue;
            nearbyPowerSources.add(powerSource);
        }
        nearbyPowerSources.sort(Comparator.comparingDouble(a -> ((RelativePowerSource)a).distanceSq));
        return nearbyPowerSources;
    }

    public void registerNullSource(INullSource nullSource) {
        this.update(nullSource);
        this.nullSources.add(nullSource);
    }

    public void removeNullSource(INullSource nullSource) {
        this.nullSources.remove(nullSource);
        this.update(nullSource);
    }

    private void update(INullSource powerSource) {
        this.powerSources.removeIf(source -> source == null || source.isPowerInvalid() || source.getLocation().equals((Object)powerSource.getLocation()));
    }

    public boolean isAreaNullified(BlockPos pos) {
        for (INullSource source : this.nullSources) {
            double rangeSq = source.getRange() * source.getRange();
            if (!(pos.func_177951_i((Vec3i)source.getLocation()) < rangeSq)) continue;
            return true;
        }
        return false;
    }

    public static class RelativePowerSource {
        private final IPowerSource powerSource;
        private final double distanceSq;
        private final double rangeSq;

        public RelativePowerSource(IPowerSource powerSource, BlockPos relativeLocation) {
            this.powerSource = powerSource;
            this.distanceSq = relativeLocation.func_177951_i((Vec3i)this.powerSource.getLocation());
            double range = powerSource.getRange();
            this.rangeSq = range * range;
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass() == this.getClass() && ((RelativePowerSource)obj).powerSource == this.powerSource;
        }

        public boolean isInWorld(World world) {
            return this.powerSource.getCurrentWorld() == world;
        }

        public IPowerSource source() {
            return this.powerSource;
        }

        public boolean isInRange() {
            return this.distanceSq <= this.rangeSq;
        }
    }
}

