/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.common;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityWerewolf;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.PacketSyncEntitySize;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.resources.CreatureFormStatManager;
import net.msrandom.witchery.transformation.CreatureForm;
import net.msrandom.witchery.transformation.CreatureFormStatType;
import net.msrandom.witchery.transformation.CreatureTrait;
import net.msrandom.witchery.transformation.WerewolfCreatureTrait;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.EntitySizeInfo;
import net.msrandom.witchery.util.ResizingUtils;
import net.msrandom.witchery.util.WitcheryUtils;

public class ShapeShift {
    public static final ShapeShift INSTANCE = new ShapeShift();
    public static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(UUID.fromString("10536417-7AA6-4033-A598-8E934CA77D98"), "Witchery Speed", 0.5, 2);
    public static final AttributeModifier DAMAGE_MODIFIER = new AttributeModifier(UUID.fromString("46C5271C-193B-4D41-9CAB-D071AAEE9D4A"), "Witchery Damage", 6.0, 0);
    public static final AttributeModifier HEALTH_MODIFIER = new AttributeModifier(UUID.fromString("615920F9-6675-4779-8B18-6A62A3671E94"), "Witchery Health", 40.0, 0);

    public void initCurrentShift(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            EntitySizeInfo sizeInfo = new EntitySizeInfo((EntityLivingBase)player);
            player.eyeHeight = sizeInfo.eyeHeight;
            this.initCurrentShift((EntityLivingBase)player, player, true);
            CreatureForm.Stats stats2 = this.getFormStats(playerEx);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = stats2.canFly();
                if (!player.field_71075_bZ.field_75101_c && player.field_71075_bZ.field_75100_b) {
                    player.field_71075_bZ.field_75100_b = false;
                } else if (player.field_71075_bZ.field_75101_c) {
                    player.field_71075_bZ.field_75100_b = true;
                }
                player.func_71016_p();
            }
            WitcheryNetworkChannel.sendToAll(new PacketSyncEntitySize((Entity)player));
        }
    }

    public void initCurrentShift(EntityLivingBase entity, EntityPlayer player, boolean applyDamage) {
        if (!entity.field_70170_p.field_72995_K) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            EntitySizeInfo sizeInfo = new EntitySizeInfo((EntityLivingBase)player);
            ResizingUtils.setSize((Entity)entity, sizeInfo.defaultWidth, sizeInfo.defaultHeight);
            entity.field_70138_W = sizeInfo.stepSize;
            AbstractAttributeMap playerAttributes = entity.func_110140_aT();
            CreatureForm.Stats stats2 = this.getFormStats(playerEx);
            if (stats2.getCreatureTraitType() == null || playerEx.isTransformation(stats2.getCreatureTraitType())) {
                this.applyModifier(SharedMonsterAttributes.field_111263_d, SPEED_MODIFIER, this.getStat(playerEx, CreatureFormStatType.SPEED), playerAttributes);
                if (applyDamage) {
                    this.applyModifier(SharedMonsterAttributes.field_111264_e, DAMAGE_MODIFIER, this.getStat(playerEx, CreatureFormStatType.DAMAGE), playerAttributes);
                }
                this.applyModifier(SharedMonsterAttributes.field_111267_a, HEALTH_MODIFIER, this.getStat(playerEx, CreatureFormStatType.HEALTH), playerAttributes);
            } else {
                this.removeModifier(SharedMonsterAttributes.field_111263_d, SPEED_MODIFIER, playerAttributes);
                if (applyDamage) {
                    this.removeModifier(SharedMonsterAttributes.field_111264_e, DAMAGE_MODIFIER, playerAttributes);
                }
                this.removeModifier(SharedMonsterAttributes.field_111267_a, HEALTH_MODIFIER, playerAttributes);
            }
        }
    }

    public void updatePlayerState(EntityPlayer player, PlayerExtendedData playerEx) {
        if (playerEx.getCurrentForm() == WitcheryAlternateForms.BAT) {
            if (player.field_71075_bZ.field_75100_b) {
                player.field_70143_R = 0.0f;
            }
            if (!player.field_71075_bZ.field_75101_c && !player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = true;
                player.func_71016_p();
            }
        }
    }

    public float updateFallState(EntityPlayer player, float distance) {
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        CreatureForm.Stats currentForm = this.getFormStats(playerEx);
        float fall = this.getStat(currentForm, playerEx, CreatureFormStatType.FALL);
        if (currentForm.canFly() || fall < 0.0f) {
            return 0.0f;
        }
        return Math.max(0.0f, distance - fall);
    }

    public void updateJump(EntityPlayer player) {
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        float jump = this.getStat(playerEx, CreatureFormStatType.JUMP);
        if (jump != 0.0f) {
            player.field_70181_x += (double)jump;
            if (player.func_70051_ag()) {
                float f = player.field_70177_z * ((float)Math.PI / 180);
                float leap = this.getStat(playerEx, CreatureFormStatType.LEAP);
                player.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * leap);
                player.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * leap);
            }
        }
    }

    public float getStat(PlayerExtendedData playerEx, CreatureFormStatType type2) {
        return this.getStat(this.getFormStats(playerEx), playerEx, type2);
    }

    public CreatureForm.Stats getFormStats(PlayerExtendedData playerEx) {
        return CreatureFormStatManager.INSTANCE.getStats(playerEx.getEffectiveForm());
    }

    private float getStat(CreatureForm.Stats currentForm, PlayerExtendedData playerEx, CreatureFormStatType type2) {
        Int2ObjectOpenHashMap<Object2FloatOpenHashMap<CreatureFormStatType>> cache = currentForm.statModifierCache;
        int level = currentForm.getCreatureTraitType() == null ? 0 : ((CreatureTrait)playerEx.getTransformation(currentForm.getCreatureTraitType())).getLevel();
        Object2FloatOpenHashMap map2 = (Object2FloatOpenHashMap)cache.get(level);
        if (map2 == null) {
            map2 = new Object2FloatOpenHashMap();
            Int2ObjectOpenHashMap<Object2FloatOpenHashMap<CreatureFormStatType>> statModifiers = currentForm.getStatModifiers();
            for (int i = level; i >= 0; --i) {
                Object2FloatOpenHashMap levelModifiers = (Object2FloatOpenHashMap)statModifiers.get(i);
                if (levelModifiers == null) continue;
                for (Object2FloatMap.Entry entry2 : levelModifiers.object2FloatEntrySet()) {
                    CreatureFormStatType key = (CreatureFormStatType)entry2.getKey();
                    if (map2.containsKey((Object)key)) continue;
                    map2.put((Object)key, entry2.getFloatValue());
                }
            }
            cache.put(level, (Object)map2);
        }
        return map2.getFloat((Object)type2);
    }

    public void updateChargeDamage(LivingHurtEvent event, EntityPlayer player, PlayerExtendedData playerEx) {
        if (this.isWolfAnimalForm(playerEx)) {
            if (this.itemHasDamageAttribute(player.func_184586_b(player.func_184600_cs()))) {
                event.setAmount(2.0f);
            } else {
                float damage = this.getStat(playerEx, CreatureFormStatType.DAMAGE);
                if (damage != 0.0f && player.func_70051_ag()) {
                    event.setAmount(event.getAmount() + damage);
                }
            }
        }
        if (playerEx.getTransformation(WitcheryCreatureTraits.WEREWOLF).getLevel() >= 3 && playerEx.getCurrentForm() == null && player.func_70093_af()) {
            double ACCELERATION = 3.0;
            Vec3d look = player.func_70040_Z();
            double motionX = look.field_72450_a * 0.6 * ACCELERATION;
            double motionY = 0.8999999999999999;
            double motionZ = look.field_72449_c * 0.6 * ACCELERATION;
            if (event.getEntityLiving() instanceof EntityPlayerMP) {
                WitcheryNetworkChannel.sendTo(new PacketPushTarget(motionX, motionY, motionZ), (EntityPlayerMP)event.getEntityLiving());
            } else {
                event.getEntityLiving().field_70159_w = motionX;
                event.getEntityLiving().field_70181_x = motionY;
                event.getEntityLiving().field_70179_y = motionZ;
            }
        }
    }

    private boolean itemHasDamageAttribute(ItemStack item) {
        if (item == null) {
            return false;
        }
        EntityEquipmentSlot slot = item.func_77973_b().getEquipmentSlot(item);
        Multimap modifiers = item.func_111283_C(slot == null ? EntityEquipmentSlot.MAINHAND : slot);
        return modifiers.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
    }

    public void rendArmor(EntityLivingBase victim, EntityPlayer player, PlayerExtendedData playerEx) {
        EntityEquipmentSlot slot;
        ItemStack armor;
        if (playerEx.getCurrentForm() == WitcheryAlternateForms.WOLFMAN && playerEx.getTransformation(WitcheryCreatureTraits.WEREWOLF).getLevel() >= 9 && !(armor = victim.func_184582_a(slot = EntityEquipmentSlot.values()[1 + victim.field_70170_p.field_73012_v.nextInt(4)])).func_190926_b()) {
            boolean ripOffArmor;
            boolean bl = ripOffArmor = !armor.func_77984_f();
            if (!ripOffArmor) {
                int damage = armor.func_77952_i();
                int rendAmount = (int)Math.ceil((float)armor.func_77958_k() * 0.25f);
                armor.func_77972_a(rendAmount, (EntityLivingBase)player);
                if (victim instanceof EntityPlayer && armor.func_77973_b() instanceof ItemArmor) {
                    ItemArmor armorItem = (ItemArmor)armor.func_77973_b();
                    armorItem.onArmorTick(victim.field_70170_p, (EntityPlayer)victim, armor);
                }
                boolean bl2 = ripOffArmor = armor.func_77952_i() <= damage;
            }
            if (ripOffArmor && victim instanceof EntityPlayer) {
                victim.func_184201_a(slot, ItemStack.field_190927_a);
                EntityItem droppedItem = victim.func_70099_a(armor, 1.0f);
                if (droppedItem != null) {
                    droppedItem.func_174867_a(100);
                }
            }
        }
    }

    public void processCreatureKilled(LivingDeathEvent event, EntityPlayer attacker, PlayerExtendedData playerEx) {
        if (this.isWolfAnimalForm(playerEx) && playerEx.getTransformation(WitcheryCreatureTraits.WEREWOLF).getLevel() >= 4 && !CreatureUtil.isUndead((Entity)event.getEntityLiving())) {
            if (attacker.func_70681_au().nextInt(3) == 0) {
                attacker.field_70170_p.func_184133_a(null, event.getEntityLiving().func_180425_c(), WitcherySounds.ENTITY_WEREWOLF_EAT, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)event.getEntityLiving().func_70681_au().nextDouble() * 0.4f + 0.8f));
            }
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles((Entity)event.getEntityLiving(), 1.0f, 2.0f, EnumParticleTypes.REDSTONE), (Entity)event.getEntityLiving());
            attacker.func_71024_bL().func_75122_a(8, 0.8f);
        }
    }

    public void processDigging(BlockEvent.HarvestDropsEvent event, EntityPlayer player, PlayerExtendedData playerEx) {
        long serverTime;
        long lastFind;
        WerewolfCreatureTrait transformation = playerEx.getTransformation(WitcheryCreatureTraits.WEREWOLF);
        if (playerEx.getCurrentForm() == WitcheryAlternateForms.WOLF && transformation.getLevel() >= 3 && event.getDrops().size() == 1 && ((ItemStack)event.getDrops().get(0)).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d) && (lastFind = transformation.getLastBoneFind()) + 60000L < (serverTime = MinecraftServer.func_130071_aq()) && player.field_70170_p.field_73012_v.nextInt(20) == 0) {
            transformation.setLastBoneFind(serverTime);
            event.getDrops().add(new ItemStack(Items.field_151103_aS, player.field_70170_p.field_73012_v.nextInt(5) == 0 ? 2 : 1));
        }
    }

    public void processWolfInfection(EntityLivingBase entityLiving, PlayerExtendedData playerEx, float health) {
        if (playerEx.getTransformation(WitcheryCreatureTraits.WEREWOLF).getLevel() >= 10 && this.isWolfAnimalForm(playerEx)) {
            if (entityLiving instanceof EntityVillager) {
                if (health < entityLiving.func_110138_aP() * 0.25f && health > 0.0f && entityLiving.field_70170_p.field_73012_v.nextInt(4) == 1) {
                    EntityVillager villager = (EntityVillager)entityLiving;
                    NBTTagCompound data2 = new NBTTagCompound();
                    villager.func_70014_b(data2);
                    EntityWerewolf.convertToVillager((EntityLiving)villager, data2, false);
                }
            } else if (entityLiving instanceof EntityPlayer && WitcheryConfigOptions.allowPlayerToPlayerWolfInfection) {
                WerewolfCreatureTrait transformation;
                EntityPlayer victim = (EntityPlayer)entityLiving;
                PlayerExtendedData victimEx = WitcheryUtils.getExtension(victim);
                if (health < entityLiving.func_110138_aP() * 0.25f && health > 0.0f && !ItemHunterClothes.isWolfProtectionActive(entityLiving) && entityLiving.field_70170_p.field_73012_v.nextInt(4) == 1 && (WitcheryConfigOptions.allowVampireWolfHybrids || !playerEx.isTransformation(WitcheryCreatureTraits.VAMPIRE)) && (transformation = victimEx.getTransformation(WitcheryCreatureTraits.WEREWOLF)).getLevel() == 0) {
                    transformation.setLevel(1);
                    victim.func_145747_a(new TextComponentTranslation("witchery.werewolf.infection", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)));
                }
            }
        }
    }

    public void processWolfInfection(EntityLivingBase entityLiving, EntityWerewolf attackingEntity, float health) {
        if (attackingEntity.isInfectious()) {
            if (entityLiving instanceof EntityVillager) {
                if (health < entityLiving.func_110138_aP() * 0.25f) {
                    EntityVillager villager = (EntityVillager)entityLiving;
                    NBTTagCompound data2 = new NBTTagCompound();
                    villager.func_70014_b(data2);
                    EntityWerewolf.convertToVillager((EntityLiving)villager, data2, false);
                }
            } else if (entityLiving instanceof EntityPlayer) {
                WerewolfCreatureTrait transformation;
                EntityPlayer victim = (EntityPlayer)entityLiving;
                PlayerExtendedData victimEx = WitcheryUtils.getExtension(victim);
                if ((WitcheryConfigOptions.allowVampireWolfHybrids || !victimEx.isTransformation(WitcheryCreatureTraits.VAMPIRE)) && (transformation = victimEx.getTransformation(WitcheryCreatureTraits.WEREWOLF)).getLevel() == 0) {
                    transformation.setLevel(1);
                    victim.func_145747_a(new TextComponentTranslation("witchery.werewolf.infection", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)));
                }
            }
        }
    }

    public boolean isAnimalForm(EntityPlayer player) {
        return this.isWolfAnimalForm(WitcheryUtils.getExtension(player));
    }

    public boolean isWolfAnimalForm(PlayerExtendedData playerEx) {
        return playerEx.getCurrentForm() != null && this.getFormStats(playerEx).canHowl();
    }

    public boolean isWolfmanAllowed(WerewolfCreatureTrait transformation) {
        return transformation.getLevel() >= 5;
    }

    public boolean canControlTransform(WerewolfCreatureTrait transformation) {
        return transformation.getLevel() >= 2;
    }

    public void applyModifier(IAttribute attribute, AttributeModifier modifier, double modification, AbstractAttributeMap playerAttributes) {
        IAttributeInstance attributeInstance = playerAttributes.func_111151_a(attribute);
        AttributeModifier attributeModifier = new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modification, modifier.func_111169_c());
        attributeInstance.func_188479_b(attributeModifier.func_111167_a());
        attributeInstance.func_111121_a(attributeModifier);
    }

    public void removeModifier(IAttribute attribute, AttributeModifier modifier, AbstractAttributeMap playerAttributes) {
        IAttributeInstance attributeInstance = playerAttributes.func_111151_a(attribute);
        attributeInstance.func_188479_b(modifier.func_111167_a());
    }
}

