/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.entity.passive.coven.WitchEntity;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityBabaYaga
extends EntityMob
implements IRangedAttackMob,
IEntityOwnable,
IHandleDeathTouch,
WitchEntity {
    private static final DataParameter<Boolean> AGGRESSIVE = EntityDataManager.func_187226_a(EntityBabaYaga.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityBabaYaga.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final Item[] witchDrops = new Item[]{WitcheryIngredientItems.SPECTRAL_DUST, WitcheryIngredientItems.BAT_WOOL, WitcheryIngredientItems.FROG_TOE, WitcheryIngredientItems.OWLETS_WING, WitcheryIngredientItems.DOG_TONGUE, WitcheryBrewItems.VINES_BREW, WitcheryBrewItems.SPROUTING_BREW, WitcheryBrewItems.HITCHCOCK_BREW, WitcheryBrewItems.CURSED_LEAPING_BREW, WitcheryBrewItems.FROGS_TONGUE_BREW};
    private static final double MAX_HEALTH = 500.0;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_10).func_186741_a(true);
    long ticksSinceTeleport = 0L;
    private int potionUseTimer;
    private EntityPlayer owner;

    public EntityBabaYaga(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, entity -> !entity.func_110124_au().equals(this.func_184753_b())));
        this.field_70728_aV = 70;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGGRESSIVE, (Object)false);
        this.field_70180_af.func_187214_a(OWNER, (Object)Optional.absent());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        UUID ownerId = this.func_184753_b();
        if (ownerId != null) {
            par1NBTTagCompound.func_186854_a("Owner", ownerId);
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_186855_b("Owner")) {
            this.setOwnerId(par1NBTTagCompound.func_186857_a("Owner"));
        }
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).orNull();
    }

    public EntityPlayer getOwner() {
        if (this.owner == null) {
            this.owner = WitcheryUtils.getPlayer(this.field_70170_p, this.func_184753_b());
        }
        return this.owner;
    }

    public void setOwnerId(UUID id) {
        this.field_70180_af.func_187227_b(OWNER, (Object)Optional.fromNullable((Object)id));
    }

    public int func_70658_aO() {
        return 4;
    }

    protected SoundEvent func_184639_G() {
        return WitcherySounds.ENTITY_BABA_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187923_gw;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_BABA_DEATH;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public boolean isDrinkingPotion() {
        return (Boolean)this.field_70180_af.func_187225_a(AGGRESSIVE);
    }

    @Override
    public void setDrinkingPotion(boolean par1) {
        this.field_70180_af.func_187227_b(AGGRESSIVE, (Object)par1);
    }

    @Override
    public int getPotionUseTimer() {
        return this.potionUseTimer;
    }

    @Override
    public void setPotionUseTimer(int potionUseTimer) {
        this.potionUseTimer = potionUseTimer;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    protected int func_70682_h(int par1) {
        return par1;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer owner;
            WitchEntity.doWitchAttack(this);
            if ((this.func_70661_as().func_75500_f() || this.field_70170_p.field_73012_v.nextDouble() < 0.02) && this.func_70638_az() != null && (long)this.field_70173_aa - this.ticksSinceTeleport > 100L) {
                this.ticksSinceTeleport = this.field_70173_aa;
                this.teleportToEntity((Entity)this.func_70638_az());
            }
            if (this.field_70170_p.field_73012_v.nextDouble() < 0.05 && this.func_70638_az() != null && (this.func_70638_az().field_70160_al || this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75100_b) && !this.func_70638_az().func_70644_a(MobEffects.field_76421_d)) {
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 5));
            }
            if ((owner = this.getOwner()) != null) {
                double distance = this.func_70068_e((Entity)owner);
                if (distance < 64.0 && this.field_70173_aa % 100 == 0) {
                    int l = this.field_70146_Z.nextInt(3);
                    Item i1 = witchDrops[this.field_70146_Z.nextInt(witchDrops.length - 3)];
                    for (int j1 = 0; j1 < l; ++j1) {
                        this.func_70099_a(new ItemStack(i1), 0.0f);
                    }
                }
                if (this.field_70173_aa > 600) {
                    this.func_70106_y();
                    this.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)16);
                }
            }
        }
        super.func_70636_d();
    }

    protected void teleportToEntity(Entity par1Entity) {
        Vec3d vec3 = new Vec3d(this.field_70165_t - par1Entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e(), this.field_70161_v - par1Entity.field_70161_v);
        vec3 = vec3.func_72432_b();
        double d0 = 8.0;
        double d2 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d3 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d4 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        this.teleportTo(d2, d3, d4);
    }

    protected void teleportTo(double par1, double par3, double par5) {
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean flag = false;
        BlockPos pos = this.func_180425_c();
        if (!this.field_70170_p.func_175623_d(pos)) {
            boolean flag2 = false;
            while (!flag2 && pos.func_177956_o() > 0) {
                IBlockState block = this.field_70170_p.func_180495_p(pos.func_177977_b());
                if (block.func_185904_a().func_76230_c()) {
                    flag2 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                pos = pos.func_177977_b();
            }
            if (flag2) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f3 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f2, (double)f3, new int[0]);
        }
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
    }

    protected float func_70672_c(DamageSource par1DamageSource, float par2) {
        par2 = super.func_70672_c(par1DamageSource, par2);
        if (par1DamageSource.func_76346_g() == this) {
            par2 = 0.0f;
        }
        if (par1DamageSource.func_82725_o()) {
            par2 *= 0.15f;
        }
        return par2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 15) {
            for (int i = 0; i < this.field_70146_Z.nextInt(35) + 10; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)0.13f, this.func_174813_aQ().field_72337_e + 0.5 + this.field_70146_Z.nextGaussian() * (double)0.13f, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (par1 == 16) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(par1);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        EntityLiving attacker;
        boolean result2 = super.func_70097_a(source, WitcheryUtils.capAround(damage, 15.0f));
        if (!this.field_70170_p.field_72995_K && source.func_76346_g() != null && source.func_76346_g() instanceof EntityLiving && ((attacker = (EntityLiving)source.func_76346_g()).func_70668_bt() == EnumCreatureAttribute.UNDEAD || attacker instanceof EntityTameable && !((EntityTameable)attacker).func_70909_n())) {
            EntityCaveSpider spider = new EntityCaveSpider(this.field_70170_p);
            spider.func_70012_b(attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, attacker.field_70125_A, attacker.field_70177_z);
            EntityLivingBase target = this.func_70638_az();
            spider.func_70624_b(target);
            spider.func_70604_c(target);
            this.field_70170_p.func_72838_d((Entity)spider);
            spider.func_184185_a(SoundEvents.field_187638_cR, 0.5f, 0.4f / (spider.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(spider.field_70165_t, spider.field_70163_u, spider.field_70161_v, 2.0f, 2.0f, EnumParticleTypes.SPELL_MOB), (Entity)spider);
            attacker.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if (!CreatureUtil.isWoodenDamage(source)) {
                player.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)player), damage * 0.25f);
            }
        }
        return result2;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
        for (int i = 0; i < 20; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
        }
        this.func_70106_y();
    }

    protected void func_70628_a(boolean par1, int par2) {
        int j = this.field_70146_Z.nextInt(3) + 2;
        for (int k = 0; k < j; ++k) {
            int l = this.field_70146_Z.nextInt(3) + 1;
            Item i1 = witchDrops[this.field_70146_Z.nextInt(witchDrops.length)];
            if (par2 > 0) {
                l += this.field_70146_Z.nextInt(par2 + 1);
            }
            for (int j2 = 0; j2 < l; ++j2) {
                this.func_70099_a(new ItemStack(i1), 0.0f);
            }
        }
        Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_186801_a(this.field_70146_Z);
        int m = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)Math.min(enchantment.func_77319_d() + 2, enchantment.func_77325_b()), (int)enchantment.func_77325_b());
        this.func_70099_a(ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, m)), 0.0f);
        this.func_70099_a(new ItemStack((Item)WitcheryEquipmentItems.BABAS_HAT), 0.0f);
    }

    public void func_82196_d(EntityLivingBase par1EntityLivingBase, float par2) {
        if (!this.isDrinkingPotion()) {
            if (this.field_70170_p.field_73012_v.nextInt(3) == 0) {
                ItemKettleBrew brew;
                switch (this.field_70170_p.field_73012_v.nextInt(12)) {
                    case 0: 
                    case 1: {
                        brew = WitcheryBrewItems.WEBS_BREW;
                        break;
                    }
                    case 2: 
                    case 3: {
                        brew = WitcheryBrewItems.THORNS_BREW;
                        break;
                    }
                    case 4: 
                    case 5: {
                        brew = WitcheryBrewItems.FROGS_TONGUE_BREW;
                        break;
                    }
                    case 6: 
                    case 7: {
                        brew = WitcheryBrewItems.INK_BREW;
                        break;
                    }
                    case 8: 
                    case 9: {
                        brew = WitcheryBrewItems.HITCHCOCK_BREW;
                        break;
                    }
                    case 10: {
                        brew = WitcheryBrewItems.BATS_BREW;
                        break;
                    }
                    case 11: {
                        brew = WitcheryBrewItems.WASTING_BREW;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                EntityWitchProjectile entityWitchProjectile = new EntityWitchProjectile(this.field_70170_p, (EntityLivingBase)this, new ItemStack((Item)brew));
                entityWitchProjectile.field_70125_A += 20.0f;
                double d0 = par1EntityLivingBase.field_70165_t + par1EntityLivingBase.field_70159_w - this.field_70165_t;
                double d2 = par1EntityLivingBase.field_70163_u + (double)par1EntityLivingBase.func_70047_e() - (double)1.1f - this.field_70163_u;
                double d3 = par1EntityLivingBase.field_70161_v + par1EntityLivingBase.field_70179_y - this.field_70161_v;
                float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d3 * d3));
                entityWitchProjectile.func_70186_c(d0, d2 + (double)(f1 * 0.2f), d3, 0.75f, 8.0f);
                this.field_70170_p.func_72838_d((Entity)entityWitchProjectile);
            } else {
                PotionType type2 = PotionTypes.field_185252_x;
                ItemStack stack = new ItemStack((Item)Items.field_185155_bH);
                double d4 = par1EntityLivingBase.field_70165_t + par1EntityLivingBase.field_70159_w - this.field_70165_t;
                double d5 = par1EntityLivingBase.field_70163_u + (double)par1EntityLivingBase.func_70047_e() - (double)1.1f - this.field_70163_u;
                double d6 = par1EntityLivingBase.field_70161_v + par1EntityLivingBase.field_70179_y - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d4 * d4 + d6 * d6));
                if (f2 >= 8.0f && !par1EntityLivingBase.func_70644_a(MobEffects.field_76421_d)) {
                    type2 = PotionTypes.field_185246_r;
                } else if (par1EntityLivingBase.func_110143_aJ() >= 8.0f && !par1EntityLivingBase.func_70644_a(MobEffects.field_76436_u)) {
                    type2 = PotionTypes.field_185254_z;
                } else if (f2 <= 3.0f && !par1EntityLivingBase.func_70644_a(MobEffects.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
                    type2 = PotionTypes.field_185226_I;
                }
                EntityPotion entityPotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)stack, (PotionType)type2));
                entityPotion.field_70125_A += 20.0f;
                entityPotion.func_70186_c(d4, d5 + (double)(f2 * 0.2f), d6, 0.75f, 8.0f);
                this.field_70170_p.func_72838_d((Entity)entityPotion);
            }
        }
    }
}

