/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.item.ItemEarmuffs;
import net.msrandom.witchery.util.EntityUtil;

public class EntityBanshee
extends EntitySummonedUndead {
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityBanshee.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityBanshee(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        boolean startedScreaming = false;
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa % 100 == 0 || this.isScreaming() && this.field_70173_aa % 20 == 0)) {
            double radius = 6.0;
            AxisAlignedBB bounds = new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u - radius, this.field_70161_v - radius, this.field_70165_t + radius, this.field_70163_u + radius, this.field_70161_v + radius);
            List players = this.field_70170_p.func_72872_a(EntityLivingBase.class, bounds);
            boolean playersFound = false;
            for (EntityLivingBase player : players) {
                if (!(this.func_70068_e((Entity)player) <= radius * radius) || player != this.func_70638_az() && player != this.func_70638_az() && !(player instanceof EntityPlayer)) continue;
                playersFound = true;
                if (!this.isScreaming()) {
                    this.setScreaming(true);
                    startedScreaming = true;
                }
                if (player instanceof EntityPlayer && ItemEarmuffs.isHelmWorn((EntityPlayer)player)) continue;
                float maxHealth = player.func_110138_aP();
                EntityUtil.touchOfDeath((Entity)player, (EntityLivingBase)this, Math.max(0.1f * maxHealth, 1.0f));
            }
            if (!playersFound && this.isScreaming()) {
                this.setScreaming(false);
            }
        }
        if ((startedScreaming || this.field_70173_aa % 60 == 0) && this.isScreaming()) {
            this.func_184185_a(WitcherySounds.ENTITY_BANSHEE_SCREAM, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.3f + 0.7f);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_SPECTRE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_SPECTRE_HURT;
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    protected void setScreaming(boolean screaming) {
        this.field_70180_af.func_187227_b(SCREAMING, (Object)screaming);
    }
}

