/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.infusions.WitcheryInfusedBrews;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityBroom
extends Entity {
    private static final DataParameter<Integer> BRUSH_COLOR = EntityDataManager.func_187226_a(EntityBroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HIT = EntityDataManager.func_187226_a(EntityBroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DIRECTION = EntityDataManager.func_187226_a(EntityBroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityBroom.class, (DataSerializer)DataSerializers.field_187193_c);
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    boolean riderHasOwlFamiliar = false;
    boolean riderHasSoaringBrew = false;
    private double speedMultiplier = 0.07;

    public EntityBroom(World world) {
        super(world);
        this.field_70156_m = true;
    }

    public EntityBroom(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BRUSH_COLOR, (Object)-1);
        this.field_70180_af.func_187214_a(HIT, (Object)0);
        this.field_70180_af.func_187214_a(DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void func_70081_e(int par1) {
    }

    public EnumDyeColor getBrushColor() {
        return EnumDyeColor.func_176764_b((int)((Integer)this.field_70180_af.func_187225_a(BRUSH_COLOR)));
    }

    public void setBrushColor(EnumDyeColor color2) {
        this.field_70180_af.func_187227_b(BRUSH_COLOR, (Object)color2.func_176765_a());
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return par1Entity.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.4;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!this.func_184188_bt().isEmpty()) {
                    this.func_184220_m(this);
                }
                if (!flag) {
                    ItemStack broomStack = new ItemStack((Item)WitcheryIngredientItems.ENCHANTED_BROOM);
                    if (this.func_145818_k_()) {
                        broomStack.func_151001_c(this.func_95999_t());
                    }
                    WitcheryIngredientItems.ENCHANTED_BROOM.setColor(broomStack, this.getBrushColor());
                    this.func_70099_a(broomStack, 0.0f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpSteps = posRotationIncrements + 5;
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
    }

    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
    }

    public void func_70071_h_() {
        double newHorzVelocity;
        EntityPlayer rider;
        EntityPlayer entityPlayer = rider = this.func_184179_bs() instanceof EntityPlayer ? (EntityPlayer)this.func_184179_bs() : null;
        if (this.field_70173_aa % 100 == 0 && rider != null) {
            this.riderHasSoaringBrew = WitcheryInfusedBrews.SOARING.isActive(rider);
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double initialHorzVelocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            if (this.lerpSteps > 0) {
                double x = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
                double y = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
                double z = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
                double yaw = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
                this.field_70177_z += (float)(yaw / (double)this.lerpSteps);
                this.field_70125_A += (float)((this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
                --this.lerpSteps;
                this.func_70107_b(x, y, z);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.deltaRotation = (float)(this.lerpYaw - (double)this.field_70177_z);
                this.func_70101_b(this.field_70177_z + this.deltaRotation, (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A)));
                this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                this.field_70159_w *= (double)0.99f;
                this.field_70179_y *= (double)0.99f;
            }
        }
        if (rider != null) {
            newHorzVelocity = rider.field_191988_bg;
            if (newHorzVelocity > 0.0) {
                double d2 = -Math.sin(Math.toRadians(rider.field_70177_z));
                double d3 = Math.cos(Math.toRadians(rider.field_70177_z));
                this.field_70159_w += d2 * this.speedMultiplier * (0.1 + (this.riderHasSoaringBrew ? 0.1 : 0.0) + (this.riderHasOwlFamiliar ? 0.2 : 0.0));
                this.field_70179_y += d3 * this.speedMultiplier * (0.1 + (this.riderHasSoaringBrew ? 0.1 : 0.0) + (this.riderHasOwlFamiliar ? 0.2 : 0.0));
                double pitch = -Math.sin(Math.toRadians(rider.field_70125_A));
                if (pitch > -0.5 && pitch < 0.2) {
                    pitch = 0.0;
                } else if (pitch < 0.0) {
                    pitch *= 0.5;
                }
                this.field_70181_x = pitch * this.speedMultiplier * 2.0;
            } else if (newHorzVelocity == 0.0 && (this.riderHasOwlFamiliar || this.riderHasSoaringBrew)) {
                this.field_70159_w *= 0.9;
                this.field_70179_y *= 0.9;
            }
        } else {
            this.riderHasOwlFamiliar = false;
            double moX = this.field_70159_w * 0.9;
            double moZ = this.field_70179_y * 0.9;
            this.field_70159_w = Math.abs(moX) < 0.01 ? 0.0 : moX;
            double d = this.field_70179_y = Math.abs(moZ) < 0.01 ? 0.0 : moZ;
            if (!this.field_70122_E) {
                this.field_70181_x = -0.2;
            }
        }
        newHorzVelocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        double speedLimit = 0.9 + (this.riderHasOwlFamiliar ? 0.3 : 0.0) + (this.riderHasSoaringBrew ? 0.3 : 0.0);
        if (newHorzVelocity > speedLimit) {
            double d2 = speedLimit / newHorzVelocity;
            this.field_70159_w *= d2;
            this.field_70179_y *= d2;
            this.field_70181_x *= d2;
            newHorzVelocity = speedLimit;
        }
        double accelerationLimit = this.riderHasSoaringBrew || this.riderHasOwlFamiliar ? 0.35 : 0.35;
        double accelerationFactor = accelerationLimit * 100.0;
        if (newHorzVelocity > initialHorzVelocity && this.speedMultiplier < accelerationLimit) {
            this.speedMultiplier += (accelerationLimit - this.speedMultiplier) / accelerationFactor;
            if (this.speedMultiplier > accelerationLimit) {
                this.speedMultiplier = accelerationLimit;
            }
        } else {
            this.speedMultiplier -= (this.speedMultiplier - 0.07) / accelerationFactor;
            if (this.speedMultiplier < 0.07) {
                this.speedMultiplier = 0.07;
            }
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.99f;
        this.field_70181_x *= (double)0.99f;
        this.field_70179_y *= (double)0.99f;
        this.field_70125_A = 0.0f;
        float rotation = this.field_70177_z;
        double d3 = this.field_70169_q - this.field_70165_t;
        double d4 = this.field_70166_s - this.field_70161_v;
        if (d3 * d3 + d4 * d4 > 0.001) {
            rotation = (float)Math.toDegrees(Math.atan2(d4, d3));
        }
        this.deltaRotation = MathHelper.func_76142_g((float)(rotation - this.field_70177_z));
        this.field_70177_z += this.deltaRotation;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.2, 0.0, 0.2))) {
            if (entity == rider || !entity.func_70104_M() || !(entity instanceof EntityBroom)) continue;
            entity.func_70108_f((Entity)this);
        }
        if (rider != null && rider.field_70128_L) {
            rider.func_110145_l((Entity)this);
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74774_a("BrushColor", (byte)this.getBrushColor().func_176765_a());
    }

    protected void func_70037_a(NBTTagCompound tag) {
        if (tag.func_74764_b("BrushColor")) {
            this.field_70180_af.func_187227_b(BRUSH_COLOR, (Object)tag.func_74771_c("BrushColor"));
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        EnumDyeColor color2;
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayer && this.func_184188_bt().get(0) != player) {
            return true;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.field_70170_p.field_72995_K && (color2 = WitcheryUtils.getDyeColor(itemstack)) != null) {
            this.setBrushColor(color2);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.riderHasOwlFamiliar = Familiars.hasFamiliarPower(player, WitcheryFamiliars.BROOM_MASTERY);
            this.riderHasSoaringBrew = WitcheryInfusedBrews.SOARING.isActive(player);
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setDamageTaken(float par1) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(par1));
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(HIT);
    }

    public void setTimeSinceHit(int par1) {
        this.field_70180_af.func_187227_b(HIT, (Object)par1);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(DIRECTION);
    }

    public void setForwardDirection(int par1) {
        this.field_70180_af.func_187227_b(DIRECTION, (Object)par1);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list2 = this.func_184188_bt();
        return list2.isEmpty() ? null : (Entity)list2.get(0);
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
            this.field_70125_A = (float)this.lerpPitch;
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double f = 0.0;
            double f1 = (this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W();
            int i = this.func_184188_bt().indexOf(passenger);
            if (this.func_184188_bt().size() > 1) {
                f = i == 0 ? 0.2 : -0.6;
                if (passenger instanceof EntityAnimal) {
                    f += 0.4;
                }
            }
            Vec3d vec3d = new Vec3d(f, 0.0, 0.0).func_178785_b((float)Math.toRadians((double)(-this.field_70177_z) + 180.0));
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + f1, this.field_70161_v + vec3d.field_72449_c);
            if (i == 1) {
                passenger.field_70177_z += this.deltaRotation;
                passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
                this.applyYawToEntity(passenger);
            }
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }
}

