/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.ai.EntityAIAttackCloseTargetOnCollide;
import net.msrandom.witchery.entity.ai.EntityAIDemonicBarginPlayer;
import net.msrandom.witchery.entity.ai.EntityAILookAtDemonicBarginPlayer;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;

public class EntityDemon
extends EntityGolem
implements IRangedAttackMob,
IMerchant,
IAnimals {
    private static final DataParameter<Integer> ATTACK_TIMER = EntityDataManager.func_187226_a(EntityDemon.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int tryEscape = -1;

    public EntityDemon(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackCloseTargetOnCollide((EntityCreature)this, 1.0, true, 3.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 20, 15.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIDemonicBarginPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookAtDemonicBarginPlayer(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, true, false, null));
        this.field_70728_aV = 10;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TIMER, (Object)0);
    }

    public boolean func_184645_a(EntityPlayer par1EntityPlayer, EnumHand hand) {
        boolean flag;
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
            return super.func_184645_a(par1EntityPlayer, hand);
        }
        ItemStack itemstack = par1EntityPlayer.func_184586_b(hand);
        boolean bl = flag = !itemstack.func_190926_b() && (itemstack.func_77973_b() == Items.field_151063_bx || itemstack.func_77973_b() == Items.field_151057_cb);
        if (!flag && this.func_70089_S() && !this.isTrading() && !this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(par1EntityPlayer);
                par1EntityPlayer.func_180472_a((IMerchant)this);
            }
            return true;
        }
        return super.func_184645_a(par1EntityPlayer, hand);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, WitcheryUtils.capAround(amount, 15.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected int func_70682_h(int par1) {
        return par1;
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState state;
        Block l;
        int attackTimer;
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70624_b(null);
        }
        if ((attackTimer = this.getAttackTimer()) > 0) {
            this.setAttackTimer(attackTimer - 1);
        }
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this) && WitcheryUtils.getNightmareLevel(this.field_70170_p) != SpiritWorldData.NightmareLevel.DEMONIC) {
            this.func_70106_y();
        }
        if (this.tryEscape == 0) {
            this.tryEscape = -1;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, true);
        } else if (this.tryEscape > 0) {
            --this.tryEscape;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (l = (state = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_177230_c()) != Blocks.field_150350_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.buyingList != null) {
            par1NBTTagCompound.func_74782_a("Bargains", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("Bargains")) {
            NBTTagCompound nbttagcompound1 = par1NBTTagCompound.func_74775_l("Bargains");
            this.buyingList = new MerchantRecipeList(nbttagcompound1);
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        boolean flag = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(7 + this.field_70146_Z.nextInt(15)));
        if (flag) {
            par1Entity.field_70181_x += (double)0.4f;
        }
        this.setAttackTimer(10);
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    public int getAttackTimer() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TIMER);
    }

    public void setAttackTimer(int timer) {
        this.field_70180_af.func_187227_b(ATTACK_TIMER, (Object)timer);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187851_gB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public int func_70627_aG() {
        return 120;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int j = this.field_70146_Z.nextInt(2 + lootingModifier);
            for (int k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151064_bs, 1);
            }
        }
    }

    protected Item func_146068_u() {
        return Items.field_151064_bs;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public void func_82196_d(EntityLivingBase targetEntity, float par2) {
        if (targetEntity.func_184614_ca().func_77973_b() != WitcheryGeneralItems.DEVILS_TONGUE_CHARM && targetEntity.func_184592_cb().func_77973_b() != WitcheryGeneralItems.DEVILS_TONGUE_CHARM || this.field_70170_p.field_73012_v.nextDouble() < 0.05) {
            double d0 = targetEntity.field_70165_t - this.field_70165_t;
            double d2 = targetEntity.func_174813_aQ().field_72338_b + (double)(targetEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d3 = targetEntity.field_70161_v - this.field_70161_v;
            float f1 = MathHelper.func_76129_c((float)par2) * 0.5f;
            EntityLargeFireball fireballEntity = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d2, d3 + this.field_70146_Z.nextGaussian() * (double)f1);
            double d4 = 1.0;
            Vec3d vec3 = this.func_70676_i(1.0f);
            fireballEntity.field_70165_t = this.field_70165_t + vec3.field_72450_a * d4;
            fireballEntity.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
            fireballEntity.field_70161_v = this.field_70161_v + vec3.field_72449_c * d4;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175718_b(1009, this.func_190671_u_(), 0);
                this.field_70170_p.func_72838_d((Entity)fireballEntity);
            }
        }
    }

    public void func_184724_a(boolean b) {
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76430_j, Integer.MAX_VALUE, 4));
        return super.func_180482_a(difficulty, par1EntityLivingData);
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public void func_70932_a_(EntityPlayer par1EntityPlayer) {
        this.buyingPlayer = par1EntityPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void func_70933_a(MerchantRecipe par1MerchantRecipe) {
        par1MerchantRecipe.func_77399_f();
        Item itemToBuy = par1MerchantRecipe.func_77394_a().func_77973_b();
        if (!(this.field_70170_p.field_72995_K || itemToBuy != Items.field_151064_bs && itemToBuy != Items.field_151072_bj)) {
            this.func_184185_a(SoundEvents.field_187853_gC, this.func_70599_aP(), this.func_70647_i());
            this.tryEscape = 50;
        } else {
            this.func_184185_a(SoundEvents.field_189109_ed, this.func_70599_aP(), this.func_70647_i());
        }
        if (this.func_70931_l_() != null && (this.func_70931_l_().func_184614_ca().func_77973_b() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM || this.func_70931_l_().func_184592_cb().func_77973_b() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM)) {
            (this.func_70931_l_().func_184614_ca().func_77973_b() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM ? this.func_70931_l_().func_184614_ca() : this.func_70931_l_().func_184592_cb()).func_77972_a(5, (EntityLivingBase)this.func_70931_l_());
        }
    }

    public void func_110297_a_(ItemStack par1ItemStack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            if (par1ItemStack.func_190926_b()) {
                this.func_184185_a(SoundEvents.field_187925_gy, this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return this.func_180425_c();
    }

    public MerchantRecipeList func_70934_b(EntityPlayer par1EntityPlayer) {
        if (this.buyingList == null) {
            this.addDefaultEquipmentAndRecipies(this.field_70146_Z.nextInt(4) + 6);
        }
        if (this.func_70931_l_() != null && (this.func_70931_l_().func_184614_ca().func_77973_b() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM || this.func_70931_l_().func_184592_cb().func_77973_b() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM)) {
            MerchantRecipeList list2 = new MerchantRecipeList();
            for (MerchantRecipe recipe : this.buyingList) {
                NBTTagCompound nbtTag = recipe.func_77395_g();
                MerchantRecipe recipe2 = new MerchantRecipe(nbtTag);
                ItemStack cost = recipe2.func_77394_a();
                cost.func_190920_e(Math.max(cost.func_190916_E() - (cost.func_77973_b() == Items.field_151043_k ? 5 : (cost.func_77973_b() == Items.field_151166_bC ? 2 : (cost.func_77973_b() == Items.field_151045_i ? 0 : 1))), 1));
                list2.add((Object)recipe2);
            }
            return list2;
        }
        return this.buyingList;
    }

    private Item getCurrency() {
        double chance = this.field_70146_Z.nextDouble();
        if (chance < 0.2) {
            return Items.field_151072_bj;
        }
        if (chance < 0.4) {
            return Items.field_151064_bs;
        }
        if (chance < 0.5) {
            return Items.field_151045_i;
        }
        if (chance < 0.75) {
            return Items.field_151166_bC;
        }
        return Items.field_151043_k;
    }

    private ItemStack getPrice(int basePriceInEmeralds) {
        Item currency = this.getCurrency();
        int multiplier = currency == Items.field_151043_k ? 1 : (currency == Items.field_151166_bC ? 3 : (currency == Items.field_151045_i ? 5 : 4));
        int quantity = Math.max(1, basePriceInEmeralds / multiplier);
        return new ItemStack(currency, quantity);
    }

    private void addDefaultEquipmentAndRecipies(int par1) {
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        int STOCK_REDUCTION = -5;
        for (int i = 0; i < par1; ++i) {
            Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_186801_a(this.field_70146_Z);
            int k = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            ItemStack itemstack = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, k));
            int j = 2 + this.field_70146_Z.nextInt(5 + k * 10) + 3 * k;
            MerchantRecipe recipe = new MerchantRecipe(this.getPrice(j), itemstack);
            recipe.func_82783_a(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe);
        }
        if (this.field_70146_Z.nextDouble() < 0.25) {
            MerchantRecipe recipe2 = new MerchantRecipe(this.getPrice(this.field_70146_Z.nextInt(3) + 8), new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST, this.field_70146_Z.nextInt(4) + 3));
            recipe2.func_82783_a(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        if (this.field_70146_Z.nextDouble() < 0.25) {
            MerchantRecipe recipe2 = new MerchantRecipe(this.getPrice(this.field_70146_Z.nextInt(3) + 8), new ItemStack(WitcheryIngredientItems.DOG_TONGUE, this.field_70146_Z.nextInt(4) + 4));
            recipe2.func_82783_a(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        if (this.field_70146_Z.nextDouble() < 0.15) {
            MerchantRecipe recipe2 = new MerchantRecipe(this.getPrice(this.field_70146_Z.nextInt(10) + 20), new ItemStack((Item)WitcheryBrewItems.REDSTONE_SOUP, 1));
            recipe2.func_82783_a(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        if (this.field_70146_Z.nextDouble() < 0.15) {
            MerchantRecipe recipe2 = new MerchantRecipe(new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151073_bk, 2));
            recipe2.func_82783_a(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        if (this.field_70146_Z.nextDouble() < 0.15) {
            MerchantRecipe recipe2 = new MerchantRecipe(new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151079_bi, 2));
            recipe2.func_82783_a(STOCK_REDUCTION);
            merchantrecipelist.add((Object)recipe2);
        }
        Collections.shuffle(merchantrecipelist);
        Item currencyForHeart = this.getCurrency();
        MerchantRecipe heartRecipe = new MerchantRecipe(new ItemStack(currencyForHeart, currencyForHeart == Items.field_151043_k ? 30 : 3), new ItemStack((Block)WitcheryBlocks.DEMON_HEART, 1));
        heartRecipe.func_82783_a(STOCK_REDUCTION);
        merchantrecipelist.add(this.field_70146_Z.nextInt(3), (Object)heartRecipe);
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int j2 = 0; j2 < par1 && j2 < merchantrecipelist.size(); ++j2) {
            this.buyingList.add(merchantrecipelist.get(j2));
        }
    }

    public void func_70930_a(MerchantRecipeList par1MerchantRecipeList) {
    }
}

