/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.util.EntityUtil;

public class EntityDroplet
extends Entity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityDroplet.class, (DataSerializer)DataSerializers.field_187192_b);
    public int throwableShake;
    protected boolean inGround;
    private BlockPos pos = BlockPos.field_177992_a;
    private Block tile;
    private int ticksInGround;
    private int ticksInAir;
    private BrewActionList actionList;

    public EntityDroplet(World world) {
        super(world);
    }

    public EntityDroplet(World world, double x, double y, double z, BrewActionList actionList) {
        super(world);
        this.ticksInGround = 0;
        this.func_70107_b(x, y, z);
        this.actionList = actionList;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    protected void setColor(int color2) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distSq) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return distSq < (d1 *= 64.0) * d1;
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        float n2;
        float n;
        float f2 = MathHelper.func_76133_a((double)(p_70186_1_ * p_70186_1_ + p_70186_3_ * p_70186_3_ + p_70186_5_ * p_70186_5_));
        p_70186_1_ /= (double)f2;
        p_70186_3_ /= (double)f2;
        p_70186_5_ /= (double)f2;
        p_70186_1_ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        p_70186_3_ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        p_70186_5_ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_;
        this.field_70159_w = p_70186_1_ *= (double)p_70186_7_;
        this.field_70181_x = p_70186_3_ *= (double)p_70186_7_;
        this.field_70179_y = p_70186_5_ *= (double)p_70186_7_;
        float f3 = MathHelper.func_76133_a((double)(p_70186_1_ * p_70186_1_ + p_70186_5_ * p_70186_5_));
        this.field_70177_z = n = (float)(Math.atan2(p_70186_1_, p_70186_5_) * 180.0 / Math.PI);
        this.field_70126_B = n;
        this.field_70125_A = n2 = (float)(Math.atan2(p_70186_3_, f3) * 180.0 / Math.PI);
        this.field_70127_C = n2;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double motionX, double motionY, double motionZ) {
        this.field_70159_w = motionX;
        this.field_70181_x = motionY;
        this.field_70179_y = motionZ;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float n2;
            float n;
            float f = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
            this.field_70177_z = n = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
            this.field_70126_B = n;
            this.field_70125_A = n2 = (float)(Math.atan2(motionY, f) * 180.0 / Math.PI);
            this.field_70127_C = n2;
        }
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.field_70170_p.func_180495_p(this.pos).func_177230_c() == this.tile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3d vec3 = this.func_174791_d();
        Vec3d vec4 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec4);
        vec3 = this.func_174791_d();
        vec4 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            vec4 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = null;
            List list2 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (Entity entity2 : list2) {
                double d2;
                if (!entity2.func_70067_L() || this.ticksInAir < 5) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity2.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition2 = axisalignedbb.func_72327_a(vec3, vec4);
                if (movingobjectposition2 == null || !((d2 = vec3.func_72438_d(movingobjectposition2.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity2;
                d0 = d2;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(new BlockPos(movingobjectposition.func_178782_a().func_177958_n(), movingobjectposition.func_178782_a().func_177956_o(), movingobjectposition.func_178782_a().func_177952_p())).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(this.func_180425_c());
            } else {
                this.onImpact(movingobjectposition);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f3 = 0.99f;
        float f4 = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f5 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f5, this.field_70163_u - this.field_70181_x * (double)f5, this.field_70161_v - this.field_70179_y * (double)f5, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f3 = 0.8f;
        }
        this.field_70159_w *= (double)f3;
        this.field_70181_x *= (double)f3;
        this.field_70179_y *= (double)f3;
        this.field_70181_x -= (double)f4;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected void onImpact(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175718_b(1016, this.func_180425_c(), this.getColor());
            if (mop != null) {
                ModifiersEffect modifiers = new ModifiersEffect(1.0, 1.0, false, this.func_174791_d(), true, 1, EntityUtil.playerOrFake(this.field_70170_p, null));
                switch (mop.field_72313_a) {
                    case BLOCK: {
                        this.actionList.applyToBlock(this.field_70170_p, mop.func_178782_a(), mop.field_178784_b, 1, modifiers);
                        break;
                    }
                    case ENTITY: {
                        if (!(mop.field_72308_g instanceof EntityLivingBase)) break;
                        this.actionList.applyToEntity(this.field_70170_p, (EntityLivingBase)mop.field_72308_g, modifiers);
                    }
                }
            }
        }
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound nbtRoot) {
        nbtRoot.func_74768_a("xTile", this.pos.func_177958_n());
        nbtRoot.func_74768_a("yTile", this.pos.func_177956_o());
        nbtRoot.func_74768_a("zTile", this.pos.func_177952_p());
        nbtRoot.func_74778_a("inTile", this.tile.getRegistryName().toString());
        nbtRoot.func_74774_a("shake", (byte)this.throwableShake);
        nbtRoot.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        nbtRoot.func_74782_a("Brew", (NBTBase)this.actionList.write());
    }

    public void func_70037_a(NBTTagCompound nbtRoot) {
        this.pos = new BlockPos(nbtRoot.func_74762_e("xTile"), nbtRoot.func_74762_e("yTile"), nbtRoot.func_74762_e("zTile"));
        this.tile = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbtRoot.func_74779_i("inTile")));
        this.throwableShake = nbtRoot.func_74771_c("shake") & 0xFF;
        this.inGround = nbtRoot.func_74771_c("inGround") == 1;
        this.actionList = new BrewActionList(nbtRoot.func_150295_c("Brew", 10));
        if (this.actionList.size() == 0) {
            this.func_70106_y();
        }
    }
}

