/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.WitcheryWoodType;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityEnt
extends EntityMob
implements IEntityOwnable {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityEnt.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityEnt.class, (DataSerializer)DataSerializers.field_187198_h);
    private int attackTimer;
    private EntityPlayer owner;

    public EntityEnt(World par1World) {
        super(par1World);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, null));
        this.field_70728_aV = 25;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    public void setScreaming(boolean par1) {
        this.field_70180_af.func_187227_b(SCREAMING, (Object)par1);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.setScreaming(this.func_70638_az() != null);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected int func_70682_h(int par1) {
        return par1;
    }

    protected void func_82167_n(Entity par1Entity) {
        super.func_82167_n(par1Entity);
    }

    public void func_70636_d() {
        Block l;
        int k;
        int j;
        int i2;
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(300) == 0) {
            try {
                i2 = MathHelper.func_76128_c((double)this.field_70165_t);
                j = MathHelper.func_76128_c((double)this.field_70163_u) - 1;
                k = MathHelper.func_76128_c((double)this.field_70161_v);
                ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), (World)this.field_70170_p, (BlockPos)new BlockPos(i2, j, k));
            }
            catch (Throwable i2) {
                // empty catch block
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (l = this.field_70170_p.func_180495_p(new BlockPos(i2 = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c()) != Blocks.field_150350_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.field_149771_c.func_148757_b((Object)l)});
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        UUID ownerId = this.func_184753_b();
        if (ownerId != null) {
            par1NBTTagCompound.func_186854_a("Owner", ownerId);
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_186855_b("Owner")) {
            this.setOwnerId(par1NBTTagCompound.func_186857_a("Owner"));
        }
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).orNull();
    }

    public void setOwnerId(UUID owner) {
        this.func_110163_bv();
        this.field_70180_af.func_187227_b(OWNER, (Object)Optional.fromNullable((Object)owner));
    }

    public EntityPlayer getOwner() {
        if (this.owner == null) {
            this.owner = WitcheryUtils.getPlayer(this.field_70170_p, this.func_184753_b());
        }
        return this.owner;
    }

    public boolean func_70652_k(Entity par1Entity) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = super.func_70652_k(par1Entity);
        if (flag) {
            par1Entity.field_70181_x += (double)0.4f;
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(par1);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        amount = WitcheryUtils.capAround(amount, 15.0f);
        if (entity instanceof EntityLivingBase && (source.field_76373_n.equals("mob") || source.field_76373_n.equals("player")) && !((EntityLivingBase)entity).func_184614_ca().func_190926_b() && ((EntityLivingBase)entity).func_184614_ca().func_77973_b() instanceof ItemAxe) {
            amount *= 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187933_hg;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187932_hf;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    protected void func_70628_a(boolean par1, int par2) {
        WitcheryWoodType type2;
        this.func_70099_a(new ItemStack(WitcheryIngredientItems.ENT_TWIG), 0.0f);
        switch (this.field_70146_Z.nextInt(3)) {
            default: {
                type2 = WitcheryWoodTypes.ROWAN;
                break;
            }
            case 1: {
                type2 = WitcheryWoodTypes.ALDER;
                break;
            }
            case 2: {
                type2 = WitcheryWoodTypes.HAWTHORN;
            }
        }
        this.func_70099_a(new ItemStack((Block)type2.getSapling()), 0.0f);
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
    }

    protected boolean func_70692_ba() {
        return true;
    }
}

