/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.entity.ai.EntityAIAvoidEntityConditionally;
import net.msrandom.witchery.entity.ai.EntityAIDigBlocks;
import net.msrandom.witchery.entity.ai.EntityAIDropOffBlocks;
import net.msrandom.witchery.entity.ai.EntityAIGoblinMate;
import net.msrandom.witchery.entity.ai.EntityAILookAtTradePlayerGeneric;
import net.msrandom.witchery.entity.ai.EntityAIMoveIndoorsLeashAware;
import net.msrandom.witchery.entity.ai.EntityAIPickUpBlocks;
import net.msrandom.witchery.entity.ai.EntityAITradePlayerGeneric;
import net.msrandom.witchery.entity.ai.EntityAIWorship;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class EntityGoblin
extends EntityAgeable
implements IMerchant,
INpc,
EntityAIAvoidEntityConditionally.IAvoidEntities {
    public static final Map<Item, Tuple<Integer, Integer>> villagersSellingList = new HashMap<Item, Tuple<Integer, Integer>>();
    public static final Map<Item, Tuple<Integer, Integer>> blacksmithSellingList = new HashMap<Item, Tuple<Integer, Integer>>();
    private static final DataParameter<Integer> PROFESSION = EntityDataManager.func_187226_a(EntityGoblin.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.func_187226_a(EntityGoblin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WORKING = EntityDataManager.func_187226_a(EntityGoblin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WORSHIPPING = EntityDataManager.func_187226_a(EntityGoblin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final double KOBOLDITE_HARVEST_CHANCE = 0.02;
    Village village;
    private int randomTickDivider;
    private boolean isMating;
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private int wealth;
    private UUID lastBuyingPlayer;
    private boolean isLookingForHome;
    private float probability;
    private final EntityAIWorship aiWorship;
    private boolean preventDespawn;
    private boolean testingLeashRange;

    public EntityGoblin(World par1World) {
        super(par1World);
        this.setProfession(this.field_70146_Z.nextInt(4));
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.aiWorship = new EntityAIWorship(this, 600 + this.field_70146_Z.nextInt(10));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiWorship);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPickUpBlocks(this, 24.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIDropOffBlocks(this, 24.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIDigBlocks(this, 16.0, 0.02));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(3, new EntityAIAvoidEntityConditionally<EntityVillageGuard>((EntityCreature)this, EntityVillageGuard.class, 12.0f, 0.8, 0.8, this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITradePlayerGeneric(this, (EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookAtTradePlayerGeneric((EntityLiving)this, this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveIndoorsLeashAware((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIGoblinMate(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityGoblin.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, true, true, entity -> entity == null || this.field_70170_p.func_72872_a(EntityGoblin.class, this.func_174813_aQ().func_186662_g(8.0)).size() >= 3));
    }

    public static void addItemToSwapForAnEmerald(MerchantRecipeList buyList, Item item, Random rand, float probability) {
        if (rand.nextFloat() < probability) {
            if (rand.nextInt(3) == 0) {
                buyList.add((Object)new MerchantRecipe(EntityGoblin.getItemStackToSwapForAnEmerald(item, rand), new ItemStack(WitcheryIngredientItems.KOBOLDITE_DUST)));
            } else {
                buyList.add((Object)new MerchantRecipe(EntityGoblin.getItemStackToSwapForAnEmerald(item, rand), Items.field_151166_bC));
            }
        }
    }

    private static ItemStack getItemStackToSwapForAnEmerald(Item item, Random rand) {
        return new ItemStack(item, EntityGoblin.getQuantityToSwapForAnEmerald(item, rand), 0);
    }

    private static int getQuantityToSwapForAnEmerald(Item item, Random rand) {
        Tuple<Integer, Integer> tuple = villagersSellingList.get(item);
        return tuple == null ? 1 : ((Integer)tuple.func_76341_a() >= (Integer)tuple.func_76340_b() ? (Integer)tuple.func_76341_a() : (Integer)tuple.func_76341_a() + rand.nextInt((Integer)tuple.func_76340_b() - (Integer)tuple.func_76341_a()));
    }

    public static void addItemToBuyOrSell(MerchantRecipeList list2, Item item, Random rand, float probability) {
        if (rand.nextFloat() < probability) {
            ItemStack itemstack2;
            ItemStack itemstack;
            int i = EntityGoblin.quantityToBuyOrSell(item, rand);
            if (i < 0) {
                itemstack = new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, 1);
                itemstack2 = new ItemStack(item, -i, 0);
            } else {
                itemstack = new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, i);
                itemstack2 = new ItemStack(item, 1, 0);
            }
            list2.add((Object)new MerchantRecipe(itemstack, itemstack2));
        }
    }

    private static int quantityToBuyOrSell(Item item, Random rand) {
        Tuple<Integer, Integer> tuple = blacksmithSellingList.get(item);
        return tuple == null ? 1 : ((Integer)tuple.func_76341_a() >= (Integer)tuple.func_76340_b() ? (Integer)tuple.func_76341_a() : (Integer)tuple.func_76341_a() + rand.nextInt((Integer)tuple.func_76340_b() - (Integer)tuple.func_76341_a()));
    }

    @Override
    public boolean shouldAvoid() {
        double R = 8.0;
        return this.field_70170_p.func_72872_a(EntityGoblin.class, new AxisAlignedBB(this.field_70165_t - R, this.field_70163_u - R, this.field_70161_v - R, this.field_70165_t + R, this.field_70163_u + R, this.field_70161_v + R)).size() >= 3;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public boolean func_70652_k(Entity targetEntity) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (targetEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                targetEntity.func_70015_d(j * 4);
            }
            if (targetEntity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
        }
        return flag;
    }

    protected void func_70619_bc() {
        int randomTickDivider;
        this.randomTickDivider = randomTickDivider = this.randomTickDivider - 1;
        if (randomTickDivider <= 0) {
            this.field_70170_p.field_72982_D.func_176060_a(this.func_180425_c());
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.village = this.field_70170_p.field_72982_D.func_176056_a(this.func_190671_u_(), 32);
            if (this.village == null) {
                this.func_110177_bN();
            } else {
                this.preventDespawn = true;
                BlockPos chunkcoordinates = this.village.func_180608_a();
                this.func_175449_a(chunkcoordinates, (int)((float)this.village.func_75568_b() * 0.6f));
                if (this.isLookingForHome) {
                    this.isLookingForHome = false;
                    this.village.func_82683_b(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    if (this.buyingList.size() > 1) {
                        for (MerchantRecipe merchantrecipe : this.buyingList) {
                            if (!merchantrecipe.func_82784_g()) continue;
                            merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                        }
                    }
                    this.addDefaultEquipmentAndRecipies();
                    this.needsInitilization = false;
                    if (this.village != null && this.lastBuyingPlayer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.village.modifyPlayerReputation(this.lastBuyingPlayer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    protected void func_110159_bB() {
        try {
            this.testingLeashRange = true;
            if (this.func_110167_bD()) {
                this.preventDespawn = true;
            }
            super.func_110159_bB();
        }
        finally {
            this.testingLeashRange = false;
        }
    }

    public float func_70032_d(Entity par1Entity) {
        float distance = super.func_70032_d(par1Entity);
        if (this.testingLeashRange && distance < 9.0f) {
            distance *= 0.5f;
        }
        return distance;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setClimbing(this.field_70123_F);
        }
    }

    public boolean isWorking() {
        return (Boolean)this.field_70180_af.func_187225_a(WORKING);
    }

    public void setWorking(boolean par1) {
        this.field_70180_af.func_187227_b(WORKING, (Object)par1);
    }

    public boolean isWorshipping() {
        return (Boolean)this.field_70180_af.func_187225_a(WORSHIPPING);
    }

    public void setWorshipping(boolean worshiping) {
        this.field_70180_af.func_187227_b(WORSHIPPING, (Object)worshiping);
    }

    public void beginWorship(TileEntity tile) {
        this.aiWorship.begin(tile);
    }

    public boolean func_70617_f_() {
        return (Boolean)this.field_70180_af.func_187225_a(CLIMBING);
    }

    public void setClimbing(boolean climbing) {
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean heldSpawnEgg;
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = heldSpawnEgg = !stack.func_190926_b() && stack.func_77973_b() == Items.field_151063_bx;
        if (!(heldSpawnEgg || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            if (this.func_110167_bD()) {
                if (this.func_184586_b(hand).func_190926_b()) {
                    if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemPickaxe) {
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    }
                } else {
                    if (!this.field_70170_p.field_72995_K) {
                        ItemStack goblinItem = this.func_184586_b(hand);
                        if (!player.field_71071_by.func_70441_a(goblinItem)) {
                            this.func_70099_a(goblinItem, 1.0f);
                        } else if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                        }
                    }
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                }
            } else if (!(this.isWorking() || this.isWorshipping() || this.village == null || this.field_70170_p.field_72995_K)) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROFESSION, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)false);
        this.field_70180_af.func_187214_a(WORKING, (Object)false);
        this.field_70180_af.func_187214_a(WORSHIPPING, (Object)false);
    }

    public void func_70014_b(NBTTagCompound nbtRoot) {
        super.func_70014_b(nbtRoot);
        nbtRoot.func_74768_a("Profession", this.getProfession());
        nbtRoot.func_74768_a("Riches", this.wealth);
        nbtRoot.func_74757_a("Worshipping", this.isWorshipping());
        if (this.buyingList != null) {
            nbtRoot.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
        nbtRoot.func_74757_a("PreventDespawn", this.preventDespawn);
    }

    public void func_70037_a(NBTTagCompound nbtRoot) {
        super.func_70037_a(nbtRoot);
        this.setProfession(nbtRoot.func_74762_e("Profession"));
        this.wealth = nbtRoot.func_74762_e("Riches");
        if (nbtRoot.func_74767_n("Worshipping") && !this.field_70170_p.field_72995_K) {
            this.setWorshipping(true);
        }
        if (nbtRoot.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound1 = nbtRoot.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound1);
        }
        this.preventDespawn = nbtRoot.func_74767_n("PreventDespawn");
    }

    protected float func_70647_i() {
        return 1.2f;
    }

    protected boolean func_70692_ba() {
        return WitcheryConfigOptions.goblinDespawns && this.village == null && !this.preventDespawn && !this.isWorshipping();
    }

    protected SoundEvent func_184639_G() {
        return this.isTrading() ? WitcherySounds.ENTITY_GOBLIN_HAGGLE : WitcherySounds.ENTITY_GOBLIN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_GOBLIN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_GOBLIN_DEATH;
    }

    public int getProfession() {
        return (Integer)this.field_70180_af.func_187225_a(PROFESSION);
    }

    public void setProfession(int par1) {
        this.field_70180_af.func_187227_b(PROFESSION, (Object)par1);
    }

    public boolean isMating() {
        return this.isMating;
    }

    public void setMating(boolean par1) {
        this.isMating = par1;
    }

    public void func_70604_c(EntityLivingBase par1EntityLivingBase) {
        super.func_70604_c(par1EntityLivingBase);
        if (this.village != null && par1EntityLivingBase != null) {
            this.village.func_75575_a(par1EntityLivingBase);
            if (par1EntityLivingBase instanceof EntityPlayer) {
                if (this.func_70631_g_()) {
                    this.village.modifyPlayerReputation(par1EntityLivingBase.func_110124_au(), -3);
                }
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        if (this.village != null) {
            Entity entity = par1DamageSource.func_76346_g();
            if (entity != null) {
                if (!(entity instanceof EntityPlayer) && entity instanceof IMob) {
                    this.village.func_82692_h();
                }
            } else {
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                if (entityplayer != null) {
                    this.village.func_82692_h();
                }
            }
        }
        super.func_70645_a(par1DamageSource);
    }

    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.field_70170_p.func_180495_p(new BlockPos(i, (j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b)) - 1, k = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == Blocks.field_150349_c && this.field_70170_p.func_175699_k(new BlockPos(i, j, k)) > 8 && super.func_70601_bi();
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public void func_70932_a_(EntityPlayer par1EntityPlayer) {
        this.buyingPlayer = par1EntityPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void func_70933_a(MerchantRecipe par1MerchantRecipe) {
        par1MerchantRecipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(WitcherySounds.ENTITY_GOBLIN_YES, this.func_70599_aP(), this.func_70647_i());
        if (par1MerchantRecipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.func_110124_au() : null;
        }
        if (par1MerchantRecipe.func_77394_a().func_77973_b() == Items.field_151166_bC) {
            this.wealth += par1MerchantRecipe.func_77394_a().func_190916_E();
        }
    }

    public void func_110297_a_(ItemStack par1ItemStack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(WitcherySounds.ENTITY_GOBLIN_YES, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return this.func_180425_c();
    }

    public MerchantRecipeList func_70934_b(EntityPlayer par1EntityPlayer) {
        if (this.buyingList == null) {
            this.addDefaultEquipmentAndRecipies();
        }
        return this.buyingList;
    }

    private float adjustProbability(float par1) {
        float f1 = par1 + this.probability;
        return f1 > 0.9f ? 0.9f - (f1 - 0.9f) : f1;
    }

    private void addDefaultEquipmentAndRecipies() {
        this.probability = this.buyingList != null ? MathHelper.func_76129_c((float)this.buyingList.size()) * 0.2f : 0.0f;
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        boolean shuffle = true;
        switch (this.getProfession()) {
            case 0: {
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_151015_O, this.field_70146_Z, this.adjustProbability(0.9f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Item.func_150898_a((Block)Blocks.field_150325_L), this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_151076_bf, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_179566_aV, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151025_P, this.field_70146_Z, this.adjustProbability(0.9f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151127_ba, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151034_e, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151106_aX, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151097_aZ, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151033_d, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151077_bg, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151032_g, this.field_70146_Z, this.adjustProbability(0.5f));
                if (!(this.field_70146_Z.nextFloat() < this.adjustProbability(0.5f))) break;
                merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(Blocks.field_150351_n, 10), new ItemStack(Items.field_151166_bC), new ItemStack(Items.field_151145_ak, 4 + this.field_70146_Z.nextInt(2), 0)));
                break;
            }
            case 1: 
            case 2: {
                shuffle = false;
                if (this.buyingList == null) {
                    merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(WitcheryIngredientItems.KOBOLDITE_DUST, 9), new ItemStack(Items.field_151074_bl, 5), new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET)));
                    break;
                }
                if (this.buyingList.size() == 1) {
                    merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(WitcheryIngredientItems.KOBOLDITE_DUST, 16), new ItemStack(Items.field_151043_k), new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, 2)));
                    break;
                }
                if (this.buyingList.size() != 2) break;
                merchantrecipelist.add((Object)new MerchantRecipe(new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, 9), new ItemStack(Items.field_151166_bC), new ItemStack(WitcheryIngredientItems.KOBOLDITE_INGOT)));
                break;
            }
            case 3: {
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_151044_h, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_151042_j, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_151043_k, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_151045_i, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151040_l, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151048_u, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151036_c, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151056_x, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151035_b, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151046_w, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151037_a, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151047_v, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151019_K, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151012_L, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151167_ab, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151175_af, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151028_Y, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151161_ac, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151030_Z, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151163_ad, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151165_aa, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151173_ae, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151029_X, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151020_U, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151023_V, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151022_W, this.field_70146_Z, this.adjustProbability(0.1f));
                break;
            }
            case 4: {
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_151044_h, this.field_70146_Z, this.adjustProbability(0.7f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_151147_al, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToSwapForAnEmerald(merchantrecipelist, Items.field_151082_bd, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151141_av, this.field_70146_Z, this.adjustProbability(0.1f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151027_R, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151021_T, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151024_Q, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, (Item)Items.field_151026_S, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151157_am, this.field_70146_Z, this.adjustProbability(0.3f));
                EntityGoblin.addItemToBuyOrSell(merchantrecipelist, Items.field_151083_be, this.field_70146_Z, this.adjustProbability(0.3f));
            }
        }
        if (merchantrecipelist.isEmpty()) {
            merchantrecipelist.add((Object)new MerchantRecipe(EntityGoblin.getItemStackToSwapForAnEmerald(Items.field_151043_k, this.field_70146_Z), Items.field_151166_bC));
        }
        if (shuffle) {
            Collections.shuffle(merchantrecipelist);
        }
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int l = 0; l < 1 && l < merchantrecipelist.size(); ++l) {
            this.buyingList.add(merchantrecipelist.get(l));
        }
    }

    public void func_70930_a(MerchantRecipeList recipes) {
    }

    public void func_70103_a(byte id) {
        switch (id) {
            case 12: {
                this.generateRandomParticles(EnumParticleTypes.HEART);
                break;
            }
            case 13: {
                this.generateRandomParticles(EnumParticleTypes.VILLAGER_ANGRY);
                break;
            }
            case 14: {
                this.generateRandomParticles(EnumParticleTypes.VILLAGER_HAPPY);
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingData) {
        livingData = super.func_180482_a(difficulty, livingData);
        int trade = this.field_70146_Z.nextInt(5);
        this.setProfession(trade);
        return livingData;
    }

    private void generateRandomParticles(EnumParticleTypes particle) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d3 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d2, d3, new int[0]);
        }
    }

    public EntityGoblin createChild(EntityAgeable ageable) {
        EntityGoblin goblin = new EntityGoblin(this.field_70170_p);
        goblin.func_180482_a(this.field_70170_p.func_175649_E(goblin.func_180425_c()), null);
        return goblin;
    }

    static {
        villagersSellingList.put(Items.field_151044_h, (Tuple<Integer, Integer>)new Tuple((Object)16, (Object)24));
        villagersSellingList.put(Items.field_151042_j, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        villagersSellingList.put(Items.field_151043_k, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        villagersSellingList.put(Items.field_151045_i, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        villagersSellingList.put(Items.field_151121_aF, (Tuple<Integer, Integer>)new Tuple((Object)24, (Object)36));
        villagersSellingList.put(Items.field_151122_aG, (Tuple<Integer, Integer>)new Tuple((Object)11, (Object)13));
        villagersSellingList.put(Items.field_151164_bB, (Tuple<Integer, Integer>)new Tuple((Object)1, (Object)1));
        villagersSellingList.put(Items.field_151079_bi, (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        villagersSellingList.put(Items.field_151061_bv, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)3));
        villagersSellingList.put(Items.field_151147_al, (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)18));
        villagersSellingList.put(Items.field_151082_bd, (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)18));
        villagersSellingList.put(Items.field_151076_bf, (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)18));
        villagersSellingList.put(Items.field_179566_aV, (Tuple<Integer, Integer>)new Tuple((Object)9, (Object)13));
        villagersSellingList.put(Items.field_151014_N, (Tuple<Integer, Integer>)new Tuple((Object)34, (Object)48));
        villagersSellingList.put(Items.field_151081_bc, (Tuple<Integer, Integer>)new Tuple((Object)30, (Object)38));
        villagersSellingList.put(Items.field_151080_bb, (Tuple<Integer, Integer>)new Tuple((Object)30, (Object)38));
        villagersSellingList.put(Items.field_151015_O, (Tuple<Integer, Integer>)new Tuple((Object)18, (Object)22));
        villagersSellingList.put(Item.func_150898_a((Block)Blocks.field_150325_L), (Tuple<Integer, Integer>)new Tuple((Object)14, (Object)22));
        villagersSellingList.put(Items.field_151078_bh, (Tuple<Integer, Integer>)new Tuple((Object)36, (Object)64));
        blacksmithSellingList.put(Items.field_151033_d, (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put((Item)Items.field_151097_aZ, (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put(Items.field_151040_l, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)11));
        blacksmithSellingList.put(Items.field_151048_u, (Tuple<Integer, Integer>)new Tuple((Object)12, (Object)14));
        blacksmithSellingList.put(Items.field_151036_c, (Tuple<Integer, Integer>)new Tuple((Object)6, (Object)8));
        blacksmithSellingList.put(Items.field_151056_x, (Tuple<Integer, Integer>)new Tuple((Object)9, (Object)12));
        blacksmithSellingList.put(Items.field_151035_b, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)9));
        blacksmithSellingList.put(Items.field_151046_w, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        blacksmithSellingList.put(Items.field_151037_a, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put(Items.field_151047_v, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put(Items.field_151019_K, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put(Items.field_151012_L, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put((Item)Items.field_151167_ab, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put((Item)Items.field_151175_af, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put((Item)Items.field_151028_Y, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)6));
        blacksmithSellingList.put((Item)Items.field_151161_ac, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)8));
        blacksmithSellingList.put((Item)Items.field_151030_Z, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)14));
        blacksmithSellingList.put((Item)Items.field_151163_ad, (Tuple<Integer, Integer>)new Tuple((Object)16, (Object)19));
        blacksmithSellingList.put((Item)Items.field_151165_aa, (Tuple<Integer, Integer>)new Tuple((Object)8, (Object)10));
        blacksmithSellingList.put((Item)Items.field_151173_ae, (Tuple<Integer, Integer>)new Tuple((Object)11, (Object)14));
        blacksmithSellingList.put((Item)Items.field_151029_X, (Tuple<Integer, Integer>)new Tuple((Object)5, (Object)7));
        blacksmithSellingList.put((Item)Items.field_151020_U, (Tuple<Integer, Integer>)new Tuple((Object)5, (Object)7));
        blacksmithSellingList.put((Item)Items.field_151023_V, (Tuple<Integer, Integer>)new Tuple((Object)11, (Object)15));
        blacksmithSellingList.put((Item)Items.field_151022_W, (Tuple<Integer, Integer>)new Tuple((Object)9, (Object)11));
        blacksmithSellingList.put(Items.field_151025_P, (Tuple<Integer, Integer>)new Tuple((Object)-4, (Object)-2));
        blacksmithSellingList.put(Items.field_151127_ba, (Tuple<Integer, Integer>)new Tuple((Object)-8, (Object)-4));
        blacksmithSellingList.put(Items.field_151034_e, (Tuple<Integer, Integer>)new Tuple((Object)-8, (Object)-4));
        blacksmithSellingList.put(Items.field_151106_aX, (Tuple<Integer, Integer>)new Tuple((Object)-10, (Object)-7));
        blacksmithSellingList.put(Item.func_150898_a((Block)Blocks.field_150359_w), (Tuple<Integer, Integer>)new Tuple((Object)-5, (Object)-3));
        blacksmithSellingList.put(Item.func_150898_a((Block)Blocks.field_150342_X), (Tuple<Integer, Integer>)new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put((Item)Items.field_151027_R, (Tuple<Integer, Integer>)new Tuple((Object)4, (Object)5));
        blacksmithSellingList.put((Item)Items.field_151021_T, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)4));
        blacksmithSellingList.put((Item)Items.field_151024_Q, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)4));
        blacksmithSellingList.put((Item)Items.field_151026_S, (Tuple<Integer, Integer>)new Tuple((Object)2, (Object)4));
        blacksmithSellingList.put(Items.field_151141_av, (Tuple<Integer, Integer>)new Tuple((Object)6, (Object)8));
        blacksmithSellingList.put(Items.field_151062_by, (Tuple<Integer, Integer>)new Tuple((Object)-4, (Object)-1));
        blacksmithSellingList.put(Items.field_151137_ax, (Tuple<Integer, Integer>)new Tuple((Object)-4, (Object)-1));
        blacksmithSellingList.put(Items.field_151111_aL, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        blacksmithSellingList.put(Items.field_151113_aN, (Tuple<Integer, Integer>)new Tuple((Object)10, (Object)12));
        blacksmithSellingList.put(Item.func_150898_a((Block)Blocks.field_150426_aN), (Tuple<Integer, Integer>)new Tuple((Object)-3, (Object)-1));
        blacksmithSellingList.put(Items.field_151157_am, (Tuple<Integer, Integer>)new Tuple((Object)-7, (Object)-5));
        blacksmithSellingList.put(Items.field_151083_be, (Tuple<Integer, Integer>)new Tuple((Object)-7, (Object)-5));
        blacksmithSellingList.put(Items.field_151077_bg, (Tuple<Integer, Integer>)new Tuple((Object)-8, (Object)-6));
        blacksmithSellingList.put(Items.field_151061_bv, (Tuple<Integer, Integer>)new Tuple((Object)7, (Object)11));
        blacksmithSellingList.put(Items.field_151032_g, (Tuple<Integer, Integer>)new Tuple((Object)-12, (Object)-8));
    }
}

