/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntityGoblinGulg;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityGoblinMog
extends EntityMob
implements IRangedAttackMob,
IHandleDeathTouch {
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntityGoblinMog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final double INVULNRABLE = 9.0;
    private static final double PERCENT_20 = 36.0;
    private static final double PERCENT_50 = 81.0;
    private static final double PERCENT_80 = 256.0;
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_6);
    long ticksSinceTeleport = 0L;
    private int attackTimer;

    public EntityGoblinMog(World world) {
        super(world);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackRangedBow((EntityMob)this, 1.0, 40, 30.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70728_aV = 35;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public int func_70658_aO() {
        return 5;
    }

    public void func_70110_aj() {
    }

    public void func_70604_c(EntityLivingBase entity) {
        if (!(entity instanceof EntityGoblinMog || entity instanceof EntityGoblin || entity instanceof EntityGoblinGulg)) {
            super.func_70604_c(entity);
        }
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int par1) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)par1);
    }

    public void ignite() {
        this.setInvulTime(150);
        this.func_70606_j(this.func_110138_aP() / 4.0f);
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_175669_a(1013, this.func_180425_c(), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(20.0f);
            }
        } else {
            super.func_70619_bc();
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70661_as().func_75500_f() && this.func_70638_az() != null && (long)this.field_70173_aa - this.ticksSinceTeleport > 300L) {
                this.ticksSinceTeleport = this.field_70173_aa;
                this.teleportToEntity((Entity)this.func_70638_az());
            }
            if (this.func_184614_ca().func_190926_b() && this.field_70146_Z.nextInt(100) == 0) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                this.func_184185_a(SoundEvents.field_187604_bf, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72960_a((Entity)this, (byte)5);
            }
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    protected void teleportToEntity(Entity par1Entity) {
        Vec3d vec3 = new Vec3d(this.field_70165_t - par1Entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e(), this.field_70161_v - par1Entity.field_70161_v).func_72432_b();
        double d0 = 16.0;
        double d2 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d3 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d4 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        this.teleportTo(d2, d3, d4);
    }

    protected void teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175667_e(pos)) {
            boolean flag2 = false;
            while (!flag2 && j > 0) {
                IBlockState block = this.field_70170_p.func_180495_p(pos.func_177977_b());
                if (block.func_185904_a().func_76230_c()) {
                    flag2 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag2) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f3 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f2, (double)f3, new int[0]);
        }
        this.field_70170_p.func_184134_a(d3, d4, d5, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f, false);
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    protected int func_70682_h(int par1) {
        return par1;
    }

    protected void func_82167_n(Entity par1Entity) {
        super.func_82167_n(par1Entity);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        double distance = this.getDistanceSqToPartner();
        float scale = 1.0f;
        if (distance <= 9.0) {
            return false;
        }
        if (distance <= 36.0) {
            scale = 0.2f;
        } else if (distance <= 81.0) {
            scale = 0.5f;
        } else if (distance <= 256.0) {
            scale = 0.8f;
        }
        return super.func_70097_a(source, WitcheryUtils.capAround(damage * scale, 15.0f));
    }

    private double getDistanceSqToPartner() {
        double R = 16.0;
        AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - R, this.field_70163_u - R, this.field_70161_v - R, this.field_70165_t + R, this.field_70163_u + R, this.field_70161_v + R);
        List mogs = this.field_70170_p.func_72872_a(EntityGoblinGulg.class, bb);
        double minDistance = Double.MAX_VALUE;
        for (EntityGoblinGulg mog : mogs) {
            double distance = this.func_70068_e((Entity)mog);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
        }
        return minDistance;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setInvulTime(par1NBTTagCompound.func_74762_e("Invul"));
    }

    public boolean func_70652_k(Entity par1Entity) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(7 + this.field_70146_Z.nextInt(15)));
        if (flag) {
            par1Entity.field_70181_x += (double)0.4f;
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else if (par1 == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return WitcherySounds.ENTITY_GOBLIN_MOG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187933_hg;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    protected void func_70628_a(boolean par1, int par2) {
        this.func_70099_a(new ItemStack(WitcheryIngredientItems.KOBOLDITE_NUGGET, this.field_70146_Z.nextInt(3) + 1), 0.0f);
        ItemStack armor = null;
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                armor = new ItemStack((Item)Items.field_151029_X);
                break;
            }
            case 1: {
                armor = new ItemStack((Item)Items.field_151022_W);
                break;
            }
            case 2: {
                armor = new ItemStack((Item)Items.field_151023_V);
                break;
            }
            case 3: {
                armor = new ItemStack((Item)Items.field_151020_U);
            }
        }
        if (armor != null) {
            EnchantmentHelper.func_77504_a((Random)this.field_70170_p.field_73012_v, (ItemStack)armor, (int)30, (boolean)false);
            this.func_70099_a(armor, 0.0f);
        }
        if (this.field_70170_p.field_73012_v.nextBoolean()) {
            this.func_70099_a(new ItemStack((Item)WitcheryEquipmentItems.MOGS_QUIVER), 0.0f);
        }
    }

    protected Item func_146068_u() {
        return null;
    }

    public EntityItem func_70099_a(ItemStack stack, float distance) {
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151031_f) {
            EntityItem item = super.func_70099_a(stack, distance);
            item.func_174867_a(100);
            item.lifespan = 100;
            return item;
        }
        return super.func_70099_a(stack, distance);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        this.func_110163_bv();
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        return super.func_180482_a(difficulty, par1EntityLivingData);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_82196_d(EntityLivingBase targetEntity, float par2) {
        if (!this.func_184614_ca().func_190926_b()) {
            EntityArrow entityarrow = ((ItemArrow)Items.field_151032_g).func_185052_a(this.field_70170_p, new ItemStack(Items.field_151032_g), (EntityLivingBase)this);
            double d0 = targetEntity.field_70165_t - this.field_70165_t;
            double d1 = targetEntity.func_174813_aQ().field_72338_b + (double)(targetEntity.field_70131_O / 3.0f) - entityarrow.field_70163_u;
            double d2 = targetEntity.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            double factor = targetEntity.field_70160_al ? 2.5 : 1.5;
            entityarrow.field_70159_w *= factor;
            entityarrow.field_70181_x *= factor;
            entityarrow.field_70179_y *= factor;
            entityarrow.func_70239_b((double)(par2 * 8.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
            entityarrow.func_70240_a(0);
            this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)entityarrow);
        }
    }

    public void func_184724_a(boolean b) {
    }
}

