/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.msrandom.witchery.util.WitcheryUtils;

public abstract class EntityIllusion
extends EntityMob {
    private static final DataParameter<Optional<UUID>> VICTIM = EntityDataManager.func_187226_a(EntityIllusion.class, (DataSerializer)DataSerializers.field_187203_m);
    private EntityPlayer victimPlayer = null;

    public EntityIllusion(World world) {
        super(world);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected SoundEvent getFakeLivingSound() {
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
    }

    public int func_70627_aG() {
        return super.func_70627_aG() * 2;
    }

    public EntityLivingBase func_70638_az() {
        if (this.victimPlayer == null) {
            this.victimPlayer = WitcheryUtils.getPlayer(this.field_70170_p, this.getVictimId());
        }
        return this.victimPlayer;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VICTIM, (Object)Optional.absent());
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        UUID victimId = this.getVictimId();
        if (victimId != null) {
            tag.func_186854_a("Victim", victimId);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_186855_b("Victim")) {
            this.setVictimId(tag.func_186857_a("Victim"));
        }
    }

    public UUID getVictimId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(VICTIM)).orNull();
    }

    public void setVictimId(UUID victim) {
        this.field_70180_af.func_187227_b(VICTIM, (Object)Optional.fromNullable((Object)victim));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.field_73012_v.nextInt(15) == 0) {
                float newHealth = this.func_110143_aJ() - 1.0f;
                if ((double)newHealth <= 0.5) {
                    this.func_70106_y();
                } else {
                    this.func_70606_j(newHealth);
                }
            }
            if (this.field_70170_p.field_73012_v.nextInt(40) == 0) {
                SoundEvent sound = this.getFakeLivingSound();
                if (this.func_70638_az() instanceof EntityPlayer && sound != null && this.func_70638_az().func_70068_e((Entity)this) < 64.0) {
                    WitcheryUtils.playSoundAt((EntityPlayer)this.func_70638_az(), sound, this.func_184176_by(), 1.0f, 1.0f);
                }
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public boolean func_70652_k(Entity entity) {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return (source == DamageSource.field_76380_i || source.func_180136_u()) && super.func_70097_a(source, amount);
    }
}

