/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.ai.EntityAIWanderWithRestriction;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryContractItems;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.contracts.ItemActivatableContract;

public class EntityImp
extends EntityTameable
implements IMob {
    private static final DataParameter<Integer> AFFECTION = EntityDataManager.func_187226_a(EntityImp.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityImp.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final HashMap<Item, Integer> shinies = new HashMap();
    private static final int REWARD_AFFECTION_LEVEL = 20;
    private static final long GIFT_DELAY_TICKS = 3600L;
    private static final ItemStack[] EXTRA_DROPS = new ItemStack[]{new ItemStack(WitcheryIngredientItems.BAT_WOOL, 5), new ItemStack(WitcheryIngredientItems.DOG_TONGUE, 5), new ItemStack(WitcheryIngredientItems.FROG_TOE, 2), new ItemStack(WitcheryIngredientItems.OWLETS_WING, 2), new ItemStack(WitcheryIngredientItems.ENT_TWIG, 1), new ItemStack(WitcheryFumeItems.DEMONIC_BLOOD, 2), new ItemStack(WitcheryIngredientItems.CREEPER_HEART, 2)};
    private static final String[] DEMON_NAMES = new String[]{"Ppaironael", "Aethon", "Tyrnak", "Beelzebuth", "Botis", "Moloch", "Taet", "Epnanaet", "Unonom", "Hexpemsazon", "Thayax", "Ethahoat", "Pruslas", "Ahtuxies", "Laripael", "Elxar", "Tarihimal", "Sapanolr", "Sahaminapiel", "Honed", "Oghmus", "Zedeson", "Halmaneop", "Nopoz", "Ekarnahox", "Sacuhatakael", "Ticos", "Arametheus", "Azmodaeus", "Larhepeis", "Topriraiz", "Rarahaimzah", "Tedrahamael", "Osaselael", "Phlegon", "Nelokhiel", "Haristum", "Zul", "Larhepeis", "Aamon", "Tramater", "Ehhbes", "Kra`an", "Quarax", "Hotesiatrem", "Surgat", "Nu`uhn", "Litedabh", "Unonom", "Bolenoz", "Hilopael", "Haristum", "Uhn", "Hiepacth", "Pemcapso", "Ankou", "Pundohien", "Koit", "Montobulus", "Amsaset", "Aropet", "Isnal", "Solael", "Exroh", "Sidragrosam", "Pnecamob", "Malashim", "Beelzebuth", "Ehohit", "Izatap", "Olon", "Assoaz", "Agalierept", "Krakus", "Umlaboor", "Aknrar", "Damaz", "Rhysus", "Pundohien", "Ba`al", "Rasuniolpas", "Anhoor", "Nyarlathotep", "Krakus", "Larhepeis", "Itakup", "Erdok", "Umlaboor", "Ezon", "Krakus", "Glassyalabolas", "Kra`an", "Ehnnat", "Terxor", "Asramel", "Tadal", "Arpzih", "Azmodaeus", "Henbolaron", "Rhysus"};
    private int secretsShared;
    private BlockPos home;
    private long lastGiftTime;
    private long powerUpExpiry;

    public EntityImp(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderWithRestriction(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, target -> !this.func_70909_n() ? target instanceof EntityPlayer : target == this.func_70638_az()));
        this.func_70903_f(false);
        this.home = BlockPos.field_177992_a;
    }

    private static String getDemonName(Random rand) {
        if (rand.nextInt(5) == 0) {
            return DEMON_NAMES[rand.nextInt(DEMON_NAMES.length)];
        }
        return DEMON_NAMES[rand.nextInt(DEMON_NAMES.length)] + " " + DEMON_NAMES[rand.nextInt(DEMON_NAMES.length)];
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AFFECTION, (Object)0);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    private int getAffection() {
        return (Integer)this.field_70180_af.func_187225_a(AFFECTION);
    }

    private void setAffection(int affection) {
        this.field_70180_af.func_187227_b(AFFECTION, (Object)affection);
    }

    public boolean isPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    private void setPowered(boolean powered) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(POWERED, (Object)powered);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Affection", this.getAffection());
        compound.func_74768_a("SecretsShared", this.secretsShared);
        compound.func_74772_a("LastGiftTime", this.lastGiftTime);
        compound.func_74772_a("PowerUpUntil2", this.powerUpExpiry);
        compound.func_74768_a("HomeLocX", this.home.func_177958_n());
        compound.func_74768_a("HomeLocY", this.home.func_177956_o());
        compound.func_74768_a("HomeLocZ", this.home.func_177952_p());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAffection(compound.func_74762_e("Affection"));
        this.secretsShared = compound.func_74762_e("SecretsShared");
        this.lastGiftTime = compound.func_74763_f("LastGiftTime");
        long time = MinecraftServer.func_130071_aq() / 50L;
        if (compound.func_74764_b("PowerUpUntil2")) {
            this.powerUpExpiry = compound.func_74763_f("PowerUpUntil2");
        } else if (compound.func_74764_b("PowerUpUntil")) {
            this.powerUpExpiry = compound.func_74763_f("PowerUpUntil");
            if (this.powerUpExpiry > 0L) {
                this.powerUpExpiry = time + 72000L;
            }
        }
        if (time < this.powerUpExpiry) {
            this.setPowered(true);
        }
        this.home = new BlockPos(compound.func_74762_e("HomeLocX"), compound.func_74762_e("HomeLocY"), compound.func_74762_e("HomeLocZ"));
    }

    protected SoundEvent func_184639_G() {
        return WitcherySounds.ENTITY_IMP_LAUGH;
    }

    protected float func_70647_i() {
        return this.isPowered() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.7f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.1f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_IMP_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_IMP_DEATH;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    public int func_70627_aG() {
        return 800;
    }

    public void func_70636_d() {
        super.func_70636_d();
        EntityLivingBase owner = this.func_70902_q();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 600 == 0 && owner != null && owner instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)owner;
            this.setAffection(Math.max(0, this.getAffection() - 1));
            if (this.getAffection() == 0 && this.field_70173_aa > 72000 && this.field_70170_p.field_73012_v.nextDouble() < 0.01) {
                this.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, 1.0f, 1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.goodbye", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                this.func_70106_y();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.powerUpExpiry > 0L && this.isPowerupExpired()) {
            this.setPowered(false);
            this.powerUpExpiry = 0L;
        }
        if (this.field_70173_aa % 20 == 0) {
            if (this.isPowered()) {
                if ((double)this.field_70130_N != 0.6) {
                    this.func_70105_a(0.6f, 1.3f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70691_i(1.0f);
                }
            } else if ((double)this.field_70130_N != 0.4) {
                this.func_70105_a(0.4f, 1.3f);
            }
        }
        if (this.field_70173_aa % 400 == 0) {
            this.func_70691_i(1.0f);
        }
    }

    private boolean isPowerupExpired() {
        return MinecraftServer.func_130071_aq() / 50L >= this.powerUpExpiry;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.isPowered()) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t - (double)this.field_70130_N * 0.5 + this.field_70170_p.field_73012_v.nextDouble() * (double)this.field_70130_N, 0.1 + this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() * 2.0, this.field_70161_v - (double)this.field_70130_N * 0.5 + this.field_70170_p.field_73012_v.nextDouble() * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, this.isPowered() ? 5.0f : 15.0f));
    }

    public boolean func_70652_k(Entity par1Entity) {
        return par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.isPowered() ? 8.0f : 4.0f);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return true;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.func_70909_n()) {
            if (stack.func_77973_b() == Item.func_150898_a((Block)WitcheryBlocks.DEMON_HEART)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.powerUpExpiry = MinecraftServer.func_130071_aq() / 50L + 72000L;
                    this.setPowered(true);
                    this.field_70170_p.func_184133_a(null, player.func_180425_c(), WitcherySounds.ENTITY_IMP_LAUGH, this.func_184176_by(), 0.5f, this.func_70647_i());
                    player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.gift.overwhelming_power", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                }
            } else if (stack.func_77973_b() == WitcheryIngredientItems.ICY_NEEDLE) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.powerUpExpiry = 0L;
                    this.setPowered(false);
                    this.field_70170_p.func_184133_a(null, player.func_180425_c(), WitcherySounds.ENTITY_IMP_LAUGH, this.func_184176_by(), 0.5f, this.func_70647_i());
                    player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.gift.gift.weakened", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                }
            } else {
                if (!ItemActivatableContract.isBoundContract(stack)) {
                    if (!this.field_70170_p.field_72995_K) {
                        Integer affectionBoost = shinies.get(stack.func_77973_b());
                        if (affectionBoost != null && stack.func_77952_i() == 0) {
                            long timeNow = MinecraftServer.func_130071_aq() / 50L;
                            if (!player.field_71075_bZ.field_75098_d) {
                                stack.func_190918_g(1);
                            }
                            int affection = this.getAffection() + affectionBoost;
                            this.field_70170_p.func_184133_a(null, player.func_180425_c(), WitcherySounds.ENTITY_IMP_LAUGH, this.func_184176_by(), 0.5f, this.func_70647_i());
                            if (affection >= 20 && (timeNow > this.lastGiftTime + 3600L || player.field_71075_bZ.field_75098_d) && this.field_70146_Z.nextInt(Math.max(1, 10 - Math.max(affection - 20, 0))) == 0) {
                                ItemStack stackForPlayer;
                                this.lastGiftTime = timeNow;
                                affection = 0;
                                player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.gift.reciprocate", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                                switch (this.secretsShared) {
                                    case 0: {
                                        stackForPlayer = new ItemStack((Item)WitcheryBrewItems.SOUL_HUNGER_BREW);
                                        ++this.secretsShared;
                                        break;
                                    }
                                    case 1: {
                                        stackForPlayer = new ItemStack((Item)WitcheryBrewItems.SOUL_FEAR_BREW);
                                        ++this.secretsShared;
                                        break;
                                    }
                                    case 2: {
                                        stackForPlayer = new ItemStack((Item)WitcheryBrewItems.SOUL_ANGUISH_BREW);
                                        ++this.secretsShared;
                                        break;
                                    }
                                    case 3: {
                                        stackForPlayer = new ItemStack((Item)WitcheryContractItems.TORMENT_CONTRACT);
                                        ++this.secretsShared;
                                        break;
                                    }
                                    default: {
                                        stackForPlayer = EXTRA_DROPS[this.field_70146_Z.nextInt(EXTRA_DROPS.length)].func_77946_l();
                                    }
                                }
                                if (stackForPlayer != null) {
                                    this.func_184185_a(SoundEvents.field_187682_dG, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                                    this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stackForPlayer));
                                }
                            } else if (timeNow < this.lastGiftTime + 3600L) {
                                player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.gift.too_many", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                            } else {
                                player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.gift.like", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                            }
                            this.setAffection(affection);
                        } else {
                            this.field_70170_p.func_184133_a(null, player.func_180425_c(), WitcherySounds.ENTITY_IMP_LAUGH, this.func_184176_by(), 0.5f, this.func_70647_i());
                            player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.gift.hate", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                        }
                    }
                    return true;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184133_a(null, player.func_180425_c(), WitcherySounds.ENTITY_IMP_LAUGH, this.func_184176_by(), 0.5f, this.func_70647_i());
                    if (!this.isPowered()) {
                        if (this.getAffection() >= 20) {
                            long timeNow2 = MinecraftServer.func_130071_aq() / 50L;
                            if (timeNow2 > this.lastGiftTime + 3600L || player.field_71075_bZ.field_75098_d) {
                                ItemActivatableContract contract = ItemActivatableContract.getContract(stack);
                                EntityLivingBase targetEntity = ItemTaglockKit.getBoundEntity(this.field_70170_p, stack, 0);
                                if (contract != null && targetEntity != null) {
                                    if (contract.activate(targetEntity)) {
                                        this.lastGiftTime = timeNow2;
                                        player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.spell.feel_the_flames", new Object[]{this.func_70005_c_(), targetEntity.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            stack.func_190918_g(1);
                                        }
                                    } else {
                                        player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.spell.failed", new Object[]{this.func_70005_c_(), targetEntity.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                                    }
                                } else {
                                    ITextComponent name2 = ItemTaglockKit.getBoundEntityName(stack, 0);
                                    player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.spell.cannot_find_entity", new Object[]{this.func_70005_c_(), name2}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                                }
                            } else {
                                player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.spell.cooldown", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                            }
                        } else {
                            player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.spell.dislike", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                        }
                    } else {
                        player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.spell.too_much_power", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                    }
                }
            }
        } else if (stack.func_77973_b() == WitcheryContractItems.DEMONIC_CONTRACT) {
            if (!this.field_70170_p.field_72995_K) {
                EntityLivingBase boundEntity = ItemActivatableContract.getBoundEntity(this.field_70170_p, stack);
                if (boundEntity == player) {
                    int EXPERIENCE_NEEDED = 25;
                    if (player.field_71068_ca >= EXPERIENCE_NEEDED || player.field_71075_bZ.field_75098_d) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                        player.func_82242_a(-EXPERIENCE_NEEDED);
                        this.func_70903_f(true);
                        this.func_184754_b(player.func_110124_au());
                        this.func_70624_b(null);
                        this.func_70661_as().func_75499_g();
                        this.home = this.func_180425_c();
                        this.func_110163_bv();
                        this.field_70170_p.func_184133_a(null, player.func_180425_c(), WitcherySounds.ENTITY_IMP_LAUGH, this.func_184176_by(), 0.5f, this.func_70647_i());
                        player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.contract.deal", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                        this.func_96094_a(EntityImp.getDemonName(this.field_70146_Z));
                    } else {
                        this.field_70170_p.func_184133_a(null, player.func_180425_c(), WitcherySounds.ENTITY_IMP_LAUGH, this.func_184176_by(), 0.5f, this.func_70647_i());
                        player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.contract.little_experience", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                    }
                } else if (boundEntity != null) {
                    this.field_70170_p.func_184133_a(null, player.func_180425_c(), WitcherySounds.ENTITY_IMP_LAUGH, this.func_184176_by(), 0.5f, this.func_70647_i());
                    player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.contract.wrong_blood_signature", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                } else {
                    this.field_70170_p.func_184133_a(null, player.func_180425_c(), WitcherySounds.ENTITY_IMP_LAUGH, this.func_184176_by(), 0.5f, this.func_70647_i());
                    player.func_145747_a(new TextComponentTranslation("entity.witchery.imp.contract.not_signed", new Object[]{this.func_70005_c_()}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public EntityImp createChild(EntityAgeable par1EntityAgeable) {
        return null;
    }

    public boolean func_70878_b(EntityAnimal par1EntityAnimal) {
        return false;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public BlockPos getHomePos() {
        return this.home;
    }

    static {
        shinies.put(new ItemStack(Items.field_151045_i).func_77973_b(), 8);
        shinies.put(new ItemStack(Items.field_151056_x).func_77973_b(), 24);
        shinies.put(new ItemStack(Items.field_151012_L).func_77973_b(), 16);
        shinies.put(new ItemStack(Items.field_151048_u).func_77973_b(), 16);
        shinies.put(new ItemStack(Items.field_151047_v).func_77973_b(), 8);
        shinies.put(new ItemStack(Items.field_151046_w).func_77973_b(), 24);
        shinies.put(new ItemStack(Items.field_151166_bC).func_77973_b(), 3);
        shinies.put(new ItemStack(Items.field_151043_k).func_77973_b(), 1);
        shinies.put(new ItemStack(Items.field_151156_bN).func_77973_b(), 16);
        shinies.put(new ItemStack(Items.field_151072_bj).func_77973_b(), 1);
        shinies.put(new ItemStack(Items.field_151073_bk).func_77973_b(), 4);
        shinies.put(new ItemStack(Items.field_151006_E).func_77973_b(), 3);
        shinies.put(new ItemStack(Items.field_151010_B).func_77973_b(), 2);
        shinies.put(new ItemStack(Items.field_151013_M).func_77973_b(), 2);
        shinies.put(new ItemStack(Items.field_151011_C).func_77973_b(), 1);
        shinies.put(new ItemStack(Items.field_151005_D).func_77973_b(), 3);
        shinies.put(new ItemStack(Blocks.field_150340_R).func_77973_b(), 9);
        shinies.put(new ItemStack(Blocks.field_150475_bE).func_77973_b(), 27);
        shinies.put(new ItemStack(Blocks.field_150484_ah).func_77973_b(), 72);
        shinies.put(new ItemStack(Blocks.field_150368_y).func_77973_b(), 7);
        shinies.put(new ItemStack(Blocks.field_150451_bX).func_77973_b(), 5);
    }
}

