/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.collections.CollectionsKt;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.msrandom.witchery.WitcheryResurrectedClient;
import net.msrandom.witchery.entity.EntityLostSoul;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.symbol.ConfudusSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ExpelliarmusSymbolEffect;
import net.msrandom.witchery.infusion.symbol.FlipendoSymbolEffect;
import net.msrandom.witchery.infusion.symbol.IgnianimaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ImpedimentaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcherySymbolEffects;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.BlockActionSphere;
import net.msrandom.witchery.util.ElementWeight;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WeightedElement;
import net.msrandom.witchery.util.WeightedElementKt;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityLeonard
extends EntityMob
implements IRangedAttackMob,
IHandleDeathTouch {
    public static final List<WeightedElement<ProjectileSymbolEffect>> SPELLS = WeightedElementKt.toWeightedList(CollectionsKt.listOf(new ElementWeight<IgnianimaSymbolEffect>(14, WitcherySymbolEffects.IGNIANIMA), new ElementWeight<ExpelliarmusSymbolEffect>(2, WitcherySymbolEffects.EXPELLIARMUS), new ElementWeight<FlipendoSymbolEffect>(2, WitcherySymbolEffects.FLIPENDO), new ElementWeight<ImpedimentaSymbolEffect>(2, WitcherySymbolEffects.IMPEDIMENTA), new ElementWeight<ConfudusSymbolEffect>(2, WitcherySymbolEffects.CONFUNDUS)));
    private static final DataParameter<Boolean> PLAYER_CREATED = EntityDataManager.func_187226_a(EntityLeonard.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> INVULNERABLE = EntityDataManager.func_187226_a(EntityLeonard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LIFE_TIME = EntityDataManager.func_187226_a(EntityLeonard.class, (DataSerializer)DataSerializers.field_187192_b);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.NOTCHED_12).func_186741_a(true);
    private int attackTimer;
    private boolean isImmune;
    private int spawnDelay;

    public EntityLeonard(World world) {
        super(world);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 20, 30.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70728_aV = 100;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_CREATED, (Object)false);
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)0);
        this.field_70180_af.func_187214_a(LIFE_TIME, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(600.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public int func_70658_aO() {
        return 0;
    }

    public void func_70110_aj() {
    }

    public int getInvulnerableStartTicks() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABLE);
    }

    public void setInvulnerableStartTicks(int par1) {
        this.field_70180_af.func_187227_b(INVULNERABLE, (Object)par1);
    }

    public int getLifetime() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE_TIME);
    }

    public void setLifetime(int par1) {
        this.field_70180_af.func_187227_b(LIFE_TIME, (Object)par1);
    }

    public void setInvulnerableStart() {
        this.setInvulnerableStartTicks(150);
        this.func_70606_j(this.func_110138_aP() / 4.0f);
    }

    protected void func_70619_bc() {
        if (this.getInvulnerableStartTicks() > 0) {
            int i = this.getInvulnerableStartTicks() - 1;
            if (i <= 0) {
                this.field_70170_p.func_175669_a(1013, this.func_180425_c(), 0);
            }
            this.setInvulnerableStartTicks(i);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(this.func_110138_aP() * 0.75f / 15.0f);
            }
        } else {
            super.func_70619_bc();
            this.setLifetime(this.getLifetime() + 1);
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.field_70173_aa % 20 == 0 && this.field_70170_p.field_73012_v.nextInt(5) == 0 && !this.field_70170_p.field_72995_K) {
                EntityPlayer player2;
                int R = 40;
                double RY = 40.0;
                double RSQ = 1600.0;
                AxisAlignedBB bounds = new AxisAlignedBB(this.field_70165_t - (double)R, this.field_70163_u - RY, this.field_70161_v - (double)R, this.field_70165_t + (double)R, this.field_70163_u + RY, this.field_70161_v + (double)R);
                List players = this.field_70170_p.func_72872_a(EntityPlayer.class, bounds);
                boolean hexed = false;
                for (EntityPlayer player : players) {
                    if (!(this.func_70092_e(player.field_70165_t, this.field_70163_u, player.field_70161_v) <= RSQ) || player.field_70128_L || !(player.func_110143_aJ() > 0.0f) || player.func_70644_a(WitcheryPotionEffects.MORTAL_COIL)) continue;
                    hexed = true;
                    player.func_184185_a(SoundEvents.field_187646_bt, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                    player.func_70690_d(new PotionEffect(WitcheryPotionEffects.MORTAL_COIL, 1800));
                }
                if (hexed) {
                    this.func_184185_a(SoundEvents.field_187682_dG, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                } else if (this.field_70170_p.field_73012_v.nextInt(5) == 1 && players.size() > 0 && (player2 = (EntityPlayer)players.get(this.field_70170_p.field_73012_v.nextInt(players.size()))) != null && this.func_70092_e(player2.field_70165_t, this.field_70163_u, player2.field_70161_v) <= 1600.0 && !player2.field_70128_L && player2.func_110143_aJ() > 0.0f) {
                    player2.func_184185_a(SoundEvents.field_187646_bt, 0.5f, 0.4f / (player2.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                    switch (this.field_70170_p.field_73012_v.nextInt(10)) {
                        case 0: 
                        case 1: 
                        case 2: {
                            ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
                            Collection effects2 = player2.func_70651_bq();
                            for (PotionEffect effect : effects2) {
                                Potion potion = effect.func_188419_a();
                                if (WitcheryPotion.isDebuff(potion) || !WitcheryPotion.isCurable(potion)) continue;
                                effectsToRemove.add(potion);
                            }
                            for (Potion potion2 : effectsToRemove) {
                                player2.func_184589_d(potion2);
                            }
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            player2.func_70690_d(new PotionEffect(WitcheryPotionEffects.SINKING, 1200, 3));
                            this.func_184185_a(SoundEvents.field_187682_dG, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            player2.func_70690_d(new PotionEffect(WitcheryPotionEffects.INSANITY, 1200, 3));
                            this.func_184185_a(SoundEvents.field_187682_dG, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                            break;
                        }
                        case 9: {
                            player2.func_70690_d(new PotionEffect(WitcheryPotionEffects.OVERHEATING, 1200, 3));
                            this.func_184185_a(SoundEvents.field_187682_dG, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                }
            }
            if (this.field_70173_aa % 20 == 2) {
                if (this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                    new BlockActionSphere(){

                        @Override
                        protected void onBlock(World world, BlockPos pos) {
                            Block block = world.func_180495_p(pos).func_177230_c();
                            if (block == WitcheryBlocks.BREW_GAS || block == WitcheryBlocks.BREW_LIQUID) {
                                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                            }
                        }
                    }.drawFilledSphere(this.field_70170_p, this.func_180425_c().func_177981_b(2), 4);
                }
                if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5) {
                    if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.25 && this.field_70170_p.field_73012_v.nextInt(3) == 1 && !this.func_70644_a(WitcheryPotionEffects.RESIZING)) {
                        this.func_70690_d(new PotionEffect(WitcheryPotionEffects.RESIZING, 1200, 3));
                    }
                    int SPAWN_DELAY = 10;
                    int R = 15;
                    double RY = 5.0;
                    double RSQ = 225.0;
                    AxisAlignedBB bounds2 = new AxisAlignedBB(this.field_70165_t - (double)R, this.field_70163_u - RY, this.field_70161_v - (double)R, this.field_70165_t + (double)R, this.field_70163_u + RY, this.field_70161_v + (double)R);
                    List souls = this.field_70170_p.func_72872_a(EntityLostSoul.class, bounds2);
                    if (souls.size() == 0) {
                        this.isImmune = false;
                        if (--this.spawnDelay <= 0) {
                            EntityLostSoul soul;
                            int j;
                            this.removeCoilEffects(15, RY);
                            this.spawnDelay = SPAWN_DELAY;
                            int spawned = 0;
                            for (j = 0; j < 4 + this.field_70170_p.field_73012_v.nextInt(2); ++j) {
                                soul = Infusion.spawnCreature(this.field_70170_p, EntityLostSoul.class, this.func_180425_c().func_177984_a(), null, 1, 4, EnumParticleTypes.SMOKE_NORMAL, SoundEvents.field_187638_cR);
                                if (soul == null) continue;
                                soul.setLifetime(60 + this.field_70170_p.field_73012_v.nextInt(30) * 20);
                                ++spawned;
                            }
                            for (j = spawned; j < 3; ++j) {
                                soul = Infusion.spawnCreature(this.field_70170_p, EntityLostSoul.class, this.func_180425_c().func_177984_a(), null, 0, 0, EnumParticleTypes.SMOKE_NORMAL, SoundEvents.field_187638_cR);
                                if (soul == null) continue;
                                soul.setLifetime((60 + this.field_70170_p.field_73012_v.nextInt(30)) * 20);
                            }
                        }
                    } else {
                        this.isImmune = true;
                    }
                } else {
                    this.isImmune = false;
                }
            }
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.removeCoilEffects(40, 40.0);
    }

    private void removeCoilEffects(int R, double RY) {
        AxisAlignedBB bounds2 = new AxisAlignedBB(this.field_70165_t - (double)R, this.field_70163_u - RY, this.field_70161_v - (double)R, this.field_70165_t + (double)R, this.field_70163_u + RY, this.field_70161_v + (double)R);
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, bounds2);
        for (EntityPlayer player : players) {
            if (player.field_70128_L || !(player.func_110143_aJ() > 0.0f) || !player.func_70644_a(WitcheryPotionEffects.MORTAL_COIL)) continue;
            player.func_184589_d(WitcheryPotionEffects.MORTAL_COIL);
            WitcheryUtils.getExtension(player).clearCachedIncurablePotionEffect(WitcheryPotionEffects.MORTAL_COIL);
        }
    }

    protected int func_70682_h(int par1) {
        return par1;
    }

    protected void func_82167_n(Entity par1Entity) {
        super.func_82167_n(par1Entity);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.isImmune) {
            return false;
        }
        if (!source.func_76355_l().equals("player")) {
            return false;
        }
        if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.25) {
            boolean isLarge = this.func_70644_a(WitcheryPotionEffects.RESIZING) && this.func_70660_b(WitcheryPotionEffects.RESIZING).func_76458_c() >= 2;
            return super.func_70097_a(source, WitcheryUtils.capAround(damage, isLarge ? 1.0f : 4.0f));
        }
        return super.func_70097_a(source, WitcheryUtils.capAround(damage, 12.0f));
    }

    @Override
    public float getCapDT(DamageSource source) {
        return this.isImmune || !source.func_76355_l().equals("player") ? 0.0f : 2.0f;
    }

    public void attackEntityFromWeakness(int damage) {
        if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.4) {
            boolean isLarge = this.func_70644_a(WitcheryPotionEffects.RESIZING) && this.func_70660_b(WitcheryPotionEffects.RESIZING).func_76458_c() >= 2;
            super.func_70097_a(DamageSource.field_76376_m, Math.min((float)damage, isLarge ? 8.0f : 15.0f));
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("PlayerCreated", this.isPlayerCreated());
        par1NBTTagCompound.func_74768_a("Invul", this.getInvulnerableStartTicks());
        par1NBTTagCompound.func_74772_a("Lifetime", (long)this.getLifetime());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setPlayerCreated(par1NBTTagCompound.func_74767_n("PlayerCreated"));
        this.setInvulnerableStartTicks(par1NBTTagCompound.func_74762_e("Invul"));
        this.setLifetime(par1NBTTagCompound.func_74762_e("Lifetime"));
    }

    public boolean func_70652_k(Entity par1Entity) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(7 + this.field_70146_Z.nextInt(15)));
        if (flag) {
            par1Entity.field_70181_x += (double)0.4f;
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    public void func_70103_a(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else if (par1 == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (par1 == 6) {
            for (int i = 0; i < 20; ++i) {
                WitcheryResurrectedClient.INSTANCE.addColoredSmokeParticle(this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, 0xFFFFFF);
            }
        } else {
            super.func_70103_a(par1);
        }
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return WitcherySounds.ENTITY_LEONARD_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_LEONARD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_LEONARD_DEATH;
    }

    protected void func_70628_a(boolean par1, int par2) {
        Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_186801_a(this.field_70146_Z);
        int k = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)Math.min(enchantment.func_77319_d() + 2, enchantment.func_77325_b()), (int)enchantment.func_77325_b());
        ItemStack itemstack = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, k));
        this.func_70099_a(itemstack, 0.0f);
        this.func_70099_a(new ItemStack((Block)WitcheryBlocks.DEMON_HEART), 0.0f);
        this.func_70099_a(new ItemStack((Item)WitcheryGeneralItems.LEONARDS_URNS.get(0)), 0.0f);
    }

    protected Item func_146068_u() {
        return null;
    }

    public boolean isPlayerCreated() {
        return (Boolean)this.field_70180_af.func_187225_a(PLAYER_CREATED);
    }

    public void setPlayerCreated(boolean par1) {
        this.func_110163_bv();
        this.field_70180_af.func_187227_b(PLAYER_CREATED, (Object)par1);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_82196_d(EntityLivingBase targetEntity, float par2) {
        if (this.field_70170_p.field_73012_v.nextBoolean()) {
            this.attackTimer = 10;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            double d0 = targetEntity.field_70165_t - this.field_70165_t;
            double d2 = targetEntity.func_174813_aQ().field_72338_b + (double)(targetEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d3 = targetEntity.field_70161_v - this.field_70161_v;
            float f1 = MathHelper.func_76129_c((float)par2) * 0.5f;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175718_b(1009, this.func_180425_c(), 0);
                EntitySpellEffect effect = new EntitySpellEffect(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d2, d3 + this.field_70146_Z.nextGaussian() * (double)f1, WeightedElementKt.getWeighted(SPELLS, this.field_70146_Z), 1);
                effect.field_70165_t = this.field_70165_t;
                effect.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f);
                effect.field_70161_v = this.field_70161_v;
                this.field_70170_p.func_72838_d((Entity)effect);
            }
        }
    }

    public void func_184724_a(boolean b) {
    }
}

