/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityFlyingMob;
import net.msrandom.witchery.entity.EntitySoulfire;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.entity.ai.EntityAIFlyerArrowAttack;
import net.msrandom.witchery.entity.ai.EntityAIFlyerLand;
import net.msrandom.witchery.entity.ai.EntityAIFlyerWander;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcherySymbolEffects;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.util.damage.DemonicDamageSource;
import net.msrandom.witchery.world.dimension.torment.TormentWorldData;
import net.msrandom.witchery.world.dimension.torment.WorldProviderTorment;

public class EntityLordOfTorment
extends EntityFlyingMob
implements IRangedAttackMob,
IHandleDeathTouch {
    private final Set<UUID> attackers = new HashSet<UUID>();
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_10).func_186741_a(true);
    private int attackTimer;

    public EntityLordOfTorment(World world) {
        super(world);
        this.field_70178_ae = true;
        this.field_70728_aV = 50;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70728_aV = 80;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFlyerArrowAttack(this, 1.0, 20, 60, 12.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 10.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t - (double)this.field_70130_N * 0.5 + this.field_70170_p.field_73012_v.nextDouble() * (double)this.field_70130_N, 0.1 + this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() * 2.0, this.field_70161_v - (double)this.field_70130_N * 0.5 + this.field_70170_p.field_73012_v.nextDouble() * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70170_p.field_73012_v.nextDouble() < 0.05 && this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75100_b && !this.func_70638_az().func_70644_a(MobEffects.field_76421_d)) {
            this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 5));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte state) {
        if (state == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(state);
        }
    }

    public boolean func_70652_k(Entity target) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(7 + this.field_70146_Z.nextInt(15)));
        if (flag) {
            target.field_70181_x += (double)0.4f;
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public void func_70020_e(NBTTagCompound nbtRoot) {
        super.func_70020_e(nbtRoot);
        if (nbtRoot.func_74764_b("Attackers")) {
            NBTTagList nbtAttackers = nbtRoot.func_150295_c("Attackers", 8);
            for (int i = 0; i < nbtAttackers.func_74745_c(); ++i) {
                String attacker = nbtAttackers.func_150307_f(i);
                this.attackers.add(UUID.fromString(attacker));
            }
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound nbtRoot) {
        super.func_189511_e(nbtRoot);
        NBTTagList nbtAttackers = new NBTTagList();
        for (UUID attacker : this.attackers) {
            nbtAttackers.func_74742_a((NBTBase)new NBTTagString(attacker.toString()));
        }
        nbtRoot.func_74782_a("Attackers", (NBTBase)nbtAttackers);
        return nbtRoot;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_94541_c()) {
            return false;
        }
        if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer attacker = (EntityPlayer)source.func_76364_f();
            this.attackers.add(attacker.func_110124_au());
        }
        float damageCap = source instanceof DemonicDamageSource ? 8.0f : 5.0f;
        boolean damaged = super.func_70097_a(source, WitcheryUtils.capAround(damage, damageCap));
        if (!WitcheryDimensions.TORMENT.isInDimension((Entity)this) && this.func_110143_aJ() <= this.func_110138_aP() * 0.5f) {
            if (!this.field_70170_p.field_72995_K) {
                int tormentlevel = WorldProviderTorment.getRandomTormentLevel(this.field_70170_p);
                double R = 16.0;
                double Ry = 32.0;
                AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - R, this.field_70163_u - Ry, this.field_70161_v - R, this.field_70165_t + R, this.field_70163_u + Ry, this.field_70161_v + R);
                List players = this.field_70170_p.func_72872_a(EntityPlayer.class, bb);
                for (EntityPlayer otherPlayer : players) {
                    WorldProviderTorment.setPlayerMustTorment(otherPlayer, TormentWorldData.TormentType.BOSS, tormentlevel);
                }
                for (UUID player : this.attackers) {
                    EntityPlayer otherPlayer = WitcheryUtils.getPlayer(this.field_70170_p, player);
                    if (otherPlayer == null || otherPlayer.field_71093_bK != this.field_71093_bK) continue;
                    WorldProviderTorment.setPlayerMustTorment(otherPlayer, TormentWorldData.TormentType.BOSS, tormentlevel);
                }
                this.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                this.func_70106_y();
            }
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        return damaged;
    }

    @Override
    public float getCapDT(DamageSource source) {
        return 5.0f;
    }

    protected SoundEvent func_184639_G() {
        return WitcherySounds.ENTITY_TORMENT_LAUGH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_TORMENT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_TORMENT_DEATH;
    }

    public int func_70627_aG() {
        return 200;
    }

    protected Item func_146068_u() {
        return Items.field_190931_a;
    }

    protected void func_70628_a(boolean par1, int par2) {
        Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_186801_a(this.field_70146_Z);
        int k = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)Math.min(enchantment.func_77319_d() + 3, enchantment.func_77325_b()), (int)enchantment.func_77325_b());
        ItemStack itemstack = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, k));
        this.func_70099_a(itemstack, 0.0f);
        Enchantment enchantment2 = (Enchantment)Enchantment.field_185264_b.func_186801_a(this.field_70146_Z);
        int k2 = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)Math.min(enchantment2.func_77319_d() + 1, enchantment.func_77325_b()), (int)enchantment.func_77325_b());
        ItemStack itemstack2 = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment2, k2));
        this.func_70099_a(itemstack2, 0.0f);
        this.func_70099_a(new ItemStack((Block)WitcheryBlocks.DEMON_HEART), 0.0f);
        this.func_70099_a(new ItemStack((Item)WitcheryBrewItems.SOUL_TORMENT_BREW), 0.0f);
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
    }

    public void func_82196_d(EntityLivingBase targetEntity, float par2) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        double d0 = targetEntity.field_70165_t - this.field_70165_t;
        double d2 = targetEntity.func_174813_aQ().field_72338_b + (double)(targetEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d3 = targetEntity.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76129_c((float)par2) * 0.5f;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175718_b(1009, this.func_180425_c(), 0);
            int count = this.field_70146_Z.nextInt(10) == 0 ? 9 : 3;
            EntitySpellEffect effect = new EntitySpellEffect(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d2, d3 + this.field_70146_Z.nextGaussian() * (double)f1, WitcherySymbolEffects.IGNIANIMA, 1);
            effect.field_70165_t = this.field_70165_t;
            effect.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f);
            effect.field_70161_v = this.field_70161_v;
            this.field_70170_p.func_72838_d((Entity)effect);
            for (int i = 0; i < count; ++i) {
                EntitySoulfire fireballEntity = new EntitySoulfire(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d2, d3 + this.field_70146_Z.nextGaussian() * (double)f1);
                fireballEntity.field_70165_t = this.field_70165_t;
                fireballEntity.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
                fireballEntity.field_70161_v = this.field_70161_v;
                this.field_70170_p.func_72838_d((Entity)fireballEntity);
            }
        }
    }

    public void func_184724_a(boolean b) {
    }
}

