/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrectedClient;
import net.msrandom.witchery.entity.ColoredSpiritEntity;
import net.msrandom.witchery.entity.ai.EntityAIFlyerLand;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityLostSoul
extends EntityMob
implements ColoredSpiritEntity {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityLostSoul.class, (DataSerializer)DataSerializers.field_187192_b);
    private int lifetime = -1;

    public EntityLostSoul(World world) {
        super(world);
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        ((PathNavigateFlying)this.func_70661_as()).func_192877_c(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected boolean func_70692_ba() {
        return true;
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateFlying((EntityLiving)this, world);
    }

    public void setLifetime(int i) {
        this.lifetime = i;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74774_a("SoulType", (byte)this.getSoulType());
        tag.func_74768_a("Lifetime", this.lifetime);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("SoulType")) {
            this.setSoulType(tag.func_74771_c("SoulType"));
        }
        this.lifetime = tag.func_74762_e("Lifetime");
    }

    public void func_70110_aj() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)this.field_70170_p.field_73012_v.nextInt(3));
    }

    public int getSoulType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setSoulType(int par1) {
        this.field_70180_af.func_187227_b(TYPE, (Object)par1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e).func_111128_a(0.4);
    }

    public boolean func_70652_k(Entity targetEntity) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (targetEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        DamageSource source = null;
        if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            switch (this.getSoulType()) {
                case 0: {
                    source = DamageSource.field_76372_a;
                    break;
                }
                case 1: {
                    source = DamageSource.func_76358_a((EntityLivingBase)this);
                    break;
                }
                case 2: {
                    source = DamageSource.field_76376_m;
                }
            }
        }
        if (source == null) {
            source = DamageSource.func_76358_a((EntityLivingBase)this);
        }
        if (flag = targetEntity.func_70097_a(source, f)) {
            int j;
            if (i > 0) {
                targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                targetEntity.func_70015_d(j * 4);
            }
            if (targetEntity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        float max = 15.0f;
        switch (this.getSoulType()) {
            case 0: {
                if (!source.func_76347_k() && !source.func_94541_c()) break;
                return super.func_70097_a(source, WitcheryUtils.capAround(damage, max));
            }
            case 1: {
                if (source.func_76352_a() || source.func_82725_o() || source.func_76347_k() || source.func_94541_c() || source == DamageSource.field_76368_d || source == DamageSource.field_76367_g || source == DamageSource.field_76369_e || source == DamageSource.field_82727_n) break;
                return super.func_70097_a(source, WitcheryUtils.capAround(damage, max));
            }
            case 2: {
                if (!source.func_82725_o()) break;
                return super.func_70097_a(source, WitcheryUtils.capAround(damage, max));
            }
        }
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.field_70170_p.field_72995_K && this.lifetime != -1 && --this.lifetime <= 0) {
            this.func_70106_y();
        }
    }

    @Override
    public int getColor() {
        switch (this.getSoulType()) {
            case 0: {
                return 0xFF0000;
            }
            case 1: {
                return 65280;
            }
            case 2: {
                return 255;
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.addParticle();
        }
    }

    private void addParticle() {
        int color2 = this.getColor();
        float red = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float green = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color2 & 0xFF) / 255.0f;
        WitcheryResurrectedClient.INSTANCE.addNaturePowerParticle(this.field_70170_p, this.field_70165_t - (double)this.field_70130_N * 0.5 + this.field_70170_p.field_73012_v.nextDouble() * (double)this.field_70130_N, 0.1 + this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() * 0.2, this.field_70161_v - (double)this.field_70130_N * 0.5 + this.field_70170_p.field_73012_v.nextDouble() * (double)this.field_70130_N, red, green, blue, 10, -0.1f);
    }

    public int func_70627_aG() {
        return super.func_70627_aG() * 2;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public boolean func_70601_bi() {
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
            boolean superGetCanSpawnHere = this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos pos = new BlockPos(i, j, k);
            superGetCanSpawnHere = superGetCanSpawnHere && this.func_180484_a(pos) >= 0.0f && j >= 60;
            Block blockID = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
            return superGetCanSpawnHere && this.field_70170_p.field_73012_v.nextInt(10) == 0 && (blockID == Blocks.field_150349_c || blockID == Blocks.field_150354_m) && this.field_70170_p.func_175699_k(pos) > 8;
        }
        return false;
    }
}

