/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.rites.WitcheryCurses;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;

public class EntityNightmare
extends EntityMob {
    private static final DataParameter<Optional<UUID>> VICTIM = EntityDataManager.func_187226_a(EntityNightmare.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityNightmare.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DEFENDED = EntityDataManager.func_187226_a(EntityNightmare.class, (DataSerializer)DataSerializers.field_187198_h);
    private int attackTimer;
    private int defenseTimer;

    public EntityNightmare(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, entity -> this.getVictimId() == null || entity != null && entity.func_110124_au().equals(this.getVictimId())));
        this.field_70728_aV = 25;
    }

    public int func_70627_aG() {
        return super.func_70627_aG() * 2;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VICTIM, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
        this.field_70180_af.func_187214_a(DEFENDED, (Object)false);
    }

    public void func_70110_aj() {
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    public void setScreaming(boolean par1) {
        this.field_70180_af.func_187227_b(SCREAMING, (Object)par1);
    }

    public boolean isDefended() {
        return (Boolean)this.field_70180_af.func_187225_a(DEFENDED);
    }

    public void setDefended(boolean par1) {
        this.field_70180_af.func_187227_b(DEFENDED, (Object)par1);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.setScreaming(this.func_70638_az() != null);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected int func_70682_h(int par1) {
        return par1;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        UUID victimId = this.getVictimId();
        if (victimId != null) {
            tag.func_186854_a("Victim", victimId);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_186855_b("Victim")) {
            this.setVictimId(tag.func_186857_a("Victim"));
        }
    }

    public UUID getVictimId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(VICTIM)).orNull();
    }

    public void setVictimId(UUID victim) {
        this.field_70180_af.func_187227_b(VICTIM, (Object)Optional.fromNullable((Object)victim));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.defenseTimer > 0 && --this.defenseTimer == 0) {
                this.setDefended(false);
            }
            if (!this.field_70128_L && this.getVictimId() != null && this.func_70638_az() != null && (this.func_70638_az().field_70128_L || this.func_70068_e((Entity)this.func_70638_az()) > 256.0) || this.field_70170_p.field_73012_v.nextInt(5) == 0 && this.func_70638_az() instanceof EntityPlayer && WitcheryUtils.getExtension((EntityPlayer)this.func_70638_az()).getSpiritData().getNightmareLevel() == SpiritWorldData.NightmareLevel.DREAM && !this.isWakingNightmare((EntityPlayer)this.func_70638_az())) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                this.func_70106_y();
            }
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    private boolean isWakingNightmare(EntityPlayer player) {
        int level = WitcheryDataExtensions.LIVING.get((EntityLivingBase)player).getCurses().getInt((Object)WitcheryCurses.getWakingNightmare());
        if (level > 0) {
            return true;
        }
        return player.func_70644_a(WitcheryPotionEffects.WAKING_NIGHTMARE);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 15;
        } else if (par1 == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(par1);
        }
    }

    public static int getItemSlotFromInventory(InventoryPlayer inventory, Item item) {
        return -1;
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        this.attackTimer = 15;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        if (entity instanceof EntityPlayer) {
            int index;
            EntityPlayer player = (EntityPlayer)entity;
            boolean found = false;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77973_b() != WitcheryIngredientItems.DISRUPTED_DREAMS_CHARM) continue;
                found = true;
                break;
            }
            if (!found && !((ItemStack)player.field_71071_by.field_70460_b.get(index = player.field_70170_p.field_73012_v.nextInt(player.field_71071_by.field_70460_b.size()))).func_190926_b()) {
                Infusion.dropEntityItemWithRandomChoice((EntityLivingBase)player, (ItemStack)player.field_71071_by.field_70460_b.get(index), true);
                player.field_71071_by.field_70460_b.set(index, (Object)ItemStack.field_190927_a);
            }
        }
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
            f = 0.5f;
        }
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entity).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(j * 4);
            }
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        EntityLivingBase living2;
        if (this.isDefended()) {
            return false;
        }
        boolean weakeningWeapon = false;
        if (source instanceof EntityDamageSource && source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase && !(living2 = (EntityLivingBase)source.func_76346_g()).func_184614_ca().func_190926_b() && living2.func_184614_ca().func_77973_b() == WitcheryGeneralItems.HUNTSMANS_SPEAR) {
            weakeningWeapon = true;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() != WitcheryBlocks.FLOWING_SPIRIT) {
            this.defenseTimer = WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this) ? (weakeningWeapon ? 40 : 80) : (weakeningWeapon ? 30 : 40);
            this.setDefended(true);
        }
        return super.func_70097_a(source, WitcheryUtils.capAround(damage, 15.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent func_184639_G() {
        return WitcherySounds.ENTITY_NIGHTMARE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_NIGHTMARE_DEATH;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_NIGHTMARE_HURT;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
            int chance = this.field_70146_Z.nextInt(Math.max(10 - par2, 5));
            int quantity = par2 > 0 && chance == 0 ? 2 : 1;
            this.func_70099_a(new ItemStack(WitcheryFumeItems.MELLIFLUOUS_HUNGER, quantity), 0.0f);
        }
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            UUID victim = this.getVictimId();
            if (victim != null && player.func_110124_au().equals(victim) && WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this)) {
                WitcheryUtils.getExtension(player).getSpiritData().setLastNightmareKill(this.field_70170_p.func_82737_E());
            }
        }
        super.func_70645_a(source);
    }

    protected boolean func_70692_ba() {
        return true;
    }
}

