/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityBrazier;
import net.msrandom.witchery.block.entity.TileEntityKettle;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityPoltergeist
extends EntitySummonedUndead
implements IEntityOwnable {
    private static final DataParameter<Optional<UUID>> SUMMONER = EntityDataManager.func_187226_a(EntityPoltergeist.class, (DataSerializer)DataSerializers.field_187203_m);
    private EntityPlayer summoner;
    private int attackTimer;

    public EntityPoltergeist(World world) {
        super(world);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMONER, (Object)Optional.absent());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 15;
        } else {
            super.func_70103_a(par1);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70173_aa % 100 == 0) {
            double radius = 16.0;
            AxisAlignedBB bounds = new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u - radius, this.field_70161_v - radius, this.field_70165_t + radius, this.field_70163_u + radius, this.field_70161_v + radius);
            List hangingItems = this.field_70170_p.func_72872_a(EntityHanging.class, bounds);
            for (EntityHanging hanging : hangingItems) {
                if (!(this.func_70068_e((Entity)hanging) <= radius * radius)) continue;
                if (this.func_70068_e((Entity)hanging) <= 9.0) {
                    if (!this.field_70170_p.field_72995_K) {
                        hanging.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
                    }
                    this.attackTimer = 15;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                } else {
                    this.func_70661_as().func_75492_a(hanging.field_70165_t, hanging.field_70163_u, hanging.field_70161_v, 1.0);
                }
                return;
            }
            EntityPlayer summoner = this.getOwner();
            if (summoner != null && this.func_70068_e((Entity)summoner) <= 64.0) {
                TileEntity closest = null;
                double closestDist = -1.0;
                for (TileEntity tile : this.field_70170_p.field_147482_g) {
                    double distSq;
                    if (!(tile instanceof IInventory) || tile instanceof TileEntityKettle || tile instanceof TileEntityBrazier || (distSq = this.func_70092_e(0.5 + (double)tile.func_174877_v().func_177958_n(), 0.5 + (double)tile.func_174877_v().func_177956_o(), 0.5 + (double)tile.func_174877_v().func_177952_p())) > 256.0) continue;
                    IInventory inventory = (IInventory)tile;
                    boolean hasItem = false;
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        if (inventory.func_70301_a(i).func_190926_b()) continue;
                        hasItem = true;
                        break;
                    }
                    if (!hasItem || closest != null && distSq >= closestDist) continue;
                    closest = tile;
                    closestDist = distSq;
                }
                if (closest != null) {
                    IInventory inventory2 = (IInventory)closest;
                    IntArrayList indices = new IntArrayList();
                    for (int j = 0; j < inventory2.func_70302_i_(); ++j) {
                        if (inventory2.func_70301_a(j).func_190926_b()) continue;
                        indices.add(j);
                    }
                    if (indices.size() > 0) {
                        if (this.func_174818_b(closest.func_174877_v()) <= 9.0) {
                            if (!this.field_70170_p.field_72995_K) {
                                int slot = indices.getInt(this.field_70170_p.field_73012_v.nextInt(indices.size()));
                                ItemStack stack = inventory2.func_70301_a(slot);
                                if (stack.func_190916_E() > 1) {
                                    stack.func_190918_g(1);
                                    stack = stack.func_77946_l();
                                    stack.func_190920_e(1);
                                } else {
                                    inventory2.func_70299_a(slot, ItemStack.field_190927_a);
                                }
                                EntityItem itemEntity = new EntityItem(this.field_70170_p, 0.5 + (double)closest.func_174877_v().func_177958_n(), 0.5 + (double)closest.func_174877_v().func_177956_o(), 0.5 + (double)closest.func_174877_v().func_177952_p(), stack);
                                this.field_70170_p.func_72838_d((Entity)itemEntity);
                                itemEntity.lifespan = 18000;
                                itemEntity.field_70159_w = -0.3 + this.field_70170_p.field_73012_v.nextDouble() * 0.6;
                                itemEntity.field_70181_x = 0.1 + this.field_70170_p.field_73012_v.nextDouble() * 0.2;
                                itemEntity.field_70179_y = -0.3 + this.field_70170_p.field_73012_v.nextDouble() * 0.6;
                            }
                            this.attackTimer = 15;
                            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                        } else {
                            this.func_70661_as().func_75492_a((double)closest.func_174877_v().func_177958_n(), (double)closest.func_174877_v().func_177956_o(), (double)closest.func_174877_v().func_177952_p(), 1.0);
                        }
                        return;
                    }
                }
            }
            List droppedItems = this.field_70170_p.func_72872_a(EntityItem.class, bounds);
            for (EntityItem dropped : droppedItems) {
                if (!(this.func_70068_e((Entity)dropped) <= 256.0)) continue;
                if (this.func_70068_e((Entity)dropped) <= 9.0) {
                    if (!this.field_70170_p.field_72995_K) {
                        dropped.field_70159_w = -0.3 + this.field_70170_p.field_73012_v.nextDouble() * 0.6;
                        dropped.field_70181_x = 0.1 + this.field_70170_p.field_73012_v.nextDouble() * 0.2;
                        dropped.field_70179_y = -0.3 + this.field_70170_p.field_73012_v.nextDouble() * 0.6;
                    }
                    this.attackTimer = 15;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                    continue;
                }
                this.func_70661_as().func_75492_a(dropped.field_70165_t, dropped.field_70163_u, dropped.field_70161_v, 1.0);
            }
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_SPECTRE_DEATH;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_SPECTRE_DEATH;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingData) {
        livingData = super.func_180482_a(difficulty, livingData);
        this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, Integer.MAX_VALUE));
        return livingData;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        UUID summonerId = this.func_184753_b();
        if (summonerId != null) {
            tag.func_186854_a("Summoner", summonerId);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_186855_b("Summoner")) {
            this.setSummonerId(tag.func_186857_a("Summoner"));
        }
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(SUMMONER)).orNull();
    }

    public EntityPlayer getOwner() {
        if (this.summoner == null) {
            this.summoner = WitcheryUtils.getPlayer(this.field_70170_p, this.func_184753_b());
        }
        return this.summoner;
    }

    public void setSummoner(EntityPlayer player) {
        this.summoner = player;
        this.setSummonerId(player.func_110124_au());
    }

    public void setSummonerId(UUID id) {
        this.func_110163_bv();
        this.field_70180_af.func_187227_b(SUMMONER, (Object)Optional.fromNullable((Object)id));
    }
}

