/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import kotlin.collections.CollectionsKt;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.entity.ReflectiveEntity;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.symbol.ConfudusSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ExpelliarmusSymbolEffect;
import net.msrandom.witchery.infusion.symbol.FlipendoSymbolEffect;
import net.msrandom.witchery.infusion.symbol.IgnianimaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ImpedimentaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcherySymbolEffects;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ItemCrossbowPistol;
import net.msrandom.witchery.item.bolts.ItemCrossbowBolt;
import net.msrandom.witchery.potion.PotionIllFitting;
import net.msrandom.witchery.resources.CreatureFormStatManager;
import net.msrandom.witchery.transformation.CreatureForm;
import net.msrandom.witchery.util.ElementWeight;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WeightedElement;
import net.msrandom.witchery.util.WeightedElementKt;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityReflection
extends EntityMob
implements IRangedAttackMob,
IHandleDeathTouch,
ReflectiveEntity {
    public static final List<WeightedElement<ProjectileSymbolEffect>> SPELLS = WeightedElementKt.toWeightedList(CollectionsKt.listOf(new ElementWeight<IgnianimaSymbolEffect>(14, WitcherySymbolEffects.IGNIANIMA), new ElementWeight<ExpelliarmusSymbolEffect>(2, WitcherySymbolEffects.EXPELLIARMUS), new ElementWeight<FlipendoSymbolEffect>(2, WitcherySymbolEffects.FLIPENDO), new ElementWeight<ImpedimentaSymbolEffect>(2, WitcherySymbolEffects.IMPEDIMENTA), new ElementWeight<ConfudusSymbolEffect>(1, WitcherySymbolEffects.CONFUNDUS)));
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityReflection.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<NBTTagCompound> ENTITY = EntityDataManager.func_187226_a(EntityReflection.class, (DataSerializer)DataSerializers.field_192734_n);
    private final EntityAIAttackRangedBow<EntityReflection> bowAttack = new EntityAIAttackRangedBow<EntityReflection>(this, 1.0, 20, 15.0f){

        protected boolean func_188498_f() {
            return super.func_188498_f() || EntityReflection.this.func_184592_cb().func_77973_b() instanceof ItemCrossbowPistol;
        }
    };
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
    private int attackTimer;
    private boolean freeSpawn;
    private int livingTicks = -1;
    private Task task;
    private EntityPlayer reflected;

    public EntityReflection(World world) {
        super(world);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70728_aV = 50;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(ENTITY, (Object)new NBTTagCompound());
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).orNull();
    }

    public void setOwnerId(UUID par1Str) {
        this.func_110163_bv();
        this.field_70180_af.func_187227_b(OWNER, (Object)Optional.fromNullable((Object)par1Str));
    }

    public EntityPlayer getOwner() {
        return WitcheryUtils.getPlayer(this.field_70170_p, this.getOwnerId());
    }

    @Override
    public EntityPlayer getReflected() {
        if (this.field_70170_p.field_72995_K && (this.field_70173_aa % 30 == 1 || this.reflected == null)) {
            this.reflected = Companion.getClientPlayer(this.field_70170_p, (NBTTagCompound)this.field_70180_af.func_187225_a(ENTITY));
        }
        return this.reflected;
    }

    public void setReflected(EntityPlayer reflected) {
        this.reflected = reflected;
        this.field_70180_af.func_187227_b(ENTITY, (Object)reflected.func_189511_e(new NBTTagCompound()));
    }

    public void setLifetime(int ticks) {
        this.livingTicks = ticks;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public void func_70110_aj() {
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        EntityPlayer owner = this.getOwner();
        return owner == null ? super.func_70005_c_() : owner.func_70005_c_();
    }

    protected int func_70682_h(int par1) {
        return par1;
    }

    protected void func_82167_n(Entity par1Entity) {
        super.func_82167_n(par1Entity);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70173_aa % 30 == 1) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack held;
                if (!this.freeSpawn && !WitcheryDimensions.MIRROR.isInDimension((Entity)this)) {
                    this.func_70106_y();
                    return;
                }
                if (this.livingTicks > -1 && --this.livingTicks == 0) {
                    this.func_70106_y();
                    return;
                }
                double R = 10.0;
                double RY = 8.0;
                AxisAlignedBB bounds = new AxisAlignedBB(this.field_70165_t - R, this.field_70163_u - RY, this.field_70161_v - R, this.field_70165_t + R, this.field_70163_u + RY, this.field_70161_v + R);
                List players = this.field_70170_p.func_72872_a(EntityPlayer.class, bounds);
                EntityPlayer ownerEntity = this.getOwner();
                boolean ownerFound = false;
                EntityPlayer closest = null;
                double distance = Double.MAX_VALUE;
                for (EntityPlayer player : players) {
                    double newDistance = player.func_70068_e((Entity)this);
                    if (closest == null || newDistance < distance) {
                        closest = player;
                        distance = newDistance;
                    }
                    if (ownerEntity != player) continue;
                    ownerFound = true;
                }
                if (ownerEntity == null || !ownerFound) {
                    if (closest != null) {
                        this.setOwnerId(closest.func_110124_au());
                    } else {
                        this.setOwnerId(null);
                    }
                }
                boolean resetGear = true;
                if (this.getOwnerId() != null) {
                    EntityPlayer owner;
                    EntityPlayer entityPlayer = owner = ownerEntity == null || !ownerFound ? this.getOwner() : ownerEntity;
                    if (owner != null) {
                        ItemStack offHand;
                        ItemStack mainHand;
                        for (int i = 2; i <= 5; ++i) {
                            EntityEquipmentSlot slot = PotionIllFitting.SLOTS[i];
                            ItemStack armor = owner.func_184582_a(slot);
                            if (!armor.func_190926_b()) {
                                armor = armor.func_77946_l();
                            }
                            this.func_184201_a(slot, armor);
                        }
                        ItemStack bestWeapon = ItemStack.field_190927_a;
                        ItemStack shield = ItemStack.field_190927_a;
                        ItemStack crossbow = ItemStack.field_190927_a;
                        double bestDamage = 0.0;
                        for (int hot = -1; hot < 9; ++hot) {
                            ItemStack hotbarItem;
                            ItemStack itemStack = hotbarItem = hot == -1 ? owner.func_184592_cb() : owner.field_71071_by.func_70301_a(hot);
                            if (hotbarItem.func_190926_b()) continue;
                            if (shield.func_190926_b() && hotbarItem.func_77975_n() == EnumAction.BLOCK) {
                                shield = hotbarItem;
                            }
                            if (crossbow.func_190926_b() && hotbarItem.func_77973_b() instanceof ItemCrossbowPistol) {
                                crossbow = hotbarItem;
                            }
                            double damage = 0.0;
                            for (AttributeModifier modifier : hotbarItem.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
                                if (modifier.func_111169_c() != 0) continue;
                                damage += modifier.func_111164_d();
                            }
                            if (!(damage > bestDamage)) continue;
                            bestWeapon = hotbarItem;
                            bestDamage = damage;
                        }
                        PlayerExtendedData playerEx = WitcheryUtils.getExtension(owner);
                        this.setReflected(owner);
                        if (!shield.func_190926_b() && shield == bestWeapon) {
                            mainHand = shield;
                            offHand = owner.func_184592_cb();
                        } else {
                            ItemStack bestOffHand;
                            ItemStack itemStack = bestOffHand = shield.func_190926_b() ? owner.func_184592_cb() : shield;
                            if (crossbow.func_190926_b()) {
                                mainHand = bestWeapon.func_190926_b() ? owner.func_184614_ca() : bestWeapon;
                                offHand = bestOffHand;
                            } else {
                                mainHand = bestOffHand.func_190926_b() ? bestWeapon : bestOffHand;
                                offHand = crossbow;
                            }
                        }
                        mainHand = mainHand.func_77946_l();
                        offHand = offHand.func_77946_l();
                        CreatureForm.Stats stats2 = CreatureFormStatManager.INSTANCE.getStats(playerEx.getEffectiveForm());
                        Ingredient holdableItem = stats2.getHoldableItem();
                        if (holdableItem != null) {
                            boolean held2 = false;
                            for (ItemStack matchingStack : holdableItem.func_193365_a()) {
                                if (!matchingStack.func_185136_b(mainHand)) continue;
                                held2 = true;
                                break;
                            }
                            if (!held2) {
                                mainHand = ItemStack.field_190927_a;
                            }
                            held2 = false;
                            for (ItemStack matchingStack : holdableItem.func_193365_a()) {
                                if (!matchingStack.func_185136_b(offHand)) continue;
                                held2 = true;
                                break;
                            }
                            if (!held2) {
                                offHand = ItemStack.field_190927_a;
                            }
                        }
                        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(stats2.getReflectionDamage());
                        ShapeShift.INSTANCE.initCurrentShift((EntityLivingBase)this, owner, false);
                        this.func_184611_a(EnumHand.MAIN_HAND, mainHand);
                        this.func_184611_a(EnumHand.OFF_HAND, offHand);
                        resetGear = false;
                        if (this.field_70173_aa % 60 == 1) {
                            this.func_70674_bp();
                            for (PotionEffect effect : owner.func_70651_bq()) {
                                this.func_70690_d(new PotionEffect(effect));
                            }
                        }
                    }
                }
                if (resetGear) {
                    for (EntityPlayer slot2 : EntityEquipmentSlot.values()) {
                        this.func_184201_a((EntityEquipmentSlot)slot2, ItemStack.field_190927_a);
                    }
                }
                if ((held = this.func_184614_ca()).func_77973_b() == WitcheryGeneralItems.MYSTIC_BRANCH || held.func_77973_b() instanceof ItemBow || this.func_184592_cb().func_77973_b() instanceof ItemCrossbowPistol) {
                    if (this.task != Task.RANGED) {
                        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
                    }
                    this.field_70714_bg.func_75776_a(2, this.bowAttack);
                    this.task = Task.RANGED;
                } else {
                    if (this.task != Task.MELEE) {
                        this.field_70714_bg.func_85156_a(this.bowAttack);
                    }
                    this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackOnCollide);
                    this.task = Task.MELEE;
                }
                if (this.func_70089_S() && this.func_70638_az() != null && this.func_70661_as().func_75500_f() && this.func_70635_at().func_75522_a((Entity)this.func_70638_az())) {
                    EntityLivingBase attackTarget = this.func_70638_az();
                    float par2 = 1.0f;
                    this.castSpell(attackTarget, par2, WitcherySymbolEffects.ATTRAHO);
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextDouble() < 0.05 && this.func_70638_az() != null && (this.func_70638_az().field_70160_al || this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75100_b) && !this.func_70638_az().func_70644_a(MobEffects.field_76421_d)) {
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 5));
            }
        }
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        WitcheryBlocks.MIRROR.demonSlain(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (!this.func_184587_cr()) {
            ItemStack mainHand = this.func_184614_ca();
            ItemStack offHand = this.func_184592_cb();
            Object blocking = mainHand.func_77975_n() == EnumAction.BLOCK ? EnumHand.MAIN_HAND : (offHand.func_77975_n() == EnumAction.BLOCK ? EnumHand.OFF_HAND : null);
            if (blocking != null && this.field_70146_Z.nextInt(3) != 0) {
                this.func_184598_c((EnumHand)blocking);
                return false;
            }
        }
        return super.func_70097_a(source, WitcheryUtils.capAround(damage, 6.0f));
    }

    @Override
    public float getCapDT(DamageSource source) {
        return 2.0f;
    }

    public void func_70014_b(NBTTagCompound nbtRoot) {
        super.func_70014_b(nbtRoot);
        UUID id = this.getOwnerId();
        if (id != null) {
            nbtRoot.func_186854_a("Owner", id);
        }
        nbtRoot.func_74757_a("FreeSpawn", this.freeSpawn);
        nbtRoot.func_74768_a("LivingTicks", this.livingTicks);
    }

    public void func_70037_a(NBTTagCompound nbtRoot) {
        super.func_70037_a(nbtRoot);
        if (nbtRoot.func_186855_b("Owner")) {
            this.setOwnerId(nbtRoot.func_186857_a("Owner"));
        }
        this.freeSpawn = nbtRoot.func_74767_n("FreeSpawn");
        this.livingTicks = nbtRoot.func_74762_e("LivingTicks");
    }

    public boolean func_70652_k(Entity par1Entity) {
        this.attackTimer = 10;
        return super.func_70652_k(par1Entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
        } else {
            super.func_70103_a(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return WitcherySounds.ENTITY_REFLECTION_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_REFLECTION_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WitcherySounds.ENTITY_REFLECTION_DEATH;
    }

    protected void func_70628_a(boolean par1, int par2) {
        this.func_70099_a(new ItemStack((Block)WitcheryBlocks.DEMON_HEART), 0.0f);
    }

    protected void func_82160_b(boolean p_82160_1_, int p_82160_2_) {
    }

    protected Item func_146068_u() {
        return null;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_82196_d(EntityLivingBase target, float par2) {
        if (this.func_184592_cb().func_77973_b() instanceof ItemCrossbowPistol) {
            ItemCrossbowPistol.Companion.launchNPCBolt(this.func_184592_cb(), this.field_70170_p, target, (EntityLiving)this, par2, (ItemCrossbowBolt)ItemCrossbowPistol.Companion.getProjectile(this.func_184592_cb()));
        } else {
            ItemStack held = this.func_184614_ca();
            if (held.func_190926_b()) {
                return;
            }
            this.attackTimer = 10;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            if (held.func_77973_b() == WitcheryGeneralItems.MYSTIC_BRANCH) {
                if (this.field_70170_p.field_73012_v.nextBoolean()) {
                    this.castSpell(target, par2, WeightedElementKt.getWeighted(SPELLS, this.field_70146_Z));
                }
            } else if (held.func_77973_b() == WitcheryGeneralItems.CROSSBOW_PISTOL) {
                ItemCrossbowPistol.Companion.launchNPCBolt(held, this.field_70170_p, target, (EntityLiving)this, par2);
            } else {
                EntityArrow entityarrow2 = ((ItemArrow)Items.field_151032_g).func_185052_a(this.field_70170_p, new ItemStack(Items.field_151032_g), (EntityLivingBase)this);
                double d0 = target.field_70165_t - this.field_70165_t;
                double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow2.field_70163_u;
                double d2 = target.field_70161_v - this.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                entityarrow2.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 3));
                int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)this.func_184614_ca());
                int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)this.func_184614_ca());
                entityarrow2.func_70239_b((double)(par2 * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
                if (i > 0) {
                    entityarrow2.func_70239_b(entityarrow2.func_70242_d() + (double)i * 0.5 + 0.5);
                }
                if (j > 0) {
                    entityarrow2.func_70240_a(j);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)this.func_184614_ca()) > 0) {
                    entityarrow2.func_70015_d(100);
                }
                this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72838_d((Entity)entityarrow2);
            }
        }
    }

    public void func_184724_a(boolean b) {
    }

    private void castSpell(EntityLivingBase targetEntity, float par2, ProjectileSymbolEffect spell) {
        double d0 = targetEntity.field_70165_t - this.field_70165_t;
        double d2 = targetEntity.func_174813_aQ().field_72338_b + (double)(targetEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d3 = targetEntity.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76129_c((float)par2) * 0.5f;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175718_b(1009, this.func_180425_c(), 0);
            EntitySpellEffect effect = new EntitySpellEffect(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d2, d3 + this.field_70146_Z.nextGaussian() * (double)f1, spell, 1);
            effect.field_70165_t = this.field_70165_t;
            effect.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f);
            effect.field_70161_v = this.field_70161_v;
            this.field_70170_p.func_72838_d((Entity)effect);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data2) {
        this.freeSpawn = true;
        return super.func_180482_a(difficulty, data2);
    }

    private static enum Task {
        MELEE,
        RANGED;

    }
}

