/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockCircleGlyph;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ritual.SmallRitual;
import net.msrandom.witchery.client.particle.ParticleNaturePower;
import net.msrandom.witchery.client.resources.BrewColorsManager;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityRitualItem
extends EntityItem {
    private ActiveRitual currentSetup;
    private boolean locationTested;
    private boolean containsUnfinishedRitual;
    private int color = -1;

    public EntityRitualItem(World world) {
        super(world);
    }

    public EntityRitualItem(EntityItem entityItem) {
        super(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, entityItem.func_92059_d());
        this.func_174867_a(entityItem.field_145804_b);
        this.field_70159_w = entityItem.field_70159_w;
        this.field_70181_x = entityItem.field_70181_x;
        this.field_70179_y = entityItem.field_70179_y;
    }

    public void func_70100_b_(EntityPlayer player) {
        double minPickupRange = 0.75;
        double minPickupRangeSq = minPickupRange * minPickupRange;
        if (this.func_70068_e((Entity)player) <= minPickupRangeSq) {
            super.func_70100_b_(player);
        }
    }

    public void func_70071_h_() {
        if (this.field_70292_b >= 5 && this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v)).func_185904_a().func_76220_a()) {
            double xDiff = this.field_70165_t - this.field_70169_q;
            double zDiff = this.field_70161_v - this.field_70166_s;
            if (xDiff * xDiff + zDiff * zDiff > 1.21) {
                this.currentSetup = null;
                this.locationTested = false;
                this.field_70292_b = 5;
            }
            super.func_70071_h_();
            if (!this.locationTested && this.currentSetup == null) {
                SmallRitual ritual = SmallRitual.rituals.get(this.func_92059_d().func_77973_b());
                BlockPos circleCenter = null;
                BlockPos currentPosition = this.func_180425_c();
                int size = ritual.getCircle().getSize();
                for (int x = -size; x <= size; ++x) {
                    for (int z = -size; z <= size; ++z) {
                        BlockPos position = currentPosition.func_177982_a(x, 0, z);
                        AtomicReference block = new AtomicReference();
                        AtomicBoolean hasActive = new AtomicBoolean();
                        HashSet toReset = new HashSet();
                        WitcheryUtils.findCircleBlocks(position, size, pos -> {
                            IBlockState state = this.field_70170_p.func_180495_p(pos);
                            if (block.get() == null) {
                                if (WitcheryUtils.isAir(state, (IBlockAccess)this.field_70170_p, pos) || state.func_177230_c() != ritual.getCircle().getGlyph()) {
                                    return false;
                                }
                                block.set(state.func_177230_c());
                                if (state.func_177228_b().containsKey((Object)BlockCircleGlyph.ACTIVE)) {
                                    hasActive.set(true);
                                }
                            } else if (state.func_177230_c() != block.get()) {
                                block.set(null);
                                for (BlockPos blockPos : toReset) {
                                    IBlockState oldState = this.field_70170_p.func_180495_p(blockPos);
                                    if (!oldState.func_177228_b().containsKey((Object)BlockCircleGlyph.ACTIVE)) continue;
                                    this.field_70170_p.func_175656_a(blockPos, oldState.func_177226_a((IProperty)BlockCircleGlyph.ACTIVE, (Comparable)Boolean.valueOf(false)));
                                }
                                return false;
                            }
                            if (hasActive.get()) {
                                toReset.add(pos);
                                this.field_70170_p.func_175656_a(pos, state.func_177226_a((IProperty)BlockCircleGlyph.ACTIVE, (Comparable)Boolean.valueOf(true)));
                            }
                            return true;
                        });
                        if (block.get() == null) continue;
                        circleCenter = position;
                        break;
                    }
                    if (circleCenter == null) continue;
                    this.currentSetup = new ActiveRitual(ritual, circleCenter);
                    break;
                }
                this.locationTested = true;
            }
            if (this.currentSetup != null) {
                if (this.field_70170_p.field_72995_K) {
                    this.addParticles();
                } else if (this.field_70292_b >= 80 && this.currentSetup.center != null) {
                    switch (this.currentSetup.ritual.activate(this.field_70170_p, this, this.func_92059_d(), this.currentSetup.center)) {
                        case DONE: {
                            this.func_70106_y();
                            break;
                        }
                        case EXPLODE: {
                            WitcheryUtils.findCircleBlocks(this.currentSetup.center, this.currentSetup.ritual.getCircle().getSize(), arg_0 -> ((World)this.field_70170_p).func_175698_g(arg_0));
                            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                            this.currentSetup = null;
                            this.func_70106_y();
                            break;
                        }
                        case NO_POWER: {
                            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                            this.field_70292_b = 40;
                        }
                    }
                }
            }
        } else {
            super.func_70071_h_();
        }
    }

    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.containsUnfinishedRitual = true;
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
        }
        super.func_70103_a(id);
    }

    @SideOnly(value=Side.CLIENT)
    private void addParticles() {
        if (this.color == -1) {
            Item item = Item.func_150898_a((Block)this.currentSetup.ritual.getCircle().getGlyph());
            this.color = item == Items.field_190931_a ? 59030 : BrewColorsManager.INSTANCE.getColor(ItemKey.get(item));
        }
        int red = this.color >> 16 & 0xFF;
        int green = this.color >> 8 & 0xFF;
        int blue = this.color & 0xFF;
        double distance = this.containsUnfinishedRitual ? 0.0 : (double)(80 - this.field_70292_b) / 80.0;
        for (int i = 0; i <= (this.containsUnfinishedRitual ? 4 : Math.min(Math.max(this.field_70292_b / 8, 10), 5)); ++i) {
            float f = this.field_70146_Z.nextFloat() * 0.6f + 0.4f;
            double xPos = this.field_70146_Z.nextDouble() * 0.8 - 0.4;
            double zPos = this.field_70146_Z.nextDouble() * 0.8 - 0.4;
            double d0 = this.field_70165_t + xPos;
            double d2 = this.field_70163_u + 0.4;
            double d3 = this.field_70161_v + zPos;
            double maxSpeed = 0.04;
            double doubleSpeed = 0.08;
            ParticleNaturePower sparkle2 = new ParticleNaturePower(this.field_70170_p, d0, d2, d3, this.field_70146_Z.nextDouble() * doubleSpeed - maxSpeed, this.field_70146_Z.nextDouble() * 0.05 + 0.08, this.field_70146_Z.nextDouble() * doubleSpeed - maxSpeed);
            sparkle2.setSpeed(distance + 0.5);
            sparkle2.setCircling(true);
            sparkle2.setScale(this.field_70146_Z.nextFloat() * 0.2f + 0.5f);
            sparkle2.setGravity(0.25f);
            sparkle2.setCanMove(true);
            sparkle2.func_187114_a(this.containsUnfinishedRitual ? 5 : 10 + this.field_70146_Z.nextInt(10));
            sparkle2.func_70538_b(f * ((float)red / 255.0f), f * ((float)green / 255.0f), f * ((float)blue / 255.0f));
            sparkle2.func_82338_g(0.1f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)sparkle2);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.resetRitual();
    }

    private void resetRitual() {
        if (this.currentSetup != null) {
            WitcheryUtils.findCircleBlocks(this.currentSetup.center, this.currentSetup.ritual.getCircle().getSize(), pos -> {
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (!state.func_177228_b().containsKey((Object)BlockCircleGlyph.ACTIVE)) {
                    return false;
                }
                this.field_70170_p.func_175656_a(pos, state.func_177226_a((IProperty)BlockCircleGlyph.ACTIVE, (Comparable)Boolean.valueOf(false)));
                return true;
            });
        }
    }

    private static class ActiveRitual {
        private final SmallRitual ritual;
        private final BlockPos center;

        public ActiveRitual(SmallRitual ritual, BlockPos center) {
            this.ritual = ritual;
            this.center = center;
        }
    }
}

