/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.WorldProviderSpiritWorld;

public class EntitySleepingBody
extends EntityLiving {
    private static final DataParameter<NBTTagCompound> OWNER = EntityDataManager.func_187226_a(EntitySleepingBody.class, (DataSerializer)DataSerializers.field_192734_n);
    private EntityPlayer player;

    public EntitySleepingBody(World world) {
        super(world);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)new NBTTagCompound());
    }

    protected boolean func_184645_a(EntityPlayer par1EntityPlayer, EnumHand hand) {
        return true;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K || par1DamageSource == DamageSource.field_76380_i) {
            return super.func_70097_a(par1DamageSource, par2);
        }
        if (par1DamageSource.func_76364_f() != null && par1DamageSource.func_76364_f() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76364_f()).field_71075_bZ.field_75098_d) {
            return super.func_70097_a(par1DamageSource, par2);
        }
        if (this.player != null) {
            return super.func_70097_a(par1DamageSource, par2);
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("Owner", (NBTBase)this.field_70180_af.func_187225_a(OWNER));
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("Owner")) {
            this.field_70180_af.func_187227_b(OWNER, (Object)tag.func_74775_l("Owner"));
        }
    }

    public UUID getOwnerId() {
        return ((NBTTagCompound)this.field_70180_af.func_187225_a(OWNER)).func_186857_a("UUID");
    }

    public EntityPlayer getOwner() {
        if (this.player == null) {
            this.player = this.field_70170_p.field_72995_K ? this.getClientPlayer((NBTTagCompound)this.field_70180_af.func_187225_a(OWNER)) : (EntityPlayer)((WorldServer)this.field_70170_p).func_175733_a(this.getOwnerId());
        }
        return this.player;
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer(NBTTagCompound tag) {
        NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
        if (connection == null) {
            return null;
        }
        NetworkPlayerInfo playerInfo = connection.func_175102_a(tag.func_186857_a("UUID"));
        if (playerInfo == null) {
            return null;
        }
        EntityOtherPlayerMP player = new EntityOtherPlayerMP(this.field_70170_p, playerInfo.func_178845_a());
        player.func_70020_e(tag);
        return player;
    }

    public void setOwnerData(NBTTagCompound data2) {
        this.func_110163_bv();
        this.field_70180_af.func_187227_b(OWNER, (Object)data2);
    }

    public void setOwner(EntityPlayer player) {
        this.setOwnerData(player.func_189511_e(new NBTTagCompound()));
        this.player = player;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (!this.field_70170_p.field_72995_K && this.player != null) {
            if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)this.player)) {
                WorldProviderSpiritWorld.returnPlayerToOverworld(this.player);
            }
            if (WitcheryUtils.getExtension(this.player).getSpiritData().isGhost()) {
                WorldProviderSpiritWorld.returnGhostPlayerToSpiritWorld(this.player);
                WorldProviderSpiritWorld.returnPlayerToOverworld(this.player);
            }
        }
    }
}

