/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.ai.EntityAIFamiliarFindDiamonds;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class EntitySpectralFamiliar
extends EntityOcelot {
    private static final DataParameter<Byte> ITEM_ID = EntityDataManager.func_187226_a(EntitySpectralFamiliar.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final Item[] ITEMS = new Item[]{Items.field_151045_i, Items.field_151166_bC, Items.field_151043_k, Items.field_151042_j, Items.field_151137_ax, Items.field_151100_aR, Items.field_151044_h};
    private static final Block[] ORES = new Block[]{Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150352_o, Blocks.field_150366_p, Blocks.field_150450_ax, Blocks.field_150369_x, Blocks.field_150365_q};
    private static final int[] ORE_DEPTH = new int[]{14, 14, 30, 64, 16, 30, 64};
    private int searches = 0;

    public EntitySpectralFamiliar(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFamiliarFindDiamonds(this, 1.33));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIOcelotAttack((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70912_b(1);
        this.field_70180_af.func_187214_a(ITEM_ID, (Object)-1);
    }

    public int getItemIDToFind() {
        return ((Byte)this.field_70180_af.func_187225_a(ITEM_ID)).byteValue();
    }

    public void setItemIDToFind(int itemID) {
        this.field_70180_af.func_187227_b(ITEM_ID, (Object)((byte)itemID));
    }

    public void func_70014_b(NBTTagCompound nbtTag) {
        super.func_70014_b(nbtTag);
        nbtTag.func_74768_a("ItemToFind", this.getItemIDToFind());
        nbtTag.func_74768_a("Searches", this.searches);
    }

    public void func_70037_a(NBTTagCompound nbtTag) {
        super.func_70037_a(nbtTag);
        this.setItemIDToFind(nbtTag.func_74762_e("ItemToFind"));
        this.searches = nbtTag.func_74762_e("Searches");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    public boolean func_70652_k(Entity par1Entity) {
        return par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.5f);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K) {
            ItemStack item = player.func_184614_ca();
            int itemToFind = this.hasOre(item);
            if (itemToFind != -1) {
                this.setItemIDToFind(itemToFind);
                ++this.searches;
                item.func_190918_g(1);
                double[] probs = new double[]{0.0, 0.6, 0.75, 0.85, 0.95};
                double chance = this.field_70170_p.field_73012_v.nextDouble();
                if (this.searches > 5 || this.searches > 1 && chance < probs[Math.max(this.searches - 1, 1)]) {
                    this.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                    this.func_70106_y();
                } else {
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, this.func_184176_by(), 0.5f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public Block getBlockIDToFind() {
        int idToFind = this.getItemIDToFind();
        if (idToFind != -1) {
            return ORES[idToFind];
        }
        return null;
    }

    public void clearItemToFind() {
        this.setItemIDToFind(-1);
    }

    public int getDepthToFind() {
        int idToFind = this.getItemIDToFind();
        if (idToFind != -1) {
            return ORE_DEPTH[idToFind];
        }
        return 1;
    }

    private int hasOre(ItemStack item) {
        if (item == null) {
            return -1;
        }
        return Arrays.asList(ITEMS).indexOf(item.func_77973_b());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected void func_70628_a(boolean par1, int par2) {
        this.func_70099_a(new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST), 0.0f);
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return false;
    }

    public boolean func_70878_b(EntityAnimal par1EntityAnimal) {
        return false;
    }

    public EntityOcelot func_90011_a(EntityAgeable par1EntityAgeable) {
        return null;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data2) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        return data2;
    }

    public void setAISitting(boolean b) {
        this.field_70911_d.func_75270_a(b);
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }
}

